/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.java.plugins.ChangeParametersPlugin;
import org.netbeans.modules.refactoring.java.plugins.CopyClassRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldsPlugin;
import org.netbeans.modules.refactoring.java.plugins.ExtractInterfaceRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.ExtractSuperclassRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.InnerToOuterRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.java.plugins.MoveRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PullUpRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PushDownRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.SafeDeleteRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.UseSuperTypeRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.EncapsulateFieldsRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public class JavaRefactoringsFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        Lookup lookup = abstractRefactoring.getRefactoringSource();
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
        TreePathHandle treePathHandle = (TreePathHandle)lookup.lookup(TreePathHandle.class);
        if (abstractRefactoring instanceof WhereUsedQuery) {
            if (treePathHandle != null) {
                return new JavaWhereUsedQueryPlugin((WhereUsedQuery)abstractRefactoring);
            }
        } else if (abstractRefactoring instanceof RenameRefactoring) {
            if (treePathHandle != null || fileObject != null && RetoucheUtils.isJavaFile(fileObject)) {
                return new RenameRefactoringPlugin((RenameRefactoring)abstractRefactoring);
            }
            if (fileObject != null && RetoucheUtils.isOnSourceClasspath(fileObject) && fileObject.isFolder()) {
                return new MoveRefactoringPlugin((RenameRefactoring)abstractRefactoring);
            }
            if (nonRecursiveFolder != null && RetoucheUtils.isOnSourceClasspath(nonRecursiveFolder.getFolder())) {
                return new MoveRefactoringPlugin((RenameRefactoring)abstractRefactoring);
            }
        } else if (abstractRefactoring instanceof SafeDeleteRefactoring) {
            if (this.checkSafeDelete(abstractRefactoring.getRefactoringSource())) {
                return new SafeDeleteRefactoringPlugin((SafeDeleteRefactoring)abstractRefactoring);
            }
        } else if (abstractRefactoring instanceof MoveRefactoring) {
            if (this.checkMove(abstractRefactoring.getRefactoringSource())) {
                return new MoveRefactoringPlugin((MoveRefactoring)abstractRefactoring);
            }
        } else if (abstractRefactoring instanceof SingleCopyRefactoring) {
            if (this.checkCopy(abstractRefactoring.getRefactoringSource())) {
                return new CopyClassRefactoringPlugin((SingleCopyRefactoring)abstractRefactoring);
            }
        } else if (treePathHandle != null) {
            if (abstractRefactoring instanceof ExtractInterfaceRefactoring) {
                return new ExtractInterfaceRefactoringPlugin((ExtractInterfaceRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof ExtractSuperclassRefactoring) {
                return new ExtractSuperclassRefactoringPlugin((ExtractSuperclassRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof PullUpRefactoring) {
                return new PullUpRefactoringPlugin((PullUpRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof PushDownRefactoring) {
                return new PushDownRefactoringPlugin((PushDownRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof UseSuperTypeRefactoring) {
                return new UseSuperTypeRefactoringPlugin((UseSuperTypeRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof InnerToOuterRefactoring) {
                return new InnerToOuterRefactoringPlugin((InnerToOuterRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof ChangeParametersRefactoring) {
                return new ChangeParametersPlugin((ChangeParametersRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof EncapsulateFieldRefactoring) {
                return new EncapsulateFieldRefactoringPlugin((EncapsulateFieldRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof EncapsulateFieldsRefactoring) {
                return new EncapsulateFieldsPlugin((EncapsulateFieldsRefactoring)abstractRefactoring);
            }
        }
        return null;
    }

    private boolean checkMove(Lookup lookup) {
        for (FileObject fileObject : lookup.lookupAll(FileObject.class)) {
            if (RetoucheUtils.isJavaFile(fileObject)) {
                return true;
            }
            if (!fileObject.isFolder()) continue;
            return true;
        }
        return false;
    }

    private boolean checkSafeDelete(Lookup lookup) {
        boolean bl = false;
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
        if (nonRecursiveFolder != null) {
            return true;
        }
        for (FileObject fileObject : lookup.lookupAll(FileObject.class)) {
            bl = true;
            if (RetoucheUtils.isJavaFile(fileObject) || JavaRefactoringsFactory.isPackage(fileObject)) continue;
            return false;
        }
        if (lookup.lookup(TreePathHandle.class) != null) {
            return true;
        }
        return bl;
    }

    private boolean checkCopy(Lookup lookup) {
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        return fileObject != null && RetoucheUtils.isJavaFile(fileObject);
    }

    private static boolean isPackage(FileObject fileObject) {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            return false;
        }
        return dataObject instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject) && !RetoucheUtils.isClasspathRoot(fileObject);
    }
}

