/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.project.NameAndLocationPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.project.SelectProjectPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

final class NewProjectIterator
extends BasicWizardIterator {
    private DataModel data;
    public static final String[] MODULES = new String[]{"org.openide.filesystems", "org.openide.loaders", "org.openide.dialogs", "org.openide.util", "org.netbeans.modules.projectuiapi", "org.netbeans.modules.projectapi", "org.openide.awt"};

    private NewProjectIterator() {
    }

    public static NewProjectIterator createIterator() {
        return new NewProjectIterator();
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return NewProjectIterator.getCreatedFiles(cmf, this.data.getProject());
    }

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new SelectProjectPanel(wiz, this.data), new NameAndLocationPanel(wiz, this.data)};
    }

    @Override
    public void uninitialize(WizardDescriptor wiz) {
        super.uninitialize(wiz);
        this.data = null;
    }

    public static void generateFileChanges(DataModel model) {
        CreatedModifiedFiles fileChanges = new CreatedModifiedFiles(model.getProject());
        Project project = model.getProject();
        NbModuleProvider moduleInfo = model.getModuleInfo();
        String category = model.getCategory();
        String displayName = model.getDisplayName();
        String name = model.getName();
        String packageName = model.getPackageName();
        HashMap<String, String> replaceTokens = new HashMap<String, String>();
        replaceTokens.put("CATEGORY", category);
        replaceTokens.put("DISPLAYNAME", displayName);
        replaceTokens.put("TEMPLATENAME", name);
        replaceTokens.put("PACKAGENAME", packageName);
        String descName = NewProjectIterator.getRelativePath(moduleInfo.getResourceDirectoryPath(false), packageName, name, "Description.html");
        FileObject template = CreatedModifiedFiles.getTemplate("templateDescription.html");
        fileChanges.add(fileChanges.createFileWithSubstitutions(descName, template, replaceTokens));
        for (int i = 0; i < MODULES.length; ++i) {
            fileChanges.add(fileChanges.addModuleDependency(MODULES[i]));
        }
        fileChanges.add(fileChanges.bundleKeyDefaultBundle(category + "/" + name + "Project.zip", displayName));
        String bundlePath = NewProjectIterator.getRelativePath(moduleInfo.getResourceDirectoryPath(false), packageName, "", "Bundle.properties");
        fileChanges.add(fileChanges.bundleKey(bundlePath, "LBL_CreateProjectStep", "Name and Location"));
        FileObject xml = LayerHandle.forProject(project).getLayerFile();
        FileObject parent = xml != null ? xml.getParent() : null;
        Set<String> externalFiles = Collections.singleton(LayerUtils.findGeneratedName(parent, name + "Project.zip"));
        fileChanges.add(fileChanges.layerModifications(new CreateProjectZipOperation(model.getTemplate(), name, packageName, category, ManifestManager.getInstance(Util.getManifest(moduleInfo.getManifestFile()), false)), externalFiles));
        String iteratorName = NewProjectIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "WizardIterator.java");
        template = CreatedModifiedFiles.getTemplate("templateWizardIterator.java");
        fileChanges.add(fileChanges.createFileWithSubstitutions(iteratorName, template, replaceTokens));
        String panelName = NewProjectIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "WizardPanel.java");
        template = CreatedModifiedFiles.getTemplate("templateWizardPanel.java");
        fileChanges.add(fileChanges.createFileWithSubstitutions(panelName, template, replaceTokens));
        String formName = NewProjectIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "PanelVisual.form");
        template = CreatedModifiedFiles.getTemplate("templatePanelVisual.form");
        fileChanges.add(fileChanges.createFileWithSubstitutions(formName, template, replaceTokens));
        String panelVisName = NewProjectIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "PanelVisual.java");
        template = CreatedModifiedFiles.getTemplate("templatePanelVisual.java");
        fileChanges.add(fileChanges.createFileWithSubstitutions(panelVisName, template, replaceTokens));
        model.setCreatedModifiedFiles(fileChanges);
    }

    private static String getRelativePath(String rootPath, String fullyQualifiedPackageName, String prefix, String postfix) {
        StringBuffer sb = new StringBuffer();
        sb.append(rootPath).append('/').append(fullyQualifiedPackageName.replace('.', '/')).append('/').append(prefix).append(postfix);
        return sb.toString();
    }

    private static void createProjectZip(OutputStream target, Project source) throws IOException {
        Sources srcs = ProjectUtils.getSources((Project)source);
        SourceGroup[] grps = srcs.getSourceGroups("generic");
        SourceGroup group = grps[0];
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        NewProjectIterator.collectFiles(group.getRootFolder(), files, SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)group.getRootFolder())));
        NewProjectIterator.createZipFile(target, group.getRootFolder(), files);
    }

    private static void collectFiles(FileObject parent, Collection<FileObject> accepted, int parentSharab) {
        for (FileObject fo : parent.getChildren()) {
            int sharab;
            if (!VisibilityQuery.getDefault().isVisible(fo) || (sharab = parentSharab == 0 || parentSharab == 3 ? SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)fo)) : parentSharab) == 2) continue;
            if (fo.isData() && !fo.isVirtual()) {
                accepted.add(fo);
                continue;
            }
            if (!fo.isFolder()) continue;
            accepted.add(fo);
            NewProjectIterator.collectFiles(fo, accepted, sharab);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createZipFile(OutputStream target, FileObject root, Collection files) throws IOException {
        ZipOutputStream str = null;
        try {
            str = new ZipOutputStream(target);
            for (FileObject fo : files) {
                String path = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
                if (fo.isFolder() && !path.endsWith("/")) {
                    path = path + "/";
                }
                ZipEntry entry = new ZipEntry(path);
                str.putNextEntry(entry);
                if (fo.isData()) {
                    InputStream in = null;
                    try {
                        in = fo.getInputStream();
                        FileUtil.copy((InputStream)in, (OutputStream)str);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                str.closeEntry();
            }
        }
        finally {
            if (str != null) {
                str.close();
            }
        }
    }

    static class CreateProjectZipOperation
    implements CreatedModifiedFiles.LayerOperation {
        private final String name;
        private final String packageName;
        private final Project templateProject;
        private final String category;
        private final ManifestManager manifestManager;

        public CreateProjectZipOperation(Project template, String name, String packageName, String category, ManifestManager manifestManager) {
            this.packageName = packageName;
            this.name = name;
            this.category = category;
            this.manifestManager = manifestManager;
            this.templateProject = template;
        }

        @Override
        public void run(FileSystem layer) throws IOException {
            FileObject folder = layer.getRoot().getFileObject(this.category);
            if (folder == null) {
                folder = FileUtil.createFolder((FileObject)layer.getRoot(), (String)this.category);
            }
            FileObject file = folder.createData(this.name + "Project", "zip");
            NewProjectIterator.createProjectZip(file.getOutputStream(), this.templateProject);
            String bundlePath = this.manifestManager.getLocalizingBundle();
            String suffix = ".properties";
            if (bundlePath != null && bundlePath.endsWith(suffix)) {
                bundlePath = bundlePath.substring(0, bundlePath.length() - suffix.length()).replace('/', '.');
                file.setAttribute("displayName", (Object)("bundlevalue:" + bundlePath + "#" + this.category + "/" + this.name + "Project.zip"));
            }
            file.setAttribute("template", (Object)Boolean.TRUE);
            URL descURL = new URL("nbresloc:/" + this.packageName.replace('.', '/') + "/" + this.name + "Description.html");
            file.setAttribute("instantiatingWizardURL", (Object)descURL);
            file.setAttribute("instantiatingIterator", (Object)("methodvalue:" + this.packageName + "." + this.name + "WizardIterator.createIterator"));
        }
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private Project template;
        private String name;
        private String displayName;
        private String category;
        private CreatedModifiedFiles files;

        DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.getFiles();
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.setFiles(files);
        }

        public Project getTemplate() {
            return this.template;
        }

        public void setTemplate(Project template) {
            this.template = template;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public CreatedModifiedFiles getFiles() {
            return this.files;
        }

        public void setFiles(CreatedModifiedFiles files) {
            this.files = files;
        }
    }
}

