/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.UnknownRepositoryLayoutException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;

public class DefaultArtifactRepositoryFactory
implements ArtifactRepositoryFactory {
    private String globalUpdatePolicy;
    private String globalChecksumPolicy;
    private final Map<String, ArtifactRepository> artifactRepositories = new HashMap<String, ArtifactRepository>();
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;

    public ArtifactRepositoryLayout getLayout(String layoutId) throws UnknownRepositoryLayoutException {
        return this.repositoryLayouts.get(layoutId);
    }

    public ArtifactRepository createDeploymentArtifactRepository(String id, String url, String layoutId, boolean uniqueVersion) throws UnknownRepositoryLayoutException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(layoutId);
        this.checkLayout(id, layoutId, layout);
        return this.createDeploymentArtifactRepository(id, url, layout, uniqueVersion);
    }

    private void checkLayout(String repositoryId, String layoutId, ArtifactRepositoryLayout layout) throws UnknownRepositoryLayoutException {
        if (layout == null) {
            throw new UnknownRepositoryLayoutException(repositoryId, layoutId);
        }
    }

    public ArtifactRepository createDeploymentArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, boolean uniqueVersion) {
        return new DefaultArtifactRepository(id, url, repositoryLayout, uniqueVersion);
    }

    public ArtifactRepository createArtifactRepository(String id, String url, String layoutId, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) throws UnknownRepositoryLayoutException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(layoutId);
        this.checkLayout(id, layoutId, layout);
        return this.createArtifactRepository(id, url, layout, snapshots, releases);
    }

    public ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        ArtifactRepository repository;
        boolean blacklisted = false;
        if (this.artifactRepositories.containsKey(id) && (repository = this.artifactRepositories.get(id)).getUrl().equals(url)) {
            blacklisted = repository.isBlacklisted();
        }
        if (snapshots == null) {
            snapshots = new ArtifactRepositoryPolicy();
        }
        if (releases == null) {
            releases = new ArtifactRepositoryPolicy();
        }
        if (this.globalUpdatePolicy != null) {
            snapshots.setUpdatePolicy(this.globalUpdatePolicy);
            releases.setUpdatePolicy(this.globalUpdatePolicy);
        }
        if (this.globalChecksumPolicy != null) {
            snapshots.setChecksumPolicy(this.globalChecksumPolicy);
            releases.setChecksumPolicy(this.globalChecksumPolicy);
        }
        repository = new DefaultArtifactRepository(id, url, repositoryLayout, snapshots, releases);
        ((DefaultArtifactRepository)repository).setBlacklisted(blacklisted);
        this.artifactRepositories.put(id, repository);
        return repository;
    }

    public void setGlobalUpdatePolicy(String updatePolicy) {
        this.globalUpdatePolicy = updatePolicy;
    }

    public void setGlobalChecksumPolicy(String checksumPolicy) {
        this.globalChecksumPolicy = checksumPolicy;
    }

    public ArtifactRepository createLocalRepository(File localRepositoryDirectory) throws InvalidRepositoryException {
        DefaultArtifactRepository repo;
        ArtifactRepositoryLayout layout = this.getLayout("default");
        try {
            repo = new DefaultArtifactRepository("local", localRepositoryDirectory.toURI().toURL().toExternalForm(), layout, new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy());
        }
        catch (MalformedURLException e) {
            throw new InvalidRepositoryException("Invalid local repository directory: " + localRepositoryDirectory + ". Cannot render URL.", "local", e);
        }
        repo.setBasedir(localRepositoryDirectory.getAbsolutePath());
        return repo;
    }
}

