/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.swing.outline;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.netbeans.modules.websvc.manager.swing.outline.ExtTreeWillExpandListener;
import org.netbeans.modules.websvc.manager.swing.outline.OutlineModel;

public final class TreePathSupport {
    private OutlineModel mdl;
    private Map expandedPaths = new HashMap();
    private List eListeners = new ArrayList();
    private List weListeners = new ArrayList();
    private AbstractLayoutCache layout;

    public TreePathSupport(OutlineModel mdl, AbstractLayoutCache layout) {
        this.mdl = mdl;
        this.layout = layout;
    }

    public void clear() {
        this.expandedPaths.clear();
    }

    public void expandPath(TreePath path) {
        if (Boolean.TRUE.equals(this.expandedPaths.get(path))) {
            return;
        }
        TreeExpansionEvent e = new TreeExpansionEvent(this, path);
        try {
            this.fireTreeWillExpand(e, true);
            this.expandedPaths.put(path, Boolean.TRUE);
            this.layout.setExpandedState(path, true);
            this.fireTreeExpansion(e, true);
        }
        catch (ExpandVetoException eve) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, eve.getLocalizedMessage(), eve);
            this.fireTreeExpansionVetoed(e, eve);
        }
    }

    public void collapsePath(TreePath path) {
        if (Boolean.FALSE.equals(this.expandedPaths.get(path))) {
            return;
        }
        TreeExpansionEvent e = new TreeExpansionEvent(this, path);
        try {
            this.fireTreeWillExpand(e, false);
            this.expandedPaths.put(path, Boolean.FALSE);
            this.layout.setExpandedState(path, false);
            this.fireTreeExpansion(e, false);
        }
        catch (ExpandVetoException eve) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, eve.getLocalizedMessage(), eve);
            this.fireTreeExpansionVetoed(e, eve);
        }
    }

    public void removePath(TreePath path) {
        this.expandedPaths.remove(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeExpansion(TreeExpansionEvent e, boolean expanded) {
        int size = this.eListeners.size();
        TreeExpansionListener[] listeners = new TreeExpansionListener[size];
        TreePathSupport treePathSupport = this;
        synchronized (treePathSupport) {
            listeners = this.eListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (expanded) {
                listeners[i].treeExpanded(e);
                continue;
            }
            listeners[i].treeCollapsed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeWillExpand(TreeExpansionEvent e, boolean expanded) throws ExpandVetoException {
        int size = this.eListeners.size();
        TreeWillExpandListener[] listeners = new TreeWillExpandListener[size];
        TreePathSupport treePathSupport = this;
        synchronized (treePathSupport) {
            listeners = this.weListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (expanded) {
                listeners[i].treeWillExpand(e);
                continue;
            }
            listeners[i].treeWillCollapse(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeExpansionVetoed(TreeExpansionEvent e, ExpandVetoException ex) {
        int size = this.eListeners.size();
        TreeWillExpandListener[] listeners = new TreeWillExpandListener[size];
        TreePathSupport treePathSupport = this;
        synchronized (treePathSupport) {
            listeners = this.weListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ExtTreeWillExpandListener)) continue;
            ((ExtTreeWillExpandListener)listeners[i]).treeExpansionVetoed(e, ex);
        }
    }

    public boolean hasBeenExpanded(TreePath path) {
        return path != null && this.expandedPaths.get(path) != null;
    }

    public boolean isExpanded(TreePath path) {
        if (path == null) {
            return false;
        }
        Object value = this.expandedPaths.get(path);
        if (value == null || !((Boolean)value).booleanValue()) {
            return false;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath != null) {
            return this.isExpanded(parentPath);
        }
        return true;
    }

    protected void removeDescendantToggledPaths(Enumeration toRemove) {
        if (toRemove != null) {
            while (toRemove.hasMoreElements()) {
                TreePath[] descendants = this.getDescendantToggledPaths((TreePath)toRemove.nextElement());
                for (int i = 0; i < descendants.length; ++i) {
                    this.expandedPaths.remove(descendants[i]);
                }
            }
        }
    }

    protected TreePath[] getDescendantToggledPaths(TreePath parent) {
        if (parent == null) {
            return null;
        }
        ArrayList<TreePath> descendants = new ArrayList<TreePath>();
        for (TreePath path : this.expandedPaths.keySet()) {
            if (!parent.isDescendant(path)) continue;
            descendants.add(path);
        }
        TreePath[] result = new TreePath[descendants.size()];
        return descendants.toArray(result);
    }

    public boolean isVisible(TreePath path) {
        if (path != null) {
            TreePath parentPath = path.getParentPath();
            if (parentPath != null) {
                return this.isExpanded(parentPath);
            }
            return true;
        }
        return false;
    }

    public TreePath[] getExpandedDescendants(TreePath parent) {
        TreePath[] result = new TreePath[]{};
        if (this.isExpanded(parent)) {
            ArrayList<TreePath> results = null;
            if (!this.expandedPaths.isEmpty()) {
                for (TreePath path : this.expandedPaths.keySet()) {
                    Object value = this.expandedPaths.get(path);
                    if (path == parent || value == null || !((Boolean)value).booleanValue() || !parent.isDescendant(path) || !this.isVisible(path)) continue;
                    if (results == null) {
                        results = new ArrayList<TreePath>();
                    }
                    results.add(path);
                }
                if (results != null) {
                    result = results.toArray(result);
                }
            }
        }
        return result;
    }

    public synchronized void addTreeExpansionListener(TreeExpansionListener l) {
        this.eListeners.add(l);
    }

    public synchronized void removeTreeExpansionListener(TreeExpansionListener l) {
        this.eListeners.remove(l);
    }

    public synchronized void addTreeWillExpandListener(TreeExpansionListener l) {
        this.weListeners.add(l);
    }

    public synchronized void removeTreeWillExpandListener(TreeExpansionListener l) {
        this.weListeners.remove(l);
    }
}

