/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.swing.outline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.websvc.manager.swing.outline.DefaultOutlineModel;
import org.netbeans.modules.websvc.manager.swing.outline.Outline;
import org.netbeans.modules.websvc.manager.swing.outline.OutlineModel;
import org.netbeans.modules.websvc.manager.swing.outline.RenderDataProvider;
import org.netbeans.modules.websvc.manager.swing.outline.RowModel;
import org.openide.util.Utilities;

public class TestOutline
extends JFrame {
    private Outline outline;

    public TestOutline() {
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        TreeModel treeMdl = TestOutline.createModel();
        OutlineModel mdl = DefaultOutlineModel.createOutlineModel(treeMdl, new FileRowModel(), true);
        this.outline = new Outline();
        this.outline.setRenderDataProvider(new RenderData());
        this.outline.setRootVisible(true);
        this.outline.setModel(mdl);
        this.getContentPane().add((Component)new JScrollPane(this.outline), "Center");
        this.setBounds(20, 20, 700, 400);
    }

    public static TreeModel createModel() {
        FileTreeModel treeMdl = new FileTreeModel(File.listRoots()[Utilities.isWindows() ? 1 : 0]);
        return treeMdl;
    }

    public static void main(String[] ignored) {
        new TestOutline().show();
    }

    private static class FileTreeModel
    implements TreeModel {
        private File root;

        public FileTreeModel(File root) {
            this.root = root;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public Object getChild(Object parent, int index) {
            File f = (File)parent;
            return f.listFiles()[index];
        }

        @Override
        public int getChildCount(Object parent) {
            File f = (File)parent;
            if (!f.isDirectory()) {
                return 0;
            }
            return f.list().length;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            File par = (File)parent;
            File ch = (File)child;
            return Arrays.asList(par.listFiles()).indexOf(ch);
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object node) {
            File f = (File)node;
            return !f.isDirectory();
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }

    private class RenderData
    implements RenderDataProvider {
        private RenderData() {
        }

        @Override
        public Color getBackground(Object o) {
            return null;
        }

        @Override
        public String getDisplayName(Object o) {
            return ((File)o).getName();
        }

        @Override
        public Color getForeground(Object o) {
            File f = (File)o;
            if (!f.isDirectory() && !f.canWrite()) {
                return UIManager.getColor("controlShadow");
            }
            return null;
        }

        @Override
        public Icon getIcon(Object o) {
            return null;
        }

        @Override
        public String getTooltipText(Object o) {
            File f = (File)o;
            return f.getAbsolutePath();
        }

        @Override
        public boolean isHtmlDisplayName(Object o) {
            return false;
        }
    }

    private class FileRowModel
    implements RowModel {
        private FileRowModel() {
        }

        @Override
        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Date.class;
                }
                case 1: {
                    return Long.class;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Date" : "Size";
        }

        @Override
        public Object getValueFor(Object node, int column) {
            File f = (File)node;
            switch (column) {
                case 0: {
                    return new Date(f.lastModified());
                }
                case 1: {
                    return new Long(f.length());
                }
            }
            assert (false);
            return null;
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        @Override
        public void setValueFor(Object node, int column, Object value) {
        }
    }
}

