/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.tld;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.web.core.syntax.tld.LibraryDescriptor;
import org.netbeans.modules.web.core.syntax.tld.LibraryDescriptorException;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TldLibrary
extends LibraryDescriptor {
    public static TldLibrary create(FileObject definitionFile) throws LibraryDescriptorException {
        return new TldLibrary(definitionFile);
    }

    static TldLibrary create(InputStream content) throws LibraryDescriptorException {
        return new TldLibrary(content);
    }

    public TldLibrary() {
    }

    private TldLibrary(FileObject definitionFile) throws LibraryDescriptorException {
        super(definitionFile);
        this.parseLibrary();
    }

    private TldLibrary(InputStream content) throws LibraryDescriptorException {
        super(content);
        this.parseLibrary(content);
    }

    public static String parseNamespace(InputStream content) {
        return TldLibrary.parseNamespace(content, "taglib", "uri");
    }

    @Override
    protected void parseLibrary(InputStream content) throws LibraryDescriptorException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputSource is = new InputSource(content);
            is.setEncoding("UTF-8");
            docBuilder.setEntityResolver(UserCatalog.getDefault().getEntityResolver());
            Document doc = docBuilder.parse(is);
            Node tagLib = TldLibrary.getNodeByName(doc, "taglib");
            this.prefix = TldLibrary.getTextContent(tagLib, "short-name");
            if (this.prefix == null) {
                this.prefix = "";
            }
            this.uri = TldLibrary.getTextContent(tagLib, "uri");
            if (this.uri == null) {
                throw new LibraryDescriptorException("Missing uri entry in " + this.getDefinitionFile().getPath() + " library.", null);
            }
            this.displayName = TldLibrary.getTextContent(tagLib, "display-name");
            NodeList tagNodes = doc.getElementsByTagName("tag");
            if (tagNodes != null) {
                for (int i = 0; i < tagNodes.getLength(); ++i) {
                    Node tag = tagNodes.item(i);
                    String tagName = TldLibrary.getTextContent(tag, "name");
                    String tagDescription = TldLibrary.getTextContent(tag, "description");
                    HashMap<String, LibraryDescriptor.Attribute> attrs = new HashMap<String, LibraryDescriptor.Attribute>();
                    for (Node attrNode : TldLibrary.getNodesByName(tag, "attribute")) {
                        String aName = TldLibrary.getTextContent(attrNode, "name");
                        String aDescription = TldLibrary.getTextContent(attrNode, "description");
                        boolean aRequired = Boolean.parseBoolean(TldLibrary.getTextContent(attrNode, "required"));
                        attrs.put(aName, new LibraryDescriptor.Attribute(aName, aDescription, aRequired));
                    }
                    this.tags.put(tagName, new LibraryDescriptor.TagImpl(tagName, tagDescription, attrs));
                }
            }
        }
        catch (ParserConfigurationException ex) {
            throw new LibraryDescriptorException("Error parsing TLD library: ", ex);
        }
        catch (SAXException ex) {
            throw new LibraryDescriptorException("Error parsing TLD library: ", ex);
        }
        catch (IOException ex) {
            throw new LibraryDescriptorException("Error parsing TLD library: ", ex);
        }
    }
}

