/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.InfoPanel;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.java.JavaI18nFinder;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaPropertyPanel;
import org.netbeans.modules.i18n.java.JavaReplacePanel;
import org.netbeans.modules.i18n.java.JavaResourceHolder;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class JavaI18nSupport
extends I18nSupport {
    protected Set<Modifier> modifiers = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
    protected String identifier;
    protected boolean generateField;
    protected String initFormat = I18nUtil.getOptions().getInitJavaCode();
    private JavaReplacePanel additionalCustomizer;
    private static final String octalDigitChars = "01234567";
    private static final String hexaDigitChars = "0123456789abcdefABCDEF";

    public JavaI18nSupport(DataObject dataObject) {
        super(dataObject);
    }

    @Override
    protected I18nSupport.I18nFinder createFinder() {
        return new JavaI18nFinder(this.document);
    }

    @Override
    protected I18nSupport.I18nReplacer createReplacer() {
        return new JavaI18nReplacer();
    }

    @Override
    protected ResourceHolder createResourceHolder() {
        return new JavaResourceHolder();
    }

    @Override
    public I18nString getDefaultI18nString(HardCodedString hardCodedString) {
        String string;
        Object object;
        JavaI18nString javaI18nString = new JavaI18nString(this);
        ResourceHolder resourceHolder = javaI18nString.getSupport().getResourceHolder();
        if (resourceHolder.getResource() == null && (object = I18nUtil.getOptions().getLastResource2(this.sourceDataObject)) != null) {
            string = this.sourceDataObject.getPrimaryFile();
            FileObject fileObject = object.getPrimaryFile();
            ClassPath classPath = ClassPath.getClassPath((FileObject)string, (String)"classpath/execute");
            if (classPath != null && classPath.getResourceName(fileObject) != null) {
                resourceHolder.setResource((DataObject)object);
            }
        }
        if (hardCodedString == null) {
            return javaI18nString;
        }
        object = JavaI18nSupport.decodeUnicodeSeq(hardCodedString.getText());
        string = ((String)object).toUpperCase();
        javaI18nString.setKey(string);
        javaI18nString.setValue((String)object);
        javaI18nString.setComment("");
        if (this.isGenerateField() && javaI18nString.getReplaceFormat().indexOf("{identifier}") == -1) {
            javaI18nString.setReplaceFormat(I18nUtil.getReplaceFormatItems().get(0));
        }
        return javaI18nString;
    }

    private static String decodeUnicodeSeq(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        char[] cArray2 = new char[3];
        int n4 = 0;
        int n5 = 0;
        block12: while (n5 < cArray.length) {
            n = cArray[n5++];
            switch (n2) {
                case 0: {
                    if (n == 92) {
                        n2 = 1;
                        continue block12;
                    }
                    stringBuilder.append((char)n);
                    continue block12;
                }
                case 1: {
                    if (n == 117) {
                        n2 = 2;
                        continue block12;
                    }
                    if (n >= 48 && n <= 51) {
                        n3 = n - 48;
                        assert (n3 >= 0 && n3 <= 3);
                        n4 = 1;
                        n2 = 3;
                        continue block12;
                    }
                    stringBuilder.append('\\').append((char)n);
                    n2 = 0;
                    continue block12;
                }
                case 3: {
                    int n6 = octalDigitChars.indexOf(n);
                    if (n6 >= 0) {
                        n3 = n3 << 3 | n6;
                        ++n4;
                    } else {
                        --n5;
                    }
                    if (n6 >= 0 && n4 != 3) continue block12;
                    JavaI18nSupport.appendChar(stringBuilder, n3);
                    n2 = 0;
                    n4 = 0;
                    n3 = 0;
                    continue block12;
                }
                case 2: {
                    int n6 = hexaDigitChars.indexOf(n);
                    if (n6 >= 0) {
                        if (n6 > 15) {
                            n6 -= 6;
                        }
                        assert (n6 <= 15);
                        n3 = n3 << 4 | n6;
                        if (++n4 == 4) {
                            JavaI18nSupport.appendChar(stringBuilder, n3);
                            n2 = 0;
                        } else {
                            cArray2[n4 - 1] = n;
                        }
                    } else if (n != 117) {
                        stringBuilder.append('\\');
                        stringBuilder.append('u');
                        for (int i = 0; i < n4; ++i) {
                            stringBuilder.append(cArray2[i]);
                        }
                        stringBuilder.append((char)n);
                        n2 = 0;
                    }
                    if (n2 == 2) continue block12;
                    n4 = 0;
                    n3 = 0;
                    continue block12;
                }
            }
            assert (false);
            throw new IllegalStateException();
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                stringBuilder.append('\\');
                break;
            }
            case 3: {
                assert (n4 >= 0 && n4 < 3);
                JavaI18nSupport.appendChar(stringBuilder, n3);
                break;
            }
            case 2: {
                assert (n4 >= 0 && n4 < 4);
                stringBuilder.append('\\').append('u');
                for (n = 0; n < n4; ++n) {
                    stringBuilder.append(cArray2[n]);
                }
                break;
            }
            default: {
                assert (false);
                throw new IllegalStateException();
            }
        }
        return stringBuilder.toString();
    }

    private static final StringBuilder appendChar(StringBuilder stringBuilder, int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("value out of range: " + n);
        }
        if (n >= 32 && n != 127) {
            stringBuilder.append((char)n);
        } else {
            stringBuilder.append('\\');
            switch (n) {
                case 8: {
                    stringBuilder.append('b');
                    break;
                }
                case 9: {
                    stringBuilder.append('t');
                    break;
                }
                case 10: {
                    stringBuilder.append('n');
                    break;
                }
                case 12: {
                    stringBuilder.append('f');
                    break;
                }
                case 13: {
                    stringBuilder.append('r');
                    break;
                }
                default: {
                    stringBuilder.append('u');
                    for (int i = 12; i >= 0; i -= 4) {
                        stringBuilder.append(hexaDigitChars.charAt(n >> i & 0xF));
                    }
                }
            }
        }
        return stringBuilder;
    }

    @Override
    public JPanel getInfo(HardCodedString hardCodedString) {
        return new JavaInfoPanel(hardCodedString, this.document);
    }

    public String getIdentifier() {
        if (this.identifier == null || this.identifier == "") {
            this.createIdentifier();
        }
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Set<Modifier> set) {
        this.modifiers = set;
    }

    public boolean isGenerateField() {
        return this.generateField;
    }

    public void setGenerateField(boolean bl) {
        this.generateField = bl;
    }

    public String getInitFormat() {
        return this.initFormat;
    }

    public void setInitFormat(String string) {
        this.initFormat = string;
    }

    @Override
    public PropertyPanel getPropertyPanel() {
        return new JavaPropertyPanel();
    }

    @Override
    public boolean hasAdditionalCustomizer() {
        return true;
    }

    @Override
    public JPanel getAdditionalCustomizer() {
        if (this.additionalCustomizer == null) {
            this.additionalCustomizer = new JavaReplacePanel(this);
        }
        return this.additionalCustomizer;
    }

    @Override
    public void performAdditionalChanges() {
        this.createField();
    }

    public void createIdentifier() {
        String string;
        try {
            string = this.resourceHolder.getResource().getName();
        }
        catch (NullPointerException nullPointerException) {
            this.identifier = "";
            return;
        }
        string = string.length() > 0 ? string.substring(0, 1).toLowerCase() + string.substring(1) : string.toLowerCase();
        this.identifier = string;
    }

    private void createField() {
        if (!this.isGenerateField()) {
            return;
        }
        JavaSource javaSource = JavaSource.forDocument((Document)this.document);
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AddFieldTask(this.getIdentifier()));
            modificationResult.commit();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(4096, (Throwable)exception);
        }
    }

    public String getInitString() {
        String string = this.getInitFormat();
        FileObject fileObject = this.resourceHolder.getResource().getPrimaryFile();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("bundleNameSlashes", classPath.getResourceName(fileObject, '/', false));
        hashMap.put("bundleNameDots", classPath.getResourceName(fileObject, '.', false));
        hashMap.put("sourceFileName", this.sourceDataObject != null ? this.sourceDataObject.getPrimaryFile().getName() : "");
        return MapFormat.format((String)string, hashMap);
    }

    public static class Factory
    extends I18nSupport.Factory {
        @Override
        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new JavaI18nSupport(dataObject);
        }

        @Override
        public Class getDataObjectClass() {
            try {
                return Class.forName("org.netbeans.modules.java.JavaDataObject", false, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    private static class JavaInfoPanel
    extends InfoPanel {
        public JavaInfoPanel(HardCodedString hardCodedString, StyledDocument styledDocument) {
            super(hardCodedString, styledDocument);
        }

        @Override
        protected void setHardCodedString(HardCodedString hardCodedString, StyledDocument styledDocument) {
            String string;
            this.getStringText().setText(hardCodedString == null ? "" : hardCodedString.getText());
            if (hardCodedString.getStartPosition() == null) {
                string = "";
            } else {
                int n = hardCodedString.getStartPosition().getOffset();
                try {
                    Element element = styledDocument.getParagraphElement(n);
                    string = styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()).trim();
                }
                catch (BadLocationException badLocationException) {
                    string = "";
                }
            }
            this.getFoundInText().setText(string);
            this.remove(this.getComponentLabel());
            this.remove(this.getComponentText());
            this.remove(this.getPropertyLabel());
            this.remove(this.getPropertyText());
        }
    }

    public static class JavaI18nReplacer
    implements I18nSupport.I18nReplacer {
        @Override
        public void replace(final HardCodedString hardCodedString, I18nString i18nString) {
            if (!(i18nString instanceof JavaI18nString)) {
                throw new IllegalArgumentException("I18N module: i18nString have to be an instance of JavaI18nString.");
            }
            final String string = i18nString.getReplaceString();
            final StyledDocument styledDocument = i18nString.getSupport().getDocument();
            NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (hardCodedString.getLength() > 0) {
                            styledDocument.remove(hardCodedString.getStartPosition().getOffset(), hardCodedString.getLength());
                        }
                        if (string != null && string.length() > 0) {
                            styledDocument.insertString(hardCodedString.getEndPosition().getOffset(), string, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JavaI18nSupport.class, (String)"MSG_CouldNotReplace"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                }
            });
        }
    }

    private final class AddFieldTask
    implements Task<WorkingCopy> {
        private final String fieldName;

        AddFieldTask(String string) {
            this.fieldName = string;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            TypeElement typeElement = this.getClass(workingCopy);
            if (typeElement == null) {
                return;
            }
            List<? extends javax.lang.model.element.Element> list = typeElement.getEnclosedElements();
            List<VariableElement> list2 = ElementFilter.fieldsIn(list);
            if (this.containsField(list2, this.fieldName)) {
                return;
            }
            int n = this.findTargetPosition(list, list2);
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            Elements elements = workingCopy.getElements();
            Trees trees = workingCopy.getTrees();
            TreeUtilities treeUtilities = workingCopy.getTreeUtilities();
            TypeElement typeElement2 = elements.getTypeElement("java.util.ResourceBundle");
            assert (typeElement2 != null);
            ExpressionTree expressionTree = treeUtilities.parseVariableInitializer(JavaI18nSupport.this.getInitString(), new SourcePositions[1]);
            TreePath treePath = trees.getPath(typeElement);
            Scope scope = trees.getScope(treePath);
            if (scope != null) {
                treeUtilities.attributeTree((Tree)expressionTree, scope);
            }
            VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(JavaI18nSupport.this.modifiers), (CharSequence)this.fieldName, (Tree)treeMaker.QualIdent((javax.lang.model.element.Element)typeElement2), (ExpressionTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)expressionTree));
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            ClassTree classTree2 = n != -1 ? treeMaker.insertClassMember(classTree, n, (Tree)variableTree) : treeMaker.addClassMember(classTree, (Tree)variableTree);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }

        private int findTargetPosition(List<? extends javax.lang.model.element.Element> list, List<? extends VariableElement> list2) {
            if (list2.isEmpty()) {
                return 0;
            }
            int n = 0;
            boolean bl = false;
            Iterator<? extends javax.lang.model.element.Element> iterator = list.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                javax.lang.model.element.Element element = iterator.next();
                ElementKind elementKind = element.getKind();
                if (elementKind.isField() && elementKind != ElementKind.ENUM_CONSTANT && element.getModifiers().contains((Object)Modifier.STATIC)) {
                    bl = true;
                } else if (bl) {
                    bl = false;
                    n = n2;
                }
                ++n2;
            }
            return !bl ? n : -1;
        }

        private TypeElement getClass(WorkingCopy workingCopy) throws IOException {
            workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            String string = JavaI18nSupport.this.sourceDataObject.getName();
            TypeElement typeElement = null;
            List list = workingCopy.getTopLevelElements();
            for (TypeElement typeElement2 : list) {
                ElementKind elementKind = typeElement2.getKind();
                if (!elementKind.isClass()) continue;
                if (typeElement2.getSimpleName().contentEquals(string)) {
                    return typeElement2;
                }
                if (typeElement != null || !typeElement2.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                typeElement = typeElement2;
            }
            return typeElement;
        }

        private boolean containsField(List<? extends VariableElement> list, String string) {
            if (!list.isEmpty()) {
                for (VariableElement variableElement : list) {
                    if (!variableElement.getSimpleName().contentEquals(string)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

