/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.javahelp.Help;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.EmptyPropertyPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.PropertyPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class I18nPanel
extends JPanel {
    private static final String CONTENT_FORM = "form visible";
    private static final String CONTENT_MESG = "message visible";
    private final boolean withButtons;
    private final CardLayout cardLayout = new CardLayout();
    private I18nString i18nString;
    private ResourceBundle bundle;
    private PropertyChangeListener propListener;
    static final long serialVersionUID = -6982482491017390786L;
    private Project project;
    private FileObject file;
    static final long ALL_BUTTONS = 0xFFFFFFL;
    static final long NO_BUTTONS = 0L;
    static final long REPLACE_BUTTON = 983040L;
    static final long SKIP_BUTTON = 61440L;
    static final long INFO_BUTTON = 3840L;
    static final long CANCEL_BUTTON = 240L;
    static final long HELP_BUTTON = 15L;
    private boolean contentsShown;
    private JButton cancelButton;
    private JPanel contentsPanelPlaceholder;
    private JButton helpButton;
    private JButton infoButton;
    private JButton replaceButton;
    private JButton skipButton;
    private EmptyPropertyPanel emptyPanel;
    private PropertyPanel propertyPanel;

    public I18nPanel(PropertyPanel propertyPanel, Project project, FileObject file) {
        this(propertyPanel, true, project, file);
    }

    public I18nPanel(PropertyPanel propertyPanel, boolean withButtons, Project project, FileObject file) {
        this.project = project;
        this.file = file;
        this.propertyPanel = propertyPanel;
        this.propertyPanel.setFile(file);
        this.propertyPanel.setEnabled(project != null);
        this.emptyPanel = new EmptyPropertyPanel();
        this.bundle = I18nUtil.getBundle();
        this.withButtons = withButtons;
        this.initComponents();
        this.myInitComponents();
        this.initAccessibility();
        this.showBundleMessage("TXT_SearchingForStrings");
    }

    public void showBundleMessage(String bundleKey) {
        this.emptyPanel.setBundleText(bundleKey);
        this.cardLayout.show(this.contentsPanelPlaceholder, CONTENT_MESG);
        this.contentsShown = false;
        this.buttonsEnableDisable();
    }

    public void showPropertyPanel() {
        this.cardLayout.show(this.contentsPanelPlaceholder, CONTENT_FORM);
        this.contentsShown = true;
        this.buttonsEnableDisable();
    }

    public void setFile(FileObject file) {
        this.propertyPanel.setFile(file);
    }

    public FileObject getFile() {
        return this.propertyPanel.getFile();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.withButtons && SwingUtilities.isDescendingFrom(this.replaceButton, this)) {
            this.getRootPane().setDefaultButton(this.replaceButton);
        }
    }

    public I18nString getI18nString() {
        return this.i18nString;
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        this.propertyPanel.setI18nString(i18nString);
        this.showPropertyPanel();
    }

    JButton getReplaceButton() {
        assert (this.withButtons);
        return this.replaceButton;
    }

    JButton getSkipButton() {
        assert (this.withButtons);
        return this.skipButton;
    }

    JButton getInfoButton() {
        assert (this.withButtons);
        return this.infoButton;
    }

    JButton getCancelButton() {
        assert (this.withButtons);
        return this.cancelButton;
    }

    private void buttonsEnableDisable() {
        if (!this.withButtons) {
            return;
        }
        if (this.contentsShown) {
            this.enableButtons(0xFFFFFFL);
            boolean isBundle = this.i18nString != null && this.i18nString.getSupport().getResourceHolder().getResource() != null;
            boolean keyEmpty = this.getI18nString() == null || this.getI18nString().getKey() == null || this.getI18nString().getKey().trim().length() == 0;
            this.replaceButton.setEnabled(isBundle && !keyEmpty);
        } else {
            this.enableButtons(255L);
        }
    }

    public void setDefaultResource(DataObject dataObject) {
        FileObject fo;
        ClassPath cp;
        if (dataObject != null && (cp = ClassPath.getClassPath((FileObject)(fo = dataObject.getPrimaryFile()), (String)"classpath/source")) != null) {
            for (FileObject folder = cp.findResource(cp.getResourceName(fo.getParent())); folder != null && cp.contains(folder); folder = folder.getParent()) {
                Enumeration data;
                String rn = cp.getResourceName(folder) + "/Bundle.properties";
                FileObject peer = cp.findResource(rn);
                if (peer == null && (data = Enumerations.filter((Enumeration)folder.getData(false), (Enumerations.Processor)new Enumerations.Processor(){

                    public Object process(Object obj, Collection alwaysNull) {
                        if (obj instanceof FileObject && "properties".equals(((FileObject)obj).getExt())) {
                            return obj;
                        }
                        return null;
                    }
                })).hasMoreElements()) {
                    peer = (FileObject)data.nextElement();
                }
                if (peer == null) continue;
                try {
                    DataObject peerDataObject = DataObject.find((FileObject)peer);
                    this.propertyPanel.setResource(peerDataObject);
                    return;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_I18nPanel"));
        if (this.withButtons) {
            this.skipButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_SkipButton"));
            this.cancelButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_CancelButton"));
            this.replaceButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_ReplaceButton"));
            this.infoButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_InfoButton"));
            this.helpButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_HelpButton"));
        }
    }

    private void initComponents() {
        this.contentsPanelPlaceholder = new JPanel(this.cardLayout);
        if (this.withButtons) {
            this.replaceButton = new JButton();
            this.skipButton = new JButton();
            this.infoButton = new JButton();
            this.cancelButton = new JButton();
            this.helpButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.replaceButton, (String)this.bundle.getString("CTL_ReplaceButton"));
            Mnemonics.setLocalizedText((AbstractButton)this.skipButton, (String)this.bundle.getString("CTL_SkipButton"));
            Mnemonics.setLocalizedText((AbstractButton)this.infoButton, (String)this.bundle.getString("CTL_InfoButton"));
            Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)this.bundle.getString("CTL_CloseButton"));
            Mnemonics.setLocalizedText((AbstractButton)this.helpButton, (String)this.bundle.getString("CTL_HelpButton"));
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    I18nPanel.this.helpButtonActionPerformed(evt);
                }
            });
        }
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        GroupLayout.SequentialGroup horizGroup = layout.createSequentialGroup();
        horizGroup.addContainerGap();
        if (this.withButtons) {
            horizGroup.add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.contentsPanelPlaceholder).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.replaceButton).addPreferredGap(0).add((Component)this.skipButton).addPreferredGap(0).add((Component)this.infoButton).addPreferredGap(0).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.helpButton)));
            layout.linkSize(new Component[]{this.cancelButton, this.helpButton, this.infoButton, this.replaceButton, this.skipButton}, 1);
        } else {
            horizGroup.add((Component)this.contentsPanelPlaceholder);
        }
        horizGroup.addContainerGap();
        layout.setHorizontalGroup((GroupLayout.Group)horizGroup);
        GroupLayout.SequentialGroup vertGroup = layout.createSequentialGroup();
        vertGroup.addContainerGap();
        vertGroup.add((Component)this.contentsPanelPlaceholder);
        if (this.withButtons) {
            vertGroup.add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.helpButton).add((Component)this.cancelButton).add((Component)this.infoButton).add((Component)this.skipButton).add((Component)this.replaceButton));
        }
        vertGroup.addContainerGap();
        layout.setVerticalGroup((GroupLayout.Group)vertGroup);
    }

    private void myInitComponents() {
        this.contentsPanelPlaceholder.add((Component)this.propertyPanel, CONTENT_FORM);
        this.contentsPanelPlaceholder.add((Component)this.emptyPanel, CONTENT_MESG);
        this.cardLayout.show(this.contentsPanelPlaceholder, CONTENT_FORM);
        this.contentsShown = true;
        if (this.withButtons) {
            this.propertyPanel.addPropertyChangeListener("propString", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    I18nPanel.this.buttonsEnableDisable();
                }
            });
            this.propertyPanel.addPropertyChangeListener("property_resource", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("property_resource".equals(evt.getPropertyName())) {
                        I18nPanel.this.buttonsEnableDisable();
                    }
                }
            });
        }
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        assert (this.withButtons);
        HelpCtx help = new HelpCtx("internation.autoinsert");
        String sysprop = System.getProperty("org.openide.actions.HelpAction.DEBUG");
        if ("true".equals(sysprop) || "full".equals(sysprop)) {
            System.err.println("I18n module: Help button showing: " + help);
        }
        Help helpSystem = (Help)Lookup.getDefault().lookup(Help.class);
        helpSystem.showHelp(help);
    }

    private void enableButtons(long buttonMask) {
        assert (this.withButtons);
        this.replaceButton.setEnabled((buttonMask & 0xF0000L) != 0L);
        this.skipButton.setEnabled((buttonMask & 0xF000L) != 0L);
        this.infoButton.setEnabled((buttonMask & 0xF00L) != 0L);
        this.cancelButton.setEnabled((buttonMask & 0xF0L) != 0L);
        this.helpButton.setEnabled((buttonMask & 0xFL) != 0L);
    }
}

