/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.reformat.ReformatterImpl;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.openide.util.NbBundle;

public class Reformatter
implements ReformatTask {
    private Context context;
    private Document doc;
    private CodeStyle codeStyle;
    private static boolean expandTabToSpaces = true;
    private static int tabSize = 8;

    public Reformatter(Context context) {
        this.context = context;
        this.doc = context.document();
    }

    public Reformatter(Document doc, CodeStyle codeStyle) {
        this.doc = doc;
        this.codeStyle = codeStyle;
    }

    public void reformat() throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = CodeStyle.getDefault(this.doc);
        }
        expandTabToSpaces = this.codeStyle.expandTabToSpaces();
        tabSize = this.codeStyle.getTabSize();
        if (this.context != null) {
            for (Context.Region region : this.context.indentRegions()) {
                this.reformatImpl(region);
            }
        } else {
            int endOffset = this.doc.getLength();
            TokenHierarchy hierarchy = TokenHierarchy.get((Document)this.doc);
            if (hierarchy == null) {
                return;
            }
            this.reformatImpl(hierarchy, 0, endOffset);
        }
    }

    private void reformatImpl(Context.Region region) throws BadLocationException {
        int startOffset = region.getStartOffset();
        int endOffset = region.getEndOffset();
        Language language = CndLexerUtilities.getLanguage((String)this.context.mimePath());
        if (language != null) {
            this.reformatLanguage((Language<CppTokenId>)language, startOffset, endOffset);
        }
    }

    private void reformatLanguage(Language<CppTokenId> language, int startOffset, int endOffset) throws BadLocationException {
        TokenHierarchy hierarchy = TokenHierarchy.create((CharSequence)this.doc.getText(0, this.doc.getLength()), language);
        if (hierarchy == null) {
            return;
        }
        this.reformatImpl(hierarchy, startOffset, endOffset);
    }

    private void reformatImpl(TokenHierarchy hierarchy, int startOffset, int endOffset) throws BadLocationException {
        TokenSequence ts = hierarchy.tokenSequence();
        ts.move(startOffset);
        if (ts.moveNext() && ts.token().id() != CppTokenId.NEW_LINE) {
            while (ts.movePrevious()) {
                startOffset = ts.offset();
                if (ts.token().id() == CppTokenId.NEW_LINE) continue;
            }
        }
        while (ts != null && (startOffset == 0 || ts.moveNext())) {
            ts.move(startOffset);
            if (CndLexerUtilities.isCppLanguage((Language)ts.language(), (boolean)true)) {
                this.reformatImpl((TokenSequence<CppTokenId>)ts, startOffset, endOffset);
                return;
            }
            if (!ts.moveNext() && !ts.movePrevious()) {
                return;
            }
            ts = ts.embedded();
        }
    }

    private void reformatImpl(TokenSequence<CppTokenId> ts, int startOffset, int endOffset) throws BadLocationException {
        int prevStart = -1;
        int prevEnd = -1;
        String prevText = null;
        for (Diff diff : new ReformatterImpl(ts, startOffset, endOffset, this.codeStyle).reformat()) {
            int curStart = diff.getStartOffset();
            int curEnd = diff.getEndOffset();
            if (startOffset > curEnd || endOffset < curStart) continue;
            String curText = diff.getText();
            if (endOffset < curEnd) {
                if (curText != null && curText.length() > 0) {
                    curText = curEnd - endOffset >= curText.length() ? null : curText.substring(0, curText.length() - curEnd + endOffset);
                }
                curEnd = endOffset;
            }
            if (prevStart == curEnd) {
                prevStart = curStart;
                prevText = curText + prevText;
                continue;
            }
            if (!this.applyDiff(prevStart, prevEnd, prevText)) {
                return;
            }
            prevStart = curStart;
            prevEnd = curEnd;
            prevText = curText;
        }
        if (prevStart > -1) {
            this.applyDiff(prevStart, prevEnd, prevText);
        }
    }

    private boolean applyDiff(int start, int end, String text) throws BadLocationException {
        if (end - start > 0) {
            String what = this.doc.getText(start, end - start);
            if (text != null && text.equals(what)) {
                return true;
            }
            if (!this.checkRemoved(what)) {
                Logger log = Logger.getLogger("org.netbeans.modules.cnd.editor");
                String error = NbBundle.getMessage(Reformatter.class, (String)"REFORMATTING_FAILED", (Object)this.doc.getText(start, end - start), (Object)text);
                log.severe(error);
                return false;
            }
            this.doc.remove(start, end - start);
        }
        if (text != null && text.length() > 0) {
            this.doc.insertString(start, text, null);
        }
        return true;
    }

    private boolean checkRemoved(String whatRemoved) {
        block3: for (int i = 0; i < whatRemoved.length(); ++i) {
            char c = whatRemoved.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public ExtraLock reformatLock() {
        return new Lock();
    }

    static class Diff {
        private int start;
        private int end;
        private int newLines;
        private int spaces;
        private boolean isIndent;

        Diff(int start, int end, int newLines, int spaces, boolean isIndent) {
            this.start = start;
            this.end = end;
            this.spaces = spaces;
            this.newLines = newLines;
            this.isIndent = isIndent;
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }

        public String getText() {
            return Diff.repeatChar(this.newLines, '\n', false) + Diff.repeatChar(this.spaces, ' ', this.isIndent);
        }

        public void setText(int newLines, int spaces, boolean isIndent) {
            this.newLines = newLines;
            this.spaces = spaces;
            this.isIndent = isIndent;
        }

        public void replaceSpaces(int spaces, boolean isIndent) {
            this.spaces = spaces;
            this.isIndent = isIndent;
        }

        public boolean hasNewLine() {
            return this.newLines > 0;
        }

        public int spaceLength() {
            return this.spaces;
        }

        public String toString() {
            return "Diff<" + this.start + "," + this.end + ">: newLines=" + this.newLines + " spaces=" + this.spaces;
        }

        public static String repeatChar(int length, char c, boolean indent) {
            if (length == 0) {
                return "";
            }
            if (length == 1) {
                if (c == ' ') {
                    return " ";
                }
                return "\n";
            }
            StringBuilder buf = new StringBuilder(length);
            if (c == ' ' && indent && !expandTabToSpaces && tabSize > 1) {
                while (length >= tabSize) {
                    buf.append('\t');
                    length -= tabSize;
                }
            }
            for (int i = 0; i < length; ++i) {
                buf.append(c);
            }
            return buf.toString();
        }

        public static boolean equals(String text, int newLines, int spaces, boolean isIndent) {
            String space = Diff.repeatChar(newLines, '\n', false) + Diff.repeatChar(spaces, ' ', isIndent);
            return text.equals(space);
        }
    }

    private static class Lock
    implements ExtraLock {
        private Lock() {
        }

        public void lock() {
        }

        public void unlock() {
        }
    }

    public static class Factory
    implements ReformatTask.Factory {
        public ReformatTask createTask(Context context) {
            return new Reformatter(context);
        }
    }
}

