/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfret.source.GlobalSourcePath;
import org.netbeans.modules.gsfret.source.usages.ClassIndexFactory;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.openide.util.Exceptions;

public final class ClassIndex
extends Index {
    private static final Logger LOGGER = Logger.getLogger(ClassIndex.class.getName());
    private final Language language;
    private final ClassPath bootPath;
    private final ClassPath classPath;
    private final ClassPath sourcePath;
    private Set<ClassIndexImpl> sourceIndeces;
    private Set<ClassIndexImpl> depsIndeces;

    ClassIndex(Language language, ClassPath bootPath, ClassPath classPath, ClassPath sourcePath) {
        this.language = language;
        this.bootPath = bootPath;
        this.classPath = classPath;
        this.sourcePath = sourcePath;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void search(String primaryField, String name, NameKind kind, Set<Index.SearchScope> scope, Set<Index.SearchResult> result, Set<String> terms) throws IOException {
        assert (primaryField != null);
        assert (name != null);
        assert (kind != null);
        Iterable<? extends ClassIndexImpl> queries = this.getQueries(scope);
        for (ClassIndexImpl classIndexImpl : queries) {
            try {
                classIndexImpl.search(primaryField, name, kind, scope, result, terms);
            }
            catch (ClassIndexImpl.IndexAlreadyClosedException e) {
                ClassIndex.logClosedIndex(classIndexImpl);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("ClassIndex.search returned %d elements\n", result.size()));
        }
    }

    public void initForTest(Set<ClassIndexImpl> sources) {
        this.sourceIndeces = sources;
    }

    private static void logClosedIndex(ClassIndexImpl query) {
        assert (query != null);
        LOGGER.info("Ignoring closed index: " + query.toString());
    }

    private synchronized Iterable<? extends ClassIndexImpl> getQueries(Set<Index.SearchScope> scope) {
        HashSet<ClassIndexImpl> indeces;
        HashSet<ClassIndexImpl> result = new HashSet<ClassIndexImpl>();
        if (scope.contains(Index.SearchScope.SOURCE)) {
            if (this.sourceIndeces == null) {
                indeces = new HashSet<ClassIndexImpl>();
                ClassIndex.createQueriesForRoots(this.language, this.sourcePath, true, indeces);
                this.sourceIndeces = indeces;
            }
            result.addAll(this.sourceIndeces);
        }
        if (scope.contains(Index.SearchScope.DEPENDENCIES)) {
            if (this.depsIndeces == null) {
                indeces = new HashSet();
                List entries = this.classPath.entries();
                if (entries.size() > 0) {
                    ClassIndex.createQueriesForRoots(this.language, this.bootPath, false, indeces);
                }
                LanguageRegistry.getInstance().getLibraryUrls();
                Set<ClassIndexImpl> bootIndices = ClassIndexManager.get(this.language).getBootIndices();
                Indexer indexer = this.language.getIndexer();
                if (indexer != null) {
                    for (ClassIndexImpl ci : bootIndices) {
                        URL root;
                        if (ci == null || (root = ci.getRoot()) == null || !indexer.acceptQueryPath(root.toExternalForm())) continue;
                        indeces.add(ci);
                    }
                }
                ClassIndex.createQueriesForRoots(this.language, this.classPath, false, indeces);
                this.depsIndeces = indeces;
            }
            result.addAll(this.depsIndeces);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("ClassIndex.queries[Scope=%s, sourcePath=%s, bootPath=%s, classPath=%s] => %s\n", scope, this.sourcePath, this.bootPath, this.classPath, result));
        }
        return result;
    }

    public static void createQueriesForRoots(Language language, ClassPath cp, boolean sources, Set<? super ClassIndexImpl> queries) {
        GlobalSourcePath gsp = GlobalSourcePath.getDefault();
        List entries = cp.entries();
        Indexer indexer = language.getIndexer();
        if (indexer == null) {
            return;
        }
        for (ClassPath.Entry entry : entries) {
            try {
                URL[] srcRoots;
                if (!indexer.acceptQueryPath(entry.getURL().toExternalForm())) continue;
                if (!sources) {
                    URL srcRoot = org.netbeans.modules.gsfret.source.usages.Index.getSourceRootForClassFolder(language, entry.getURL());
                    if (srcRoot != null) {
                        srcRoots = new URL[]{srcRoot};
                    } else {
                        srcRoots = gsp.getSourceRootForBinaryRoot(entry.getURL(), cp, true);
                        if (srcRoots == null) {
                            srcRoots = new URL[]{entry.getURL()};
                        }
                    }
                } else {
                    srcRoots = new URL[]{entry.getURL()};
                }
                for (URL srcRoot : srcRoots) {
                    ClassIndexImpl ci = ClassIndexManager.get(language).getUsagesQuery(srcRoot);
                    if (ci == null) continue;
                    queries.add(ci);
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    static {
        ClassIndexImpl.FACTORY = new ClassIndexFactoryImpl();
    }

    private static class ClassIndexFactoryImpl
    implements ClassIndexFactory {
        private ClassIndexFactoryImpl() {
        }

        @Override
        public ClassIndex create(Language language, ClassPath bootPath, ClassPath classPath, ClassPath sourcePath) {
            return new ClassIndex(language, bootPath, classPath, sourcePath);
        }
    }
}

