/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints.infrastructure;

import java.util.ArrayList;
import java.util.Set;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

public class HintsTask
extends ScanningCancellableTask<CompilationInfo> {
    @Override
    public void run(CompilationInfo info) throws Exception {
        this.resume();
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        Set<String> mimeTypes = info.getEmbeddedMimeTypes();
        for (String mimeType : mimeTypes) {
            GsfHintsManager manager;
            HintsProvider provider;
            Language language = LanguageRegistry.getInstance().getLanguageByMimeType(mimeType);
            if (language == null || (provider = language.getHintsProvider()) == null || (manager = language.getHintsManager()) == null) continue;
            RuleContext ruleContext = manager.createRuleContext(info, language, -1, -1, -1);
            ArrayList hints = new ArrayList();
            if (ruleContext != null) {
                provider.computeHints((HintsProvider.HintsManager)manager, ruleContext, hints);
            }
            if (this.isCancelled()) {
                return;
            }
            for (Hint hint : hints) {
                ErrorDescription desc = manager.createDescription(hint, ruleContext, false);
                result.add(desc);
            }
        }
        HintsController.setErrors((FileObject)info.getFileObject(), (String)HintsTask.class.getName(), result);
    }
}

