/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.Formatter;
import org.netbeans.modules.gsf.api.GsfLanguage;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.IndexSearcher;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.InstantRenamer;
import org.netbeans.modules.gsf.api.KeystrokeHandler;
import org.netbeans.modules.gsf.api.OccurrencesFinder;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.gsf.spi.DefaultLanguageConfig;
import org.netbeans.modules.gsfret.editor.semantic.ColoringManager;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.openide.filesystems.FileObject;

public final class Language {
    private ColoringManager coloringManager;
    private String iconBase;
    private String mime;
    private Boolean useCustomEditorKit;
    private List<Action> actions;
    private GsfLanguage language;
    private DefaultLanguageConfig languageConfig;
    private Parser parser;
    private CodeCompletionHandler completionProvider;
    private InstantRenamer renamer;
    private DeclarationFinder declarationFinder;
    private Formatter formatter;
    private KeystrokeHandler keystrokeHandler;
    private Indexer indexer;
    private StructureScanner structure;
    private HintsProvider hintsProvider;
    private GsfHintsManager hintsManager;
    private IndexSearcher indexSearcher;
    private OccurrencesFinder occurrences;
    private SemanticAnalyzer semantic;
    private FileObject parserFile;
    private FileObject languageFile;
    private FileObject completionProviderFile;
    private FileObject renamerFile;
    private FileObject declarationFinderFile;
    private FileObject formatterFile;
    private FileObject keystrokeHandlerFile;
    private FileObject indexerFile;
    private FileObject structureFile;
    private FileObject hintsProviderFile;
    private FileObject semanticFile;
    private FileObject occurrencesFile;
    private FileObject indexSearcherFile;

    public Language(String mime) {
        this.mime = mime;
    }

    public Language(String iconBase, String mime, List<Action> actions, GsfLanguage gsfLanguage, Parser parser, CodeCompletionHandler completionProvider, InstantRenamer renamer, DeclarationFinder declarationFinder, Formatter formatter, KeystrokeHandler bracketCompletion, Indexer indexer, StructureScanner structure, Object palette, boolean useCustomEditorKit) {
        this.iconBase = iconBase;
        this.mime = mime;
        this.actions = actions;
        this.language = gsfLanguage;
        this.parser = parser;
        this.completionProvider = completionProvider;
        this.renamer = renamer;
        this.declarationFinder = declarationFinder;
        this.formatter = formatter;
        this.keystrokeHandler = bracketCompletion;
        this.indexer = indexer;
        this.structure = structure;
        this.useCustomEditorKit = useCustomEditorKit;
    }

    public boolean useCustomEditorKit() {
        if (this.useCustomEditorKit == null) {
            this.useCustomEditorKit = Boolean.FALSE;
        }
        return this.useCustomEditorKit;
    }

    void setUseCustomEditorKit(boolean useCustomEditorKit) {
        this.useCustomEditorKit = useCustomEditorKit;
    }

    @NonNull
    public String getDisplayName() {
        GsfLanguage l = this.getGsfLanguage();
        return l == null ? this.mime : l.getDisplayName();
    }

    public String getIconBase() {
        return this.iconBase;
    }

    void setIconBase(String iconBase) {
        this.iconBase = iconBase;
    }

    @NonNull
    public String getMimeType() {
        return this.mime;
    }

    void setMimeType(String mime) {
        this.mime = mime;
    }

    public Action[] getEditorActions() {
        if (this.actions != null) {
            return this.actions.toArray(new Action[this.actions.size()]);
        }
        return new Action[0];
    }

    @NonNull
    public GsfLanguage getGsfLanguage() {
        if (this.language == null && this.languageFile != null) {
            this.language = (GsfLanguage)this.createInstance(this.languageFile);
            if (this.language == null) {
                this.languageFile = null;
            } else if (this.language instanceof DefaultLanguageConfig) {
                this.languageConfig = (DefaultLanguageConfig)this.language;
            }
        }
        return this.language;
    }

    void setGsfLanguageFile(FileObject languageFile) {
        this.languageFile = languageFile;
    }

    @CheckForNull
    public Parser getParser() {
        if (this.parser == null) {
            if (this.parserFile != null) {
                this.parser = (Parser)this.createInstance(this.parserFile);
                if (this.parser == null) {
                    this.parserFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.parser = this.languageConfig.getParser();
                }
            }
        }
        return this.parser;
    }

    void setParser(Parser parser) {
        this.parser = parser;
    }

    void setParserFile(FileObject parserFile) {
        this.parserFile = parserFile;
    }

    public void addAction(Action action) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(action);
    }

    private Object createInstance(FileObject file) {
        return DataLoadersBridge.getDefault().createInstance(file);
    }

    public String toString() {
        return super.toString() + "[" + this.mime;
    }

    @CheckForNull
    public CodeCompletionHandler getCompletionProvider() {
        if (this.completionProvider == null) {
            if (this.completionProviderFile != null) {
                this.completionProvider = (CodeCompletionHandler)this.createInstance(this.completionProviderFile);
                if (this.completionProvider == null) {
                    this.completionProviderFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.completionProvider = this.languageConfig.getCompletionHandler();
                }
            }
        }
        return this.completionProvider;
    }

    void setCompletionProvider(CodeCompletionHandler completionProvider) {
        this.completionProvider = completionProvider;
    }

    void setCompletionProviderFile(FileObject completionProviderFile) {
        this.completionProviderFile = completionProviderFile;
    }

    @CheckForNull
    public InstantRenamer getInstantRenamer() {
        if (this.renamer == null) {
            if (this.renamerFile != null) {
                this.renamer = (InstantRenamer)this.createInstance(this.renamerFile);
                if (this.renamer == null) {
                    this.renamerFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.renamer = this.languageConfig.getInstantRenamer();
                }
            }
        }
        return this.renamer;
    }

    void setInstantRenamerFile(FileObject renamerFile) {
        this.renamerFile = renamerFile;
    }

    @CheckForNull
    public DeclarationFinder getDeclarationFinder() {
        if (this.declarationFinder == null) {
            if (this.declarationFinderFile != null) {
                this.declarationFinder = (DeclarationFinder)this.createInstance(this.declarationFinderFile);
                if (this.declarationFinder == null) {
                    this.declarationFinderFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.declarationFinder = this.languageConfig.getDeclarationFinder();
                }
            }
        }
        return this.declarationFinder;
    }

    void setDeclarationFinderFile(FileObject declarationFinderFile) {
        this.declarationFinderFile = declarationFinderFile;
    }

    @CheckForNull
    public Formatter getFormatter() {
        if (this.formatter == null) {
            if (this.formatterFile != null) {
                this.formatter = (Formatter)this.createInstance(this.formatterFile);
                if (this.formatter == null) {
                    this.formatterFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.formatter = this.languageConfig.getFormatter();
                    if (this.formatter != null) assert (this.languageConfig.hasFormatter());
                }
            }
        }
        return this.formatter;
    }

    void setFormatterFile(FileObject formatterFile) {
        this.formatterFile = formatterFile;
    }

    @CheckForNull
    public KeystrokeHandler getBracketCompletion() {
        if (this.keystrokeHandler == null) {
            if (this.keystrokeHandlerFile != null) {
                this.keystrokeHandler = (KeystrokeHandler)this.createInstance(this.keystrokeHandlerFile);
                if (this.keystrokeHandler == null) {
                    this.keystrokeHandlerFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.keystrokeHandler = this.languageConfig.getKeystrokeHandler();
                }
            }
        }
        return this.keystrokeHandler;
    }

    void setBracketCompletionFile(FileObject bracketCompletionFile) {
        this.keystrokeHandlerFile = bracketCompletionFile;
    }

    @CheckForNull
    public Indexer getIndexer() {
        if (this.indexer == null) {
            if (this.indexerFile != null) {
                this.indexer = (Indexer)this.createInstance(this.indexerFile);
                if (this.indexer == null) {
                    this.indexerFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.indexer = this.languageConfig.getIndexer();
                }
            }
        }
        return this.indexer;
    }

    void setIndexerFile(FileObject indexerFile) {
        this.indexerFile = indexerFile;
    }

    @CheckForNull
    public StructureScanner getStructure() {
        if (this.structure == null) {
            if (this.structureFile != null) {
                this.structure = (StructureScanner)this.createInstance(this.structureFile);
                if (this.structure == null) {
                    this.structureFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.structure = this.languageConfig.getStructureScanner();
                    if (this.structure != null) assert (this.languageConfig.hasStructureScanner());
                }
            }
        }
        return this.structure;
    }

    void setStructureFile(FileObject structureFile) {
        this.structureFile = structureFile;
    }

    @CheckForNull
    public HintsProvider getHintsProvider() {
        if (this.hintsProvider == null) {
            if (this.hintsProviderFile != null) {
                this.hintsProvider = (HintsProvider)this.createInstance(this.hintsProviderFile);
                if (this.hintsProvider == null) {
                    this.hintsProviderFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.hintsProvider = this.languageConfig.getHintsProvider();
                    if (this.hintsProvider != null) assert (this.languageConfig.hasHintsProvider());
                }
            }
            if (this.hintsProvider != null) {
                this.hintsManager = new GsfHintsManager(this.getMimeType(), this.hintsProvider, this);
            }
        }
        return this.hintsProvider;
    }

    @NonNull
    public GsfHintsManager getHintsManager() {
        if (this.hintsManager == null) {
            if (this.hintsProvider == null) {
                this.hintsProvider = this.getHintsProvider();
            }
            if (this.hintsProvider != null) {
                this.hintsManager = new GsfHintsManager(this.getMimeType(), this.hintsProvider, this);
            }
        }
        return this.hintsManager;
    }

    void setHintsProviderFile(FileObject hintsProviderFile) {
        this.hintsProviderFile = hintsProviderFile;
    }

    @NonNull
    public ColoringManager getColoringManager() {
        if (this.coloringManager == null) {
            this.coloringManager = new ColoringManager(this.mime);
        }
        return this.coloringManager;
    }

    public boolean hasStructureScanner() {
        return this.structureFile != null;
    }

    public boolean hasFormatter() {
        if (this.formatterFile != null) {
            return true;
        }
        this.getGsfLanguage();
        if (this.languageConfig != null) {
            return this.languageConfig.hasFormatter();
        }
        return false;
    }

    public boolean hasHints() {
        if (this.hintsProviderFile != null) {
            return true;
        }
        this.getGsfLanguage();
        if (this.languageConfig != null) {
            return this.languageConfig.hasHintsProvider();
        }
        return false;
    }

    @NonNull
    public OccurrencesFinder getOccurrencesFinder() {
        if (this.occurrences == null) {
            if (this.occurrencesFile != null) {
                this.occurrences = (OccurrencesFinder)this.createInstance(this.occurrencesFile);
                if (this.occurrences == null) {
                    this.occurrencesFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.occurrences = this.languageConfig.getOccurrencesFinder();
                    if (this.occurrences != null) assert (this.languageConfig.hasOccurrencesFinder());
                }
            }
        }
        return this.occurrences;
    }

    void setOccurrencesFinderFile(FileObject occurrencesFile) {
        this.occurrencesFile = occurrencesFile;
    }

    public boolean hasOccurrencesFinder() {
        if (this.occurrencesFile != null) {
            return true;
        }
        this.getGsfLanguage();
        if (this.languageConfig != null) {
            return this.languageConfig.hasOccurrencesFinder();
        }
        return false;
    }

    @NonNull
    public SemanticAnalyzer getSemanticAnalyzer() {
        if (this.semantic == null) {
            if (this.semanticFile != null) {
                this.semantic = (SemanticAnalyzer)this.createInstance(this.semanticFile);
                if (this.semantic == null) {
                    this.semanticFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.semantic = this.languageConfig.getSemanticAnalyzer();
                }
            }
        }
        return this.semantic;
    }

    void setSemanticAnalyzer(FileObject semanticFile) {
        this.semanticFile = semanticFile;
    }

    @NonNull
    public IndexSearcher getIndexSearcher() {
        if (this.indexSearcher == null) {
            if (this.indexSearcherFile != null) {
                this.indexSearcher = (IndexSearcher)this.createInstance(this.indexSearcherFile);
                if (this.indexSearcher == null) {
                    this.indexSearcherFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.indexSearcher = this.languageConfig.getIndexSearcher();
                }
            }
        }
        return this.indexSearcher;
    }

    void setIndexSearcher(FileObject indexSearcherFile) {
        this.indexSearcherFile = indexSearcherFile;
    }
}

