/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints.infrastructure;

import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;

public class Utilities {
    private static final String DEFAULT_NAME = "name";

    public static CsmClass extractEnclosingClass(CsmContext editorContext) {
        CsmFunction fun;
        if (editorContext == null) {
            return null;
        }
        CsmClass cls = editorContext.getEnclosingClass();
        if (cls == null && (fun = editorContext.getEnclosingFunction()) != null && CsmKindUtilities.isMethod((CsmObject)fun)) {
            cls = ((CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)fun)).getContainingClass();
        }
        return cls;
    }

    public static String guessName(CsmContext info) {
        CsmReference ref = CsmReferenceResolver.getDefault().findReference(info.getFile(), info.getStartOffset());
        if (ref != null) {
            return ((Object)ref.getText()).toString();
        }
        return DEFAULT_NAME;
    }

    private static String guessLiteralName(String str) {
        if (str.length() == 0) {
            return DEFAULT_NAME;
        }
        StringBuilder sb = new StringBuilder();
        char first = str.charAt(0);
        if (CndLexerUtilities.isCppIdentifierStart((char)str.charAt(0))) {
            sb.append(first);
        }
        for (int i = 1; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                sb.append('_');
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
            }
            if (i > 40) break;
        }
        if (sb.length() == 0) {
            return DEFAULT_NAME;
        }
        return sb.toString();
    }

    public static String getName(CsmType tm) {
        if (CsmKindUtilities.isBuiltIn((CsmObject)tm)) {
            return "" + Character.toLowerCase(tm.getClassifierText().charAt(0));
        }
        return Utilities.firstToLower(((Object)tm.getClassifierText()).toString());
    }

    public static String getName(CsmContext info) {
        CsmReferenceContext ref = null;
        return Utilities.getName(ref);
    }

    public static String getName(CsmReferenceContext et) {
        return Utilities.adjustName(Utilities.getNameRaw(et));
    }

    private static String getNameRaw(CsmReferenceContext et) {
        if (et == null) {
            return null;
        }
        return ((Object)et.getReference().getText()).toString();
    }

    static String adjustName(String name) {
        if (name == null) {
            return null;
        }
        String shortName = null;
        if (name.startsWith("get") && name.length() > 3) {
            shortName = name.substring(3);
        }
        if (name.startsWith("is") && name.length() > 2) {
            shortName = name.substring(2);
        }
        if (shortName != null) {
            return Utilities.firstToLower(shortName);
        }
        if (Utilities.isKeyword(name)) {
            return "a" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    private static String firstToLower(String name) {
        if (name.length() == 0) {
            return null;
        }
        String cand = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        if (Utilities.isKeyword(cand)) {
            cand = "a" + name;
        }
        return cand;
    }

    private static boolean isKeyword(String can) {
        return true;
    }
}

