/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.breakpoints.BreakpointLineUpdater;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyExceptionBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.IRubyLineBreakpoint;

public final class RubyBreakpointManager {
    private static final Map<RubyBreakpoint, BreakpointLineUpdater> BLUS = new HashMap<RubyBreakpoint, BreakpointLineUpdater>();

    private RubyBreakpointManager() {
    }

    static RubyLineBreakpoint createLineBreakpoint(Line line) {
        return RubyBreakpointManager.createLineBreakpoint(line, null);
    }

    static RubyLineBreakpoint createLineBreakpoint(Line line, String condition) {
        RubyLineBreakpoint breakpoint = new RubyLineBreakpoint(line, condition);
        BreakpointLineUpdater blu = new BreakpointLineUpdater(breakpoint);
        try {
            blu.attach();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        BLUS.put(breakpoint, blu);
        return breakpoint;
    }

    static RubyExceptionBreakpoint createExceptionBreakpoint(String exception) {
        RubyExceptionBreakpoint breakpoint = new RubyExceptionBreakpoint(exception);
        return breakpoint;
    }

    public static RubyLineBreakpoint addLineBreakpoint(Line line) throws RubyDebuggerException {
        RubyLineBreakpoint breakpoint = RubyBreakpointManager.createLineBreakpoint(line);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
        for (RubyDebuggerProxy proxy : RubyDebuggerProxy.PROXIES) {
            proxy.addBreakpoint((IRubyBreakpoint)breakpoint);
        }
        return breakpoint;
    }

    public static RubyExceptionBreakpoint addExceptionBreakpoint(String exception) throws RubyDebuggerException {
        RubyExceptionBreakpoint breakpoint = RubyBreakpointManager.createExceptionBreakpoint(exception);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
        for (RubyDebuggerProxy proxy : RubyDebuggerProxy.PROXIES) {
            proxy.addBreakpoint((IRubyBreakpoint)breakpoint);
        }
        return breakpoint;
    }

    public static void removeBreakpoint(RubyBreakpoint breakpoint) {
        RubyLineBreakpoint lineBp;
        if (breakpoint instanceof RubyLineBreakpoint && RubyBreakpointManager.isBreakpointOnLine((lineBp = (RubyLineBreakpoint)breakpoint).getFileObject(), lineBp.getLineNumber())) {
            BreakpointLineUpdater blu = BLUS.remove((Object)breakpoint);
            assert (blu != null) : "No BreakpointLineUpdater for RubyBreakpoint:" + (Object)((Object)breakpoint);
            if (blu != null) {
                blu.detach();
            }
        }
        for (RubyDebuggerProxy proxy : RubyDebuggerProxy.PROXIES) {
            proxy.removeBreakpoint((IRubyBreakpoint)breakpoint);
        }
    }

    public static RubyBreakpoint[] getBreakpoints() {
        Breakpoint[] bps = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<RubyBreakpoint> rubyBPs = new ArrayList<RubyBreakpoint>();
        for (Breakpoint bp : bps) {
            if (!(bp instanceof RubyBreakpoint)) continue;
            rubyBPs.add((RubyBreakpoint)bp);
        }
        return rubyBPs.toArray(new RubyBreakpoint[rubyBPs.size()]);
    }

    static IRubyLineBreakpoint[] getLineBreakpoints(FileObject script) {
        assert (script != null);
        ArrayList<RubyLineBreakpoint> scriptBPs = new ArrayList<RubyLineBreakpoint>();
        for (RubyBreakpoint bp : RubyBreakpointManager.getBreakpoints()) {
            RubyLineBreakpoint lbp;
            FileObject fo;
            if (!(bp instanceof RubyLineBreakpoint) || !script.equals(fo = (lbp = (RubyLineBreakpoint)bp).getFileObject())) continue;
            scriptBPs.add(lbp);
        }
        return scriptBPs.toArray(new RubyLineBreakpoint[scriptBPs.size()]);
    }

    public static boolean isBreakpointOnLine(FileObject file, int line) {
        for (RubyBreakpoint bp : RubyBreakpointManager.getBreakpoints()) {
            RubyLineBreakpoint lbp;
            if (!(bp instanceof RubyLineBreakpoint) || !file.equals((lbp = (RubyLineBreakpoint)bp).getFileObject()) || line != lbp.getLineNumber()) continue;
            return true;
        }
        return false;
    }

    static RubyBreakpoint getCurrentLineBreakpoint() {
        Line line = EditorUtil.getCurrentLine();
        if (line == null) {
            return null;
        }
        for (RubyBreakpoint breakpoint : RubyBreakpointManager.getBreakpoints()) {
            if (!(breakpoint instanceof RubyLineBreakpoint) || !((RubyLineBreakpoint)breakpoint).getLine().equals(line)) continue;
            return breakpoint;
        }
        return null;
    }
}

