/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.DeleteToNextCamelCasePosition;
import org.netbeans.modules.csl.api.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.csl.api.InstantRenameAction;
import org.netbeans.modules.csl.api.NextCamelCasePosition;
import org.netbeans.modules.csl.api.PreviousCamelCasePosition;
import org.netbeans.modules.csl.api.SelectCodeElementAction;
import org.netbeans.modules.csl.api.SelectNextCamelCasePosition;
import org.netbeans.modules.csl.api.SelectPreviousCamelCasePosition;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;
import org.netbeans.modules.html.editor.api.HtmlKit;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

public class GspKit
extends HtmlKit {
    static final long serialVersionUID = -1381945567613910297L;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GspKit.class);
    }

    public GspKit() {
        super("text/x-gsp");
    }

    public String getContentType() {
        return "text/x-gsp";
    }

    protected BaseKit.DeleteCharAction createDeletePrevAction() {
        return new GspDeleteCharAction("delete-previous", false, super.createDeletePrevAction());
    }

    protected ExtKit.ExtDefaultKeyTypedAction createDefaultKeyTypedAction() {
        return new GspDefaultKeyTypedAction(super.createDefaultKeyTypedAction());
    }

    protected Action[] createActions() {
        Action[] superActions = super.createActions();
        return TextAction.augmentList(superActions, new Action[]{new SelectCodeElementAction("select-element-next", true), new SelectCodeElementAction("select-element-previous", false), new NextCamelCasePosition(GspKit.findAction(superActions, "caret-next-word")), new PreviousCamelCasePosition(GspKit.findAction(superActions, "caret-previous-word")), new SelectNextCamelCasePosition(GspKit.findAction(superActions, "selection-next-word")), new SelectPreviousCamelCasePosition(GspKit.findAction(superActions, "selection-previous-word")), new DeleteToNextCamelCasePosition(GspKit.findAction(superActions, "remove-word-next")), new DeleteToPreviousCamelCasePosition(GspKit.findAction(superActions, "remove-word-previous")), new InstantRenameAction()});
    }

    private static Action findAction(Action[] actions, String name) {
        for (Action a : actions) {
            Object nameObj = a.getValue("Name");
            if (!(nameObj instanceof String) || !name.equals(nameObj)) continue;
            return a;
        }
        return null;
    }

    private boolean handleDeletion(BaseDocument doc, int dotPos) {
        if (dotPos > 0) {
            try {
                char ch = doc.getText(dotPos - 1, 1).charAt(0);
                if (ch == '%') {
                    Token token;
                    TokenHierarchy th = TokenHierarchy.get((Document)doc);
                    TokenSequence ts = th.tokenSequence();
                    ts.move(dotPos);
                    if (ts.movePrevious() && (token = ts.token()).id() == GspTokenId.DELIMITER && ts.offset() + token.length() == dotPos && ts.moveNext() && (token = ts.token()).id() == GspTokenId.DELIMITER && ts.offset() == dotPos) {
                        doc.remove(dotPos - 1, 1 + token.length());
                        return true;
                    }
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
        }
        return false;
    }

    private boolean handleInsertion(BaseDocument doc, Caret caret, char c) {
        int dotPos = caret.getDot();
        if (c == ' ' && dotPos >= 2) {
            try {
                String s = doc.getText(dotPos - 2, 2);
                if ("%=".equals(s) && dotPos >= 3) {
                    s = doc.getText(dotPos - 3, 3);
                }
                if ("<%".equals(s) || "<%=".equals(s)) {
                    doc.insertString(dotPos, "  ", null);
                    caret.setDot(dotPos + 1);
                    return true;
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            return false;
        }
        if (dotPos > 0 && (c == '%' || c == '>')) {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence ts = th.tokenSequence();
            ts.move(dotPos);
            try {
                if (ts.moveNext() || ts.movePrevious()) {
                    String s;
                    Token token = ts.token();
                    if (token.id() == GspTokenId.HTML && doc.getText(dotPos - 1, 1).charAt(0) == '<') {
                        int first = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos, (int)Utilities.getRowEnd((BaseDocument)doc, (int)dotPos));
                        if (first == -1) {
                            doc.insertString(dotPos, "%%>", null);
                            caret.setDot(dotPos + 1);
                            return true;
                        }
                    } else if (token.id() == GspTokenId.DELIMITER) {
                        int first;
                        String tokenText = ((Object)token.text()).toString();
                        if (tokenText.endsWith("%>")) {
                            int tokenPos = c == '%' ? dotPos : dotPos - 1;
                            CharSequence suffix = DocumentUtilities.getText((Document)doc, (int)tokenPos, (int)2);
                            if (CharSequenceUtilities.textEquals((CharSequence)suffix, (CharSequence)"%>")) {
                                caret.setDot(dotPos + 1);
                                return true;
                            }
                        } else if (tokenText.endsWith("<") && (first = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos, (int)Utilities.getRowEnd((BaseDocument)doc, (int)dotPos))) == -1) {
                            doc.insertString(dotPos, "%%>", null);
                            caret.setDot(dotPos + 1);
                            return true;
                        }
                    } else if ((token.id() == GspTokenId.GROOVY || token.id() == GspTokenId.GROOVY_EXPR && dotPos >= 1 && dotPos <= doc.getLength() - 3) && "% %>".equals(s = doc.getText(dotPos - 1, 4))) {
                        doc.remove(dotPos - 1, 2);
                        caret.setDot(dotPos + 1);
                        return true;
                    }
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
        }
        return false;
    }

    public Object clone() {
        return new GspKit();
    }

    private static Token<?> getToken(BaseDocument doc, int offset, boolean checkEmbedded) {
        TokenSequence es;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence();
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (checkEmbedded && (es = ts.embedded()) != null) {
            es.move(offset);
            if (es.moveNext() || es.movePrevious()) {
                return es.token();
            }
        }
        return ts.token();
    }

    private class GspDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        private BaseKit.DeleteCharAction htmlAction;

        public GspDeleteCharAction(String nm, boolean nextChar, BaseKit.DeleteCharAction htmlAction) {
            super(nm, nextChar);
            this.htmlAction = htmlAction;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            int dotPos;
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            if (GspKit.this.handleDeletion(doc, dotPos = caret.getDot())) {
                return;
            }
            this.htmlAction.actionPerformed(evt, target);
        }
    }

    private class GspDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private ExtKit.ExtDefaultKeyTypedAction htmlAction;

        GspDefaultKeyTypedAction(ExtKit.ExtDefaultKeyTypedAction htmlAction) {
            this.htmlAction = htmlAction;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            char c;
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            String cmd = evt.getActionCommand();
            if (cmd.length() > 0 && GspKit.this.handleInsertion(doc, caret, c = cmd.charAt(0))) {
                return;
            }
            this.htmlAction.actionPerformed(evt, target);
        }
    }
}

