/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.ComponentSerializationSupport;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DescriptorRegistryListener;
import org.netbeans.modules.vmd.api.model.PropertiesProcessor;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.model.XMLComponentDescriptor;
import org.netbeans.modules.vmd.model.XMLComponentProducer;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class GlobalDescriptorRegistry {
    private static final HashMap<String, WeakReference<GlobalDescriptorRegistry>> registries = new HashMap();
    private final String projectType;
    private final DataFolder registryFolder;
    private final DataFolder producersFolder;
    private final Mutex mutex = new Mutex();
    private HashMap<TypeID, ComponentDescriptor> descriptors = new HashMap();
    private ArrayList<ComponentProducer> producers = new ArrayList();
    private Map<TypeID, WeakReference<FileObject>> customFileObjects = new HashMap<TypeID, WeakReference<FileObject>>();
    private Map<TypeID, WeakReference<FileObject>> customProducerFileObjects = new HashMap<TypeID, WeakReference<FileObject>>();
    private final CopyOnWriteArraySet<DescriptorRegistryListener> listeners = new CopyOnWriteArraySet();
    private final HashMap<String, WeakReference<DescriptorRegistry>> projectID2projectRegistry = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GlobalDescriptorRegistry getGlobalDescriptorRegistry(String projectType) {
        assert (Debug.isFriend(DescriptorRegistry.class, "getDescriptorRegistry") || Debug.isFriend(ComponentSerializationSupport.class));
        HashMap<String, WeakReference<GlobalDescriptorRegistry>> hashMap = registries;
        synchronized (hashMap) {
            GlobalDescriptorRegistry registry;
            WeakReference<GlobalDescriptorRegistry> ref = registries.get(projectType);
            GlobalDescriptorRegistry globalDescriptorRegistry = registry = ref != null ? (GlobalDescriptorRegistry)ref.get() : null;
            if (registry == null) {
                registry = new GlobalDescriptorRegistry(projectType);
                registries.put(projectType, new WeakReference<GlobalDescriptorRegistry>(registry));
            }
            return registry;
        }
    }

    private GlobalDescriptorRegistry(String projectType) {
        assert (projectType != null && projectType.length() > 0) : "Invalid project-type: " + projectType;
        this.projectType = projectType;
        FileObject registryFileObject = FileUtil.getConfigFile((String)(projectType + "/components"));
        if (registryFileObject != null) {
            this.registryFolder = DataFolder.findFolder((FileObject)registryFileObject);
            this.registryFolder.getPrimaryFile().addFileChangeListener(new FileChangeListener(){

                public void fileFolderCreated(FileEvent fileEvent) {
                }

                public void fileDataCreated(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileChanged(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileDeleted(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }
            });
        } else {
            this.registryFolder = null;
        }
        FileObject producersFileObject = FileUtil.getConfigFile((String)(projectType + "/producers"));
        if (producersFileObject != null) {
            this.producersFolder = DataFolder.findFolder((FileObject)producersFileObject);
            this.producersFolder.getPrimaryFile().addFileChangeListener(new FileChangeListener(){

                public void fileFolderCreated(FileEvent fileEvent) {
                }

                public void fileDataCreated(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileChanged(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileDeleted(FileEvent fileEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }

                public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                    GlobalDescriptorRegistry.this.reloadLater();
                }
            });
        } else {
            this.producersFolder = null;
        }
        this.reload();
    }

    DataFolder getRegistryFolder() {
        assert (Debug.isFriend(ComponentSerializationSupport.class, "serializeComponentDescriptor") || Debug.isFriend(ComponentSerializationSupport.class, "refreshDescriptorRegistry"));
        return this.registryFolder;
    }

    DataFolder getProducersFolder() {
        assert (Debug.isFriend(ComponentSerializationSupport.class, "serializeComponentProducer") || Debug.isFriend(ComponentSerializationSupport.class, "refreshDescriptorRegistry"));
        return this.producersFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DescriptorRegistry getProjectRegistry(String projectID) {
        assert (Debug.isFriend(DescriptorRegistry.class, "getDescriptorRegistry"));
        HashMap<String, WeakReference<DescriptorRegistry>> hashMap = this.projectID2projectRegistry;
        synchronized (hashMap) {
            DescriptorRegistry registry;
            WeakReference<DescriptorRegistry> ref = this.projectID2projectRegistry.get(projectID);
            DescriptorRegistry descriptorRegistry = registry = ref != null ? (DescriptorRegistry)ref.get() : null;
            if (registry == null) {
                registry = new DescriptorRegistry(this);
                this.projectID2projectRegistry.put(projectID, new WeakReference<DescriptorRegistry>(registry));
            }
            return registry;
        }
    }

    void readAccess(Runnable runnable) {
        assert (Debug.isFriend(DescriptorRegistry.class) || Debug.isFriend(ComponentSerializationSupport.class, "runUnderDescriptorRegistryReadAccess"));
        this.mutex.readAccess(runnable);
    }

    void writeAccess(Runnable runnable) {
        assert (Debug.isFriend(DescriptorRegistry.class, "removeComponentDescriptor") || Debug.isFriend(ComponentSerializationSupport.class, "runUnderDescriptorRegistryWriteAccess"));
        this.mutex.writeAccess(runnable);
    }

    private void reloadLater() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                GlobalDescriptorRegistry.this.reload();
            }
        });
    }

    void reload() {
        this.mutex.writeAccess(new Runnable(){

            @Override
            public void run() {
                GlobalDescriptorRegistry.this.reloadCore();
            }
        });
    }

    private void reloadCore() {
        DataObject dataObject;
        Enumeration enumeration;
        ArrayList<ComponentDescriptor> descriptorsList = new ArrayList<ComponentDescriptor>();
        HashMap<TypeID, ComponentDescriptor> tempDescriptors = new HashMap<TypeID, ComponentDescriptor>();
        ArrayList<ComponentProducer> tempProducers = new ArrayList<ComponentProducer>();
        HashMap<TypeID, FileObject> tempFileObjects = new HashMap<TypeID, FileObject>();
        HashMap<TypeID, FileObject> tempProducerFileObjects = new HashMap<TypeID, FileObject>();
        if (this.registryFolder != null) {
            enumeration = this.registryFolder.children();
            while (enumeration.hasMoreElements()) {
                dataObject = (DataObject)enumeration.nextElement();
                ComponentDescriptor descriptor = this.dao2descriptor(dataObject, tempFileObjects);
                if (descriptor == null) {
                    Debug.warning("No descriptor", dataObject.getPrimaryFile().getNameExt());
                    continue;
                }
                TypeDescriptor typeDescriptor = descriptor.getTypeDescriptor();
                if (typeDescriptor == null) {
                    Debug.warning("Null type descriptor", descriptor);
                    continue;
                }
                TypeID thisType = typeDescriptor.getThisType();
                if (tempDescriptors.containsKey(thisType)) {
                    Debug.warning("Duplicate descriptor", thisType);
                    continue;
                }
                descriptor.setSuperComponentDescriptor(null);
                descriptor.setPropertyDescriptors(null);
                descriptorsList.add(descriptor);
                tempDescriptors.put(thisType, descriptor);
                ComponentProducer producer = ComponentProducer.createDefault(descriptor);
                if (producer == null) continue;
                tempProducers.add(producer);
            }
        }
        for (ComponentDescriptor descriptor : tempDescriptors.values()) {
            GlobalDescriptorRegistry.resolveDescriptor(this.projectType, tempDescriptors, descriptor);
        }
        tempDescriptors = new HashMap();
        for (ComponentDescriptor descriptor : descriptorsList) {
            TypeDescriptor typeDescriptor = descriptor.getTypeDescriptor();
            if (typeDescriptor.getSuperType() != null && descriptor.getSuperDescriptor() == null) {
                Debug.warning("Unresolved super descriptor", descriptor);
                continue;
            }
            tempDescriptors.put(typeDescriptor.getThisType(), descriptor);
        }
        if (this.producersFolder != null) {
            enumeration = this.producersFolder.children();
            while (enumeration.hasMoreElements()) {
                dataObject = (DataObject)enumeration.nextElement();
                ComponentProducer producer = this.dao2producer(dataObject, tempProducerFileObjects);
                if (producer == null) {
                    Debug.warning("No producer", dataObject.getPrimaryFile().getNameExt());
                    continue;
                }
                tempProducers.add(producer);
            }
        }
        HashMap<TypeID, WeakReference<FileObject>> tempCustomFileObjects = new HashMap<TypeID, WeakReference<FileObject>>();
        for (TypeID key : tempFileObjects.keySet()) {
            if (!tempDescriptors.containsKey(key)) continue;
            tempCustomFileObjects.put(key, new WeakReference(tempFileObjects.get(key)));
        }
        HashMap<TypeID, WeakReference<FileObject>> tempCustomProducerFileObjects = new HashMap<TypeID, WeakReference<FileObject>>();
        for (TypeID key : tempProducerFileObjects.keySet()) {
            if (!tempDescriptors.containsKey(key)) continue;
            tempCustomProducerFileObjects.put(key, new WeakReference(tempProducerFileObjects.get(key)));
        }
        this.descriptors = tempDescriptors;
        this.producers = tempProducers;
        this.customFileObjects = tempCustomFileObjects;
        this.customProducerFileObjects = tempCustomProducerFileObjects;
        for (DescriptorRegistryListener listener : this.listeners) {
            listener.descriptorRegistryUpdated();
        }
    }

    static void resolveDescriptor(String projectType, HashMap<TypeID, ComponentDescriptor> allDescriptors, ComponentDescriptor descriptor) {
        GlobalDescriptorRegistry.resolveDescriptor(projectType, allDescriptors, new HashSet<TypeID>(), descriptor);
    }

    private static void resolveDescriptor(String projectType, HashMap<TypeID, ComponentDescriptor> allDescriptors, HashSet<TypeID> resolvingDescriptors, ComponentDescriptor descriptor) {
        assert (Debug.isFriend(GlobalDescriptorRegistry.class) || Debug.isFriend(DescriptorRegistry.class));
        TypeID thisType = descriptor.getTypeDescriptor().getThisType();
        if (thisType == null) {
            Debug.warning("Null TypeID", descriptor);
            return;
        }
        if (resolvingDescriptors.contains(thisType)) {
            Debug.warning("There is inheritance-loop in CD registry - cannot resolve descriptor", descriptor);
            return;
        }
        resolvingDescriptors.add(thisType);
        if (descriptor.getPropertyDescriptors() != null) {
            return;
        }
        TypeID superType = descriptor.getTypeDescriptor().getSuperType();
        Collection<String> excludedNames = descriptor.getExcludedPropertyDescriptorNames();
        List<PropertyDescriptor> declaredDescriptors = descriptor.getDeclaredPropertyDescriptors();
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
        ComponentDescriptor superDescriptor = null;
        if (superType != null) {
            superDescriptor = allDescriptors.get(superType);
            if (superDescriptor == null) {
                Debug.warning("Cannot find super descriptor for TypeID", superType);
                return;
            }
            GlobalDescriptorRegistry.resolveDescriptor(projectType, allDescriptors, superDescriptor);
            if (!superDescriptor.getTypeDescriptor().isCanDerive()) {
                Debug.warning("Cannot derive from descriptor", superDescriptor);
                return;
            }
            Collection<PropertyDescriptor> superPropertyDescriptors = superDescriptor.getPropertyDescriptors();
            if (superPropertyDescriptors == null) {
                Debug.warning("Missing super property descriptors - cannot resolve descriptor", descriptor);
                return;
            }
            block0: for (PropertyDescriptor propertyDescriptor : superPropertyDescriptors) {
                String name = propertyDescriptor.getName();
                if (name == null) continue;
                if (excludedNames != null) {
                    for (String excludedName : excludedNames) {
                        if (!name.equals(excludedName)) continue;
                        continue block0;
                    }
                }
                if (declaredDescriptors != null) {
                    for (PropertyDescriptor declaredDescriptor : declaredDescriptors) {
                        if (!name.equals(declaredDescriptor.getName())) continue;
                        continue block0;
                    }
                }
                propertyDescriptors.add(propertyDescriptor);
            }
        }
        if (declaredDescriptors != null) {
            block3: for (int i = 0; i < declaredDescriptors.size(); ++i) {
                PropertyDescriptor declaredDescriptor = declaredDescriptors.get(i);
                if (declaredDescriptor == null) {
                    Debug.warning("Null declared property descriptor", descriptor);
                    continue;
                }
                String name = declaredDescriptor.getName();
                if (name == null) {
                    Debug.warning("Null declared property descriptor name", name);
                    continue;
                }
                for (int j = 0; j < i; ++j) {
                    PropertyDescriptor tested = declaredDescriptors.get(j);
                    if (tested != null && name.equals(tested.getName())) continue block3;
                }
                propertyDescriptors.add(declaredDescriptor);
            }
        }
        descriptor.setSuperComponentDescriptor(superDescriptor);
        descriptor.setPropertyDescriptors(null);
        PropertiesProcessor.postProcessDescriptor(projectType, descriptor, propertyDescriptors);
        descriptor.setPropertyDescriptors(propertyDescriptors);
    }

    private ComponentDescriptor dao2descriptor(DataObject dataObject, Map<TypeID, FileObject> fileObjects) {
        InstanceCookie.Of instanceCookie = (InstanceCookie.Of)dataObject.getCookie(InstanceCookie.Of.class);
        if (instanceCookie != null) {
            try {
                Object instance = instanceCookie.instanceCreate();
                if (instance instanceof ComponentDescriptor) {
                    return (ComponentDescriptor)instance;
                }
            }
            catch (IOException e) {
                Debug.warning(e);
            }
            catch (ClassNotFoundException e) {
                Debug.warning(e);
            }
            Debug.warning("Instance is not ComponentDescriptor class");
            return null;
        }
        if (dataObject instanceof XMLDataObject) {
            ComponentDescriptor descriptor = this.deserializeComponentDescriptorFromXML((XMLDataObject)dataObject);
            fileObjects.put(descriptor.getTypeDescriptor().getThisType(), dataObject.getPrimaryFile());
            return descriptor;
        }
        return null;
    }

    private ComponentProducer dao2producer(DataObject dataObject, Map<TypeID, FileObject> fileObjects) {
        InstanceCookie.Of instanceCookie = (InstanceCookie.Of)dataObject.getCookie(InstanceCookie.Of.class);
        if (instanceCookie != null) {
            try {
                Object instance = instanceCookie.instanceCreate();
                if (instance instanceof ComponentProducer) {
                    return (ComponentProducer)instance;
                }
            }
            catch (IOException e) {
                Debug.warning(e);
            }
            catch (ClassNotFoundException e) {
                Debug.warning(e);
            }
            Debug.warning("Instance is not ComponentProducer class");
            return null;
        }
        if (dataObject instanceof XMLDataObject) {
            return this.deserializeComponentCreatorFromXML((XMLDataObject)dataObject, fileObjects);
        }
        return null;
    }

    private ComponentDescriptor deserializeComponentDescriptorFromXML(XMLDataObject xmlDataObject) {
        Document document;
        try {
            document = xmlDataObject.getDocument();
            if (document == null) {
                return null;
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        catch (SAXException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        XMLComponentDescriptor descriptor = new XMLComponentDescriptor();
        if (descriptor.deserialize(this.projectType, document)) {
            return descriptor;
        }
        Debug.warning("Error during deserialization", xmlDataObject.getPrimaryFile());
        return null;
    }

    private ComponentProducer deserializeComponentCreatorFromXML(XMLDataObject xmlDataObject, Map<TypeID, FileObject> fileObjects) {
        Document document;
        try {
            document = xmlDataObject.getDocument();
            if (document == null) {
                return null;
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        catch (SAXException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        XMLComponentProducer producer = XMLComponentProducer.deserialize(this.projectType, document);
        if (producer != null) {
            fileObjects.put(producer.getMainComponentTypeID(), xmlDataObject.getPrimaryFile());
            return producer;
        }
        Debug.warning("Error during deserialization", xmlDataObject.getPrimaryFile());
        return null;
    }

    Collection<ComponentDescriptor> getComponentDescriptors() {
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    List<ComponentProducer> getComponentProducers() {
        return Collections.unmodifiableList(this.producers);
    }

    void addRegistryListener(DescriptorRegistryListener listener) {
        this.listeners.add(listener);
    }

    void removeRegistryListener(DescriptorRegistryListener listener) {
        this.listeners.remove(listener);
    }

    void removeComponentDescriptor(TypeID typeID) {
        FileObject fo1;
        FileObject fo;
        assert (Debug.isFriend(DescriptorRegistry.RemoveComponentDescriptorTask.class, "run"));
        WeakReference<FileObject> weakReference = this.customFileObjects.get(typeID);
        FileObject fileObject = fo = weakReference != null ? (FileObject)weakReference.get() : null;
        if (fo != null) {
            try {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                    public void run() {
                        try {
                            fo.delete();
                        }
                        catch (IOException ex) {
                            throw Debug.error(ex);
                        }
                    }
                });
            }
            catch (IOException ex) {
                throw Debug.error(ex);
            }
        }
        FileObject fileObject2 = fo1 = (weakReference = this.customProducerFileObjects.get(typeID)) != null ? (FileObject)weakReference.get() : null;
        if (fo1 != null) {
            try {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                    public void run() {
                        try {
                            fo1.delete();
                        }
                        catch (IOException ex) {
                            throw Debug.error(ex);
                        }
                    }
                });
            }
            catch (IOException ex) {
                throw Debug.error(ex);
            }
        }
    }
}

