/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.openide.util.Lookup;

public final class ModuleCookieSupport {
    private final TargetModuleID module;
    private final Lookup lookup;

    public ModuleCookieSupport(TargetModuleID targetModuleID, Lookup lookup) {
        this.module = targetModuleID;
        this.lookup = lookup;
    }

    public void performAction(Action action) {
        WLDeploymentManager wLDeploymentManager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
        if (wLDeploymentManager != null) {
            ProgressObject progressObject = action.execute(wLDeploymentManager, this.module);
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            progressObject.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent progressEvent) {
                    if (progressEvent.getDeploymentStatus().isCompleted() || progressEvent.getDeploymentStatus().isFailed()) {
                        countDownLatch.countDown();
                    }
                }
            });
            try {
                countDownLatch.await(60000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface Action {
        public ProgressObject execute(DeploymentManager var1, TargetModuleID var2);
    }
}

