/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.jumpto.type;

import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jumpto.type.TypeProviderAccessor;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;

public interface TypeProvider {
    public String name();

    public String getDisplayName();

    public void computeTypeNames(Context var1, Result var2);

    public void cancel();

    public void cleanup();

    public static final class Result {
        private List<? super TypeDescriptor> result;
        private String[] message;
        private int retry;

        Result(List<? super TypeDescriptor> result, String[] message) {
            this.result = result;
            this.message = message;
        }

        public void setMessage(String msg) {
            this.message[0] = msg;
        }

        public void addResult(TypeDescriptor typeDescriptor) {
            this.result.add(typeDescriptor);
        }

        public void addResult(List<? extends TypeDescriptor> typeDescriptor) {
            this.result.addAll(typeDescriptor);
        }

        public void pendingResult() {
            this.retry = 2000;
        }
    }

    public static final class Context {
        private final Project project;
        private final String text;
        private final SearchType type;

        Context(Project project, String text, SearchType type) {
            this.project = project;
            this.text = text;
            this.type = type;
        }

        public Project getProject() {
            return this.project;
        }

        public String getText() {
            return this.text;
        }

        public SearchType getSearchType() {
            return this.type;
        }

        static {
            TypeProviderAccessor.DEFAULT = new TypeProviderAccessor(){

                @Override
                public Context createContext(Project p, String text, SearchType t) {
                    return new Context(p, text, t);
                }

                @Override
                public Result createResult(List<? super TypeDescriptor> result, String[] message) {
                    return new Result(result, message);
                }

                @Override
                public int getRetry(Result result) {
                    return result.retry;
                }
            };
        }
    }
}

