/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmFunctionDefinitionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmAbstractHyperlinkProvider;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.OverridesPopup;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.ui.PopupUtil;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.openide.util.Exceptions;

public final class CsmHyperlinkProvider
extends CsmAbstractHyperlinkProvider {
    @Override
    protected void performAction(Document doc, JTextComponent target, int offset, HyperlinkType type) {
        this.goToDeclaration(doc, target, offset, type);
    }

    @Override
    protected boolean isValidToken(TokenItem<CppTokenId> token, HyperlinkType type) {
        return CsmHyperlinkProvider.isSupportedToken(token, type);
    }

    public static boolean isSupportedToken(TokenItem<CppTokenId> token, HyperlinkType type) {
        if (token != null) {
            if (type == HyperlinkType.ALT_HYPERLINK && ("whitespace".equals(((CppTokenId)token.id()).primaryCategory()) || "comment".equals(((CppTokenId)token.id()).primaryCategory()))) {
                return false;
            }
            switch ((CppTokenId)token.id()) {
                case IDENTIFIER: 
                case PREPROCESSOR_IDENTIFIER: 
                case OPERATOR: {
                    return true;
                }
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: 
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_USER_INCLUDE: {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean goToDeclaration(Document doc, JTextComponent target, int offset, HyperlinkType type) {
        if (!this.preJump(doc, target, offset, "opening-csm-element", type)) {
            return false;
        }
        TokenItem<CppTokenId> jumpToken = this.getJumpToken();
        CsmOffsetable primary = (CsmOffsetable)this.findTargetObject(doc, jumpToken, offset, false);
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        CsmOffsetable item = this.toJumpObject((CsmObject)primary, csmFile, offset);
        if (type == HyperlinkType.ALT_HYPERLINK) {
            Collection subRefs;
            if (CsmKindUtilities.isMethod((CsmObject)item)) {
                CsmMethod meth = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)item));
                boolean inDeclaration = this.isInDeclaration((CsmFunction)meth, csmFile, offset);
                Collection<Object> baseMethods = inDeclaration ? CsmVirtualInfoQuery.getDefault().getFirstBaseDeclarations(meth) : Collections.emptyList();
                List overriddenMethods = !baseMethods.isEmpty() || CsmVirtualInfoQuery.getDefault().isVirtual(meth) ? CsmVirtualInfoQuery.getDefault().getOverriddenMethods(meth, false) : Collections.emptyList();
                baseMethods.remove(meth);
                if (this.showOverridesPopup((CsmOffsetableDeclaration)(inDeclaration ? null : meth), baseMethods, overriddenMethods, inDeclaration ? CsmKindUtilities.isFunctionDefinition((CsmObject)item) : true, target, offset)) {
                    UIGesturesSupport.submit((String)"USG_CND_HYPERLINK_METHOD", (Object[])new Object[]{type});
                    return true;
                }
            } else if (CsmKindUtilities.isClass((CsmObject)item) && !(subRefs = CsmTypeHierarchyResolver.getDefault().getSubTypes((CsmClass)item, false)).isEmpty()) {
                ArrayList<CsmClass> subClasses = new ArrayList<CsmClass>(subRefs.size());
                for (CsmReference ref : subRefs) {
                    CsmObject obj = ref.getReferencedObject();
                    CndUtils.assertTrue((obj == null || obj instanceof CsmClass ? 1 : 0) != 0, (String)"getClassifier() should return either null or CsmClass");
                    if (!(obj instanceof CsmClass)) continue;
                    subClasses.add((CsmClass)obj);
                }
                if (this.showOverridesPopup(null, Collections.emptyList(), subClasses, false, target, offset)) {
                    UIGesturesSupport.submit((String)"USG_CND_HYPERLINK_CLASS", (Object[])new Object[]{type});
                    return true;
                }
            }
        }
        UIGesturesSupport.submit((String)"USG_CND_HYPERLINK", (Object[])new Object[]{type});
        return this.postJump(item, "goto_source_source_not_found", "cannot-open-csm-element");
    }

    private boolean showOverridesPopup(CsmOffsetableDeclaration mainDeclaration, Collection<? extends CsmOffsetableDeclaration> baseDeclarations, Collection<? extends CsmOffsetableDeclaration> descendantDeclarations, boolean gotoDefinitions, JTextComponent target, int offset) {
        if (!baseDeclarations.isEmpty() || !descendantDeclarations.isEmpty()) {
            try {
                final OverridesPopup popup = new OverridesPopup(null, mainDeclaration, baseDeclarations, descendantDeclarations, gotoDefinitions);
                Rectangle rect = target.modelToView(offset);
                final Point point = new Point((int)rect.getX(), (int)(rect.getY() + rect.getHeight()));
                SwingUtilities.convertPointToScreen(point, target);
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        PopupUtil.showPopup((JComponent)popup, null, (int)point.x, (int)point.y, (boolean)true, (int)0);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runner.run();
                } else {
                    SwingUtilities.invokeLater(runner);
                }
                return true;
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    CsmObject findTargetObject(Document doc, TokenItem<CppTokenId> jumpToken, int offset, boolean toOffsetable) {
        CsmObject csmObject;
        CsmObject item = null;
        assert (jumpToken != null);
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        CsmObject csmObject2 = csmObject = file == null ? null : ReferencesSupport.findDeclaration(file, doc, jumpToken, offset);
        if (csmObject != null) {
            item = toOffsetable ? this.toJumpObject(csmObject, file, offset) : csmObject;
        }
        return item;
    }

    private boolean isInDeclaration(CsmFunction func, CsmFile csmFile, int offset) {
        CsmFunction decl;
        CsmFunctionDefinition def;
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)func)) {
            def = (CsmFunctionDefinition)func;
            decl = def.getDeclaration();
        } else {
            decl = func;
            def = func.getDefinition();
        }
        if (def != null && csmFile.equals(def.getContainingFile()) && def.getStartOffset() <= offset && offset <= def.getBody().getStartOffset()) {
            return true;
        }
        return decl != null && csmFile.equals(decl.getContainingFile()) && decl.getStartOffset() <= offset && offset <= decl.getEndOffset();
    }

    private CsmOffsetable toJumpObject(CsmObject csmObject, CsmFile csmFile, int offset) {
        Object item = null;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            CsmClassifier cls;
            item = (CsmOffsetable)csmObject;
            if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject)) {
                CsmFunctionDefinition definition = ((CsmFunction)csmObject).getDefinition();
                if (definition != null) {
                    if (csmFile.equals(definition.getContainingFile()) && definition.getStartOffset() <= offset && offset <= definition.getBody().getStartOffset()) {
                        if (definition.getDeclaration() != null) {
                            item = definition.getDeclaration();
                        } else if (csmObject.equals(definition)) {
                            item = (CsmOffsetable)csmObject;
                        }
                    } else {
                        item = definition;
                    }
                } else {
                    CsmReference ref = CsmFunctionDefinitionResolver.getDefault().getFunctionDefinition((CsmFunction)csmObject);
                    if (ref != null) {
                        item = ref;
                    }
                }
            } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                CsmFunctionDefinition definition = (CsmFunctionDefinition)csmObject;
                if (csmFile.equals(definition.getContainingFile()) && definition.getStartOffset() <= offset && offset <= definition.getBody().getStartOffset()) {
                    item = definition.getDeclaration() != null ? definition.getDeclaration() : definition;
                }
            } else if (CsmKindUtilities.isVariableDeclaration((CsmObject)csmObject)) {
                CsmVariableDefinition definition = ((CsmVariable)csmObject).getDefinition();
                if (definition != null) {
                    item = definition;
                    if (csmFile.equals(definition.getContainingFile()) && definition.getStartOffset() <= offset && offset <= definition.getEndOffset()) {
                        item = (CsmVariable)csmObject;
                    }
                }
            } else if (CsmClassifierResolver.getDefault().isForwardClass(csmObject) && CsmKindUtilities.isOffsetable((Object)(cls = CsmClassifierResolver.getDefault().getOriginalClassifier((CsmClassifier)csmObject, csmFile)))) {
                item = (CsmOffsetable)cls;
            }
        } else if (CsmKindUtilities.isNamespace((Object)csmObject)) {
            CsmNamespace nmsp = (CsmNamespace)csmObject;
            Collection defs = nmsp.getDefinitions();
            CsmNamespaceDefinition bestDef = null;
            for (CsmNamespaceDefinition def : defs) {
                CsmFile container;
                if (bestDef == null) {
                    bestDef = def;
                }
                if (!csmFile.equals(container = def.getContainingFile())) continue;
                bestDef = def;
                break;
            }
            item = bestDef;
        }
        return item;
    }

    @Override
    protected String getTooltipText(Document doc, TokenItem<CppTokenId> token, int offset, HyperlinkType type) {
        CharSequence msg;
        CsmObject item = this.findTargetObject(doc, token, offset, false);
        CharSequence charSequence = msg = item == null ? null : CsmDisplayUtilities.getTooltipText((CsmObject)item);
        if (msg != null) {
            if (CsmKindUtilities.isMacro((CsmObject)item)) {
                msg = this.getAlternativeHyperlinkTip(doc, "AltMacroHyperlinkHint", msg);
            } else if (CsmKindUtilities.isMethod((CsmObject)item)) {
                msg = this.getAlternativeHyperlinkTip(doc, "AltMethodHyperlinkHint", msg);
            } else if (CsmKindUtilities.isClass((CsmObject)item)) {
                msg = this.getAlternativeHyperlinkTip(doc, "AltClassHyperlinkHint", msg);
            }
        }
        return msg == null ? null : ((Object)msg).toString();
    }
}

