/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common;

import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.debugger.common.EditorContext;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.common.breakpoints.DebuggerBreakpointAnnotation;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Utilities;

public class EditorContextImpl
extends EditorContext {
    private static String fronting = System.getProperty("netbeans.debugger.fronting");
    private ChangeListener changedFilesListener;
    private Map<Object, Registry> timeStampToRegistry = new HashMap<Object, Registry>();
    private Set<DataObject> modifiedDataObjects;

    @Override
    public boolean showSource(String url, int lineNumber, Object timeStamp) {
        return this.showSource(EditorContextImpl.getDataObject(url), lineNumber, timeStamp);
    }

    @Override
    public boolean showSource(DataObject dobj, int lineNumber, Object timeStamp) {
        Line l = this.getLine(dobj, lineNumber, timeStamp);
        if (l == null) {
            return false;
        }
        if (fronting != null) {
            if (fronting.equals("true")) {
                l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT);
            } else {
                l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
            return true;
        }
        if (Utilities.isWindows()) {
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT);
        } else {
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        }
        return true;
    }

    @Override
    public void createTimeStamp(Object timeStamp) {
        this.modifiedDataObjects = new HashSet<DataObject>(DataObject.getRegistry().getModifiedSet());
        Registry r = new Registry();
        this.timeStampToRegistry.put(timeStamp, r);
        for (DataObject dataObject : this.modifiedDataObjects) {
            r.register(dataObject);
        }
        if (this.changedFilesListener == null) {
            this.changedFilesListener = new ChangedFilesListener();
            DataObject.getRegistry().addChangeListener(this.changedFilesListener);
        }
    }

    @Override
    public void disposeTimeStamp(Object timeStamp) {
        this.timeStampToRegistry.remove(timeStamp);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
    }

    @Override
    public Annotation annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
        return this.annotate(EditorContextImpl.getDataObject(url), lineNumber, annotationType, timeStamp);
    }

    @Override
    public Annotation annotate(DataObject dobj, int lineNumber, String annotationType, Object timeStamp) {
        Line l;
        CndBreakpoint b = null;
        if (timeStamp instanceof CndBreakpoint) {
            b = (CndBreakpoint)((Object)timeStamp);
            timeStamp = null;
        }
        if ((l = this.getLine(dobj, lineNumber, timeStamp)) == null) {
            return null;
        }
        Object annotation = b == null ? new DebuggerAnnotation(annotationType, l) : new DebuggerBreakpointAnnotation(annotationType, l, b);
        return annotation;
    }

    @Override
    public void removeAnnotation(Annotation a) {
        DebuggerAnnotation annotation = (DebuggerAnnotation)a;
        annotation.detach();
    }

    @Override
    public int getLineNumber(Object annotation, Object timeStamp) {
        DebuggerAnnotation a = (DebuggerAnnotation)((Object)annotation);
        if (timeStamp == null) {
            return a.getLine().getLineNumber() + 1;
        }
        DataObject dobj = (DataObject)a.getLine().getLookup().lookup(DataObject.class);
        if (dobj != null) {
            Line.Set lineSet = this.getLineSet(dobj, timeStamp);
            return lineSet.getOriginalLineNumber(a.getLine()) + 1;
        }
        return -1;
    }

    @Override
    public void updateTimeStamp(Object timeStamp, String url) {
        Registry registry = this.timeStampToRegistry.get(timeStamp);
        registry.register(EditorContextImpl.getDataObject(url));
    }

    @Override
    public int getCurrentLineNumber() {
        return EditorContextDispatcher.getDefault().getCurrentLineNumber();
    }

    @Override
    public int getMostRecentLineNumber() {
        return EditorContextDispatcher.getDefault().getMostRecentLineNumber();
    }

    @Override
    public String getCurrentURL() {
        String currentURL = EditorContextDispatcher.getDefault().getCurrentURLAsString();
        if (Utilities.isWindows()) {
            currentURL = currentURL.replace("\\", "/");
        }
        return currentURL;
    }

    @Override
    public String getMostRecentURL() {
        String currentURL = EditorContextDispatcher.getDefault().getMostRecentURLAsString();
        if (Utilities.isWindows()) {
            currentURL = currentURL.replace("\\", "/");
        }
        return currentURL;
    }

    @Override
    public String getCurrentFunctionName() {
        return "";
    }

    @Override
    public String getSelectedFunctionName() {
        JEditorPane ep = this.getCurrentEditor();
        if (ep == null) {
            return "";
        }
        StyledDocument doc = (StyledDocument)ep.getDocument();
        if (doc == null) {
            return "";
        }
        return "";
    }

    @Override
    public int getFieldLineNumber(String url, String className, String fieldName) {
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return -1;
        }
        return -1;
    }

    @Override
    public String getCurrentMIMEType() {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        return fo != null ? fo.getMIMEType() : "";
    }

    @Override
    public DataObject getCurrentDataObject() {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        if (fo == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException donfex) {
            return null;
        }
    }

    @Override
    public FileObject getCurrentFileObject() {
        return EditorContextDispatcher.getDefault().getCurrentFile();
    }

    @Override
    public FileObject getMostRecentFileObject() {
        return EditorContextDispatcher.getDefault().getMostRecentFile();
    }

    @Override
    public DataObject getMostRecentDataObject() {
        FileObject fo = EditorContextDispatcher.getDefault().getMostRecentFile();
        if (fo == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException donfex) {
            return null;
        }
    }

    @Override
    public String getMostRecentMIMEType() {
        FileObject fo = EditorContextDispatcher.getDefault().getMostRecentFile();
        return fo != null ? fo.getMIMEType() : "";
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-c", l);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-c++", l);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-h", l);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-asm", l);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-fortran", l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        EditorContextDispatcher.getDefault().removePropertyChangeListener(l);
    }

    private JEditorPane getCurrentEditor() {
        return EditorContextDispatcher.getDefault().getCurrentEditor();
    }

    private Line.Set getLineSet(DataObject dataObject, Object timeStamp) {
        LineCookie lineCookie;
        if (dataObject == null) {
            return null;
        }
        if (timeStamp != null) {
            Registry registry = this.timeStampToRegistry.get(timeStamp);
            Line.Set ls = null;
            try {
                ls = registry.getLineSet(dataObject);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            if (ls != null) {
                return ls;
            }
        }
        if ((lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) == null) {
            return null;
        }
        return lineCookie.getLineSet();
    }

    private Line getLine(DataObject dobj, int lineNumber, Object timeStamp) {
        Line.Set ls = this.getLineSet(dobj, timeStamp);
        if (ls == null) {
            return null;
        }
        try {
            if (timeStamp == null) {
                return ls.getCurrent(lineNumber - 1);
            }
            return ls.getOriginal(lineNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }

    private static DataObject getDataObject(String url) {
        FileObject file;
        assert (url != null && url.startsWith("file:") || !Boolean.getBoolean("gdb.assertions.enabled"));
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            assert (!Boolean.getBoolean("gdb.assertions.enabled"));
            return null;
        }
        catch (Exception ex) {
            assert (!Boolean.getBoolean("gdb.assertions.enabled"));
            return null;
        }
        if (file == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            HashSet newDOs = new HashSet(DataObject.getRegistry().getModifiedSet());
            newDOs.removeAll(EditorContextImpl.this.modifiedDataObjects);
            for (Registry r : EditorContextImpl.this.timeStampToRegistry.values()) {
                for (DataObject dataObject : newDOs) {
                    r.register(dataObject);
                }
            }
            EditorContextImpl.this.modifiedDataObjects = new HashSet(DataObject.getRegistry().getModifiedSet());
        }
    }

    private static class Registry {
        private Map<DataObject, Line.Set> dataObjectToLineSet = new HashMap<DataObject, Line.Set>();

        private Registry() {
        }

        void register(DataObject dataObject) {
            LineCookie lc = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lc == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lc.getLineSet());
        }

        Line.Set getLineSet(DataObject dataObject) {
            return this.dataObjectToLineSet.get(dataObject);
        }
    }
}

