/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.util.DLightLogger;

final class ReusableByteBuffer {
    private static final Logger log = DLightLogger.getLogger(ReusableByteBuffer.class);
    private static final boolean TRACE = Boolean.getBoolean("TraceReusableByteBuffer");
    public final byte[] buffer;
    private final int size;
    private final int count;
    private final ConcurrentHashMap<Integer, Integer> marks;
    private final AtomicInteger idx = new AtomicInteger(0);

    public ReusableByteBuffer(int chunksize, int chunkcount) {
        if (chunksize > 65535 && chunkcount > 65535) {
            throw new IllegalArgumentException();
        }
        this.size = chunksize;
        this.count = chunkcount;
        this.buffer = new byte[(0xFFFF & this.count) * (0xFFFF & this.size)];
        this.marks = new ConcurrentHashMap(this.count);
    }

    public int getAndLockOffset() {
        int offset;
        Integer marker;
        do {
            if (this.marks.size() != this.count) continue;
            if (TRACE) {
                log.info("All chuncks are locked!");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        } while ((marker = this.marks.get(offset = (0xFFFF & this.idx.getAndIncrement() % this.count) * this.size)) != null || this.marks.putIfAbsent(offset, offset) != null);
        return offset;
    }

    public void unlock(int offset) {
        this.marks.remove(offset);
    }
}

