/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.processinfo;

import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReader;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReaderFactory;
import org.netbeans.modules.dlight.util.Computable;
import org.netbeans.modules.dlight.util.TasksCachedProcessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.ProcessInfo;
import org.netbeans.modules.nativeexecution.api.ProcessInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

class ProcBasedProcessInfoProvider
implements ProcessInfoProvider {
    private static final TasksCachedProcessor<FetchParams, ProcessInfo> cachedProcessor = new TasksCachedProcessor((Computable)new ProcessInfoFetcher(), false);
    private final FetchParams params;

    ProcBasedProcessInfoProvider(ExecutionEnvironment env, int pid) {
        this.params = new FetchParams(env, pid);
    }

    public ProcessInfo getProcessInfo() {
        ProcessInfo result = null;
        try {
            result = (ProcessInfo)cachedProcessor.compute((Object)this.params);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    private static class ProcessInfoFetcher
    implements Computable<FetchParams, ProcessInfo> {
        private ProcessInfoFetcher() {
        }

        public ProcessInfo compute(FetchParams taskArguments) throws InterruptedException {
            ProcessInfo result = null;
            try {
                HostInfo info = HostInfoUtils.getHostInfo((ExecutionEnvironment)taskArguments.env);
                if (info.getOSFamily() != HostInfo.OSFamily.SUNOS) {
                    return null;
                }
                ProcReader reader = ProcReaderFactory.getReader(taskArguments.env, taskArguments.pid);
                final long creation_ts = reader.getProcessUsage().getUsageInfo().pr_create;
                if (creation_ts > 0L) {
                    result = new ProcessInfo(){

                        public long getCreationTimestamp(TimeUnit unit) {
                            return unit.convert(creation_ts, TimeUnit.NANOSECONDS);
                        }
                    };
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return result;
        }
    }

    private static class FetchParams {
        private final ExecutionEnvironment env;
        private final int pid;

        private FetchParams(ExecutionEnvironment env, int pid) {
            this.env = env;
            this.pid = pid;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FetchParams)) {
                return false;
            }
            FetchParams that = (FetchParams)obj;
            return this.pid == that.pid && this.env.equals(that.env);
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + (this.env != null ? this.env.hashCode() : 0);
            hash = 71 * hash + this.pid;
            return hash;
        }
    }
}

