/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.Path;
import com.sun.perseus.j2d.PathShape;
import com.sun.perseus.j2d.Tile;
import com.sun.perseus.j2d.Transform;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class PathSupport {
    static final Line2D.Float line = new Line2D.Float();
    static final Rectangle2D.Float rect = new Rectangle2D.Float();
    static final RoundRectangle2D.Float rrect = new RoundRectangle2D.Float();
    static final Ellipse2D.Float ellipse = new Ellipse2D.Float();
    static final PathShape shape = new PathShape(null, 0);
    static final AffineTransform txf = new AffineTransform();

    public static boolean isHit(Path path, int windingRule, float hx, float hy) {
        PathSupport.shape.path = path;
        PathSupport.shape.windingRule = windingRule;
        return shape.contains(hx, hy);
    }

    public static boolean isStrokedPathHit(Object strokedPath, int windingRule, float hx, float hy) {
        return ((Shape)strokedPath).contains(hx, hy);
    }

    public static void computeStrokedPathTile(Tile tile, Object strokedPath, Transform t) {
        Shape sp = (Shape)strokedPath;
        if (t != null) {
            txf.setTransform(t.m0, t.m1, t.m2, t.m3, t.m4, t.m5);
            sp = txf.createTransformedShape(sp);
        }
        Rectangle2D r = sp.getBounds2D();
        double x = r.getX();
        double y = r.getY();
        double w = r.getWidth();
        double h = r.getHeight();
        double fx = Math.floor(x);
        double fy = Math.floor(y);
        w += x - fx;
        h += y - fy;
        w = Math.ceil(w);
        h = Math.ceil(h);
        tile.setTile((int)fx, (int)fy, (int)w, (int)h);
    }

    static BasicStroke getBasicStroke(GraphicsProperties gp) {
        float[] strokeDashArray = gp.getStrokeDashArray();
        if (strokeDashArray != null) {
            float sda;
            float strokeDashOffset = gp.getStrokeDashOffset();
            if (strokeDashOffset >= 0.0f) {
                return new BasicStroke(gp.getStrokeWidth(), gp.getStrokeLineCap(), gp.getStrokeLineJoin(), gp.getStrokeMiterLimit(), strokeDashArray, strokeDashOffset);
            }
            float length = 0.0f;
            for (int i = 0; i < strokeDashArray.length; ++i) {
                length += strokeDashArray[i];
            }
            if (length <= 0.0f) {
                return new BasicStroke(gp.getStrokeWidth(), gp.getStrokeLineCap(), gp.getStrokeLineJoin(), gp.getStrokeMiterLimit(), strokeDashArray, 0.0f);
            }
            for (sda = strokeDashOffset; sda < 0.0f; sda += length) {
            }
            return new BasicStroke(gp.getStrokeWidth(), gp.getStrokeLineCap(), gp.getStrokeLineJoin(), gp.getStrokeMiterLimit(), strokeDashArray, sda);
        }
        return new BasicStroke(gp.getStrokeWidth(), gp.getStrokeLineCap(), gp.getStrokeLineJoin(), gp.getStrokeMiterLimit());
    }

    public static Object getStrokedPath(Path path, GraphicsProperties gp) {
        PathSupport.shape.path = path;
        PathSupport.shape.windingRule = gp.getFillRule();
        return PathSupport.getBasicStroke(gp).createStrokedShape(shape);
    }

    public static Object getStrokedRect(float x, float y, float w, float h, GraphicsProperties gp) {
        PathSupport.rect.x = x;
        PathSupport.rect.y = y;
        PathSupport.rect.width = w;
        PathSupport.rect.height = h;
        return PathSupport.getBasicStroke(gp).createStrokedShape(rect);
    }

    public static Object getStrokedRect(float x, float y, float w, float h, float rx, float ry, GraphicsProperties gp) {
        PathSupport.rrect.x = x;
        PathSupport.rrect.y = y;
        PathSupport.rrect.width = w;
        PathSupport.rrect.height = h;
        PathSupport.rrect.arcwidth = rx;
        PathSupport.rrect.archeight = ry;
        return PathSupport.getBasicStroke(gp).createStrokedShape(rrect);
    }

    public static Object getStrokedLine(float x1, float y1, float x2, float y2, GraphicsProperties gp) {
        PathSupport.line.x1 = x1;
        PathSupport.line.x2 = x2;
        PathSupport.line.y1 = y1;
        PathSupport.line.y2 = y2;
        return PathSupport.getBasicStroke(gp).createStrokedShape(line);
    }

    public static Object getStrokedEllipse(float x, float y, float width, float height, GraphicsProperties gp) {
        PathSupport.ellipse.x = x;
        PathSupport.ellipse.y = y;
        PathSupport.ellipse.width = width;
        PathSupport.ellipse.height = height;
        return PathSupport.getBasicStroke(gp).createStrokedShape(ellipse);
    }
}

