/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.source.util.TreePathScanner;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.openide.ErrorManager;

public class EditorContextBridge {
    public static final String FIELD = "field";
    public static final String METHOD = "method";
    public static final String CLASS = "class";
    public static final String LINE = "line";
    private static EditorContext context;

    public static EditorContext getContext() {
        if (context == null) {
            List list = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            context = (EditorContext)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                context = new CompoundContextProvider((EditorContext)list.get(i), context);
            }
        }
        return context;
    }

    public static <R, D> R parseExpression(String string, String string2, int n, TreePathScanner<R, D> treePathScanner, D d, SourcePathProvider sourcePathProvider) throws InvalidExpressionException {
        try {
            return (R)EditorContextBridge.getContext().getClass().getMethod("parseExpression", String.class, String.class, Integer.TYPE, TreePathScanner.class, Object.class, SourcePathProvider.class).invoke((Object)EditorContextBridge.getContext(), string, string2, n, treePathScanner, d, sourcePathProvider);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof InvalidExpressionException) {
                throw (InvalidExpressionException)throwable;
            }
            ErrorManager.getDefault().notify(throwable);
            return null;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return null;
        }
    }

    public static String getFileName(LineBreakpoint lineBreakpoint) {
        try {
            return new File(new URL(lineBreakpoint.getURL()).getFile()).getName();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static boolean showSource(LineBreakpoint lineBreakpoint, Object object) {
        if (lineBreakpoint.getLineNumber() < 1) {
            return EditorContextBridge.getContext().showSource(lineBreakpoint.getURL(), 1, object);
        }
        return EditorContextBridge.getContext().showSource(lineBreakpoint.getURL(), lineBreakpoint.getLineNumber(), object);
    }

    public static String getRelativePath(JPDAThread jPDAThread, String string) {
        try {
            return EditorContextBridge.convertSlash(jPDAThread.getSourcePath(string));
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.getRelativePath(jPDAThread.getClassName());
        }
    }

    public static String getRelativePath(CallStackFrame callStackFrame, String string) {
        try {
            return EditorContextBridge.convertSlash(callStackFrame.getSourcePath(string));
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.getRelativePath(callStackFrame.getClassName());
        }
    }

    public static String getRelativePath(String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            string = string.substring(0, n);
        }
        String string2 = string.replace('.', '/') + ".java";
        return string2;
    }

    private static String convertSlash(String string) {
        return string.replace(File.separatorChar, '/');
    }

    public static int getCurrentOffset() {
        try {
            return (Integer)EditorContextBridge.getContext().getClass().getMethod("getCurrentOffset", new Class[0]).invoke((Object)EditorContextBridge.getContext(), new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            ErrorManager.getDefault().notify(throwable);
            return 0;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return 0;
        }
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;
    }

    private static class CompoundContextProvider
    extends EditorContext {
        private EditorContext cp1;
        private EditorContext cp2;

        CompoundContextProvider(EditorContext editorContext, EditorContext editorContext2) {
            this.cp1 = editorContext;
            this.cp2 = editorContext2;
        }

        public void createTimeStamp(Object object) {
            this.cp1.createTimeStamp(object);
            this.cp2.createTimeStamp(object);
        }

        public void disposeTimeStamp(Object object) {
            this.cp1.disposeTimeStamp(object);
            this.cp2.disposeTimeStamp(object);
        }

        public void updateTimeStamp(Object object, String string) {
            this.cp1.updateTimeStamp(object, string);
            this.cp2.updateTimeStamp(object, string);
        }

        public String getCurrentClassName() {
            String string = this.cp1.getCurrentClassName();
            if (string.trim().length() < 1) {
                return this.cp2.getCurrentClassName();
            }
            return string;
        }

        public String getCurrentURL() {
            String string = this.cp1.getCurrentURL();
            if (string.trim().length() < 1) {
                return this.cp2.getCurrentURL();
            }
            return string;
        }

        public String getCurrentFieldName() {
            String string = this.cp1.getCurrentFieldName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getCurrentFieldName();
            }
            return string;
        }

        public int getCurrentLineNumber() {
            int n = this.cp1.getCurrentLineNumber();
            if (n < 1) {
                return this.cp2.getCurrentLineNumber();
            }
            return n;
        }

        public int getCurrentOffset() {
            Integer n = null;
            try {
                n = (Integer)this.cp1.getClass().getMethod("getCurrentOffset", new Class[0]).invoke((Object)this.cp1, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                ErrorManager.getDefault().notify(throwable);
                return 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == null || n < 1) {
                try {
                    n = (Integer)this.cp2.getClass().getMethod("getCurrentOffset", new Class[0]).invoke((Object)this.cp2, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    ErrorManager.getDefault().notify(throwable);
                    return 0;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                    return 0;
                }
            }
            return n;
        }

        public String getCurrentMethodName() {
            String string = this.cp1.getCurrentMethodName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getCurrentMethodName();
            }
            return string;
        }

        public String getSelectedIdentifier() {
            String string = this.cp1.getSelectedIdentifier();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getSelectedIdentifier();
            }
            return string;
        }

        public String getSelectedMethodName() {
            String string = this.cp1.getSelectedMethodName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getSelectedMethodName();
            }
            return string;
        }

        public void removeAnnotation(Object object) {
            CompoundAnnotation compoundAnnotation = (CompoundAnnotation)object;
            this.cp1.removeAnnotation(compoundAnnotation.annotation1);
            this.cp2.removeAnnotation(compoundAnnotation.annotation2);
        }

        public Object annotate(String string, int n, String string2, Object object) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            compoundAnnotation.annotation1 = this.cp1.annotate(string, n, string2, object);
            compoundAnnotation.annotation2 = this.cp2.annotate(string, n, string2, object);
            return compoundAnnotation;
        }

        public <R, D> R parseExpression(String string, String string2, int n, TreePathScanner<R, D> treePathScanner, D d, SourcePathProvider sourcePathProvider) {
            Throwable throwable;
            Object object = null;
            try {
                object = this.cp1.getClass().getMethod("parseExpression", String.class, String.class, Integer.TYPE, TreePathScanner.class, Object.class, SourcePathProvider.class).invoke((Object)this.cp1, string, string2, n, treePathScanner, d, sourcePathProvider);
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                ErrorManager.getDefault().notify(throwable);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object == null) {
                try {
                    object = this.cp2.getClass().getMethod("parseExpression", String.class, String.class, Integer.TYPE, TreePathScanner.class, Object.class, SourcePathProvider.class).invoke((Object)this.cp2, string, string2, n, treePathScanner, d, sourcePathProvider);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    ErrorManager.getDefault().notify(throwable);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
            return (R)object;
        }

        public int getLineNumber(Object object, Object object2) {
            int n = this.cp1.getLineNumber(object, object2);
            if (n >= 0) {
                return n;
            }
            return this.cp2.getLineNumber(object, object2);
        }

        public boolean showSource(String string, int n, Object object) {
            return this.cp1.showSource(string, n, object) | this.cp2.showSource(string, n, object);
        }

        public int getFieldLineNumber(String string, String string2, String string3) {
            int n = this.cp1.getFieldLineNumber(string, string2, string3);
            if (n != -1) {
                return n;
            }
            return this.cp2.getFieldLineNumber(string, string2, string3);
        }

        public String getClassName(String string, int n) {
            String string2 = this.cp1.getClassName(string, n);
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
            return this.cp2.getClassName(string, n);
        }

        public String[] getImports(String string) {
            String[] stringArray = this.cp1.getImports(string);
            String[] stringArray2 = this.cp2.getImports(string);
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(propertyChangeListener);
            this.cp2.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(propertyChangeListener);
            this.cp2.removePropertyChangeListener(propertyChangeListener);
        }

        public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(string, propertyChangeListener);
            this.cp2.addPropertyChangeListener(string, propertyChangeListener);
        }

        public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(string, propertyChangeListener);
            this.cp2.removePropertyChangeListener(string, propertyChangeListener);
        }

        public EditorContext.Operation[] getOperations(String string, int n, EditorContext.BytecodeProvider bytecodeProvider) {
            EditorContext.Operation[] operationArray = this.cp1.getOperations(string, n, bytecodeProvider);
            if (operationArray != null) {
                return operationArray;
            }
            return this.cp2.getOperations(string, n, bytecodeProvider);
        }

        public EditorContext.MethodArgument[] getArguments(String string, EditorContext.Operation operation) {
            EditorContext.MethodArgument[] methodArgumentArray;
            try {
                methodArgumentArray = this.cp1.getArguments(string, operation);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                methodArgumentArray = this.cp2.getArguments(string, operation);
            }
            return methodArgumentArray;
        }

        public EditorContext.MethodArgument[] getArguments(String string, int n) {
            EditorContext.MethodArgument[] methodArgumentArray;
            try {
                methodArgumentArray = this.cp1.getArguments(string, n);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                methodArgumentArray = this.cp2.getArguments(string, n);
            }
            return methodArgumentArray;
        }
    }
}

