/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;

class TreeObject {
    private static final int BUFFER_SIZE = 8192;
    private HprofHeap heap;
    private LongBuffer readBuffer;
    private LongBuffer writeBuffer;

    TreeObject(HprofHeap h, LongBuffer leaves) {
        this.heap = h;
        this.writeBuffer = leaves;
    }

    synchronized void computeTrees() {
        try {
            boolean changed;
            this.createBuffers();
            do {
                this.switchBuffers();
            } while (changed = this.computeOneLevel());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.deleteBuffers();
    }

    private boolean computeOneLevel() throws IOException {
        boolean changed = false;
        while (true) {
            List fieldValues;
            Instance refInstance;
            long instanceId = this.readLong();
            long retainedSize = 0L;
            if (instanceId == 0L) break;
            Instance instance = this.heap.getInstanceByID(instanceId);
            if (instance instanceof ObjectArrayInstance) {
                Iterator instanceIt = ((ObjectArrayInstance)instance).getValues().iterator();
                long size = 0L;
                while (instanceIt.hasNext() && size != -1L) {
                    refInstance = (Instance)instanceIt.next();
                    size = this.checkInstance(instanceId, refInstance);
                    retainedSize += size;
                }
                changed |= this.processInstance(instance, size, retainedSize);
                continue;
            }
            if (instance instanceof PrimitiveArrayInstance) {
                assert (false) : "Error - PrimitiveArrayInstance not allowed " + instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
                continue;
            }
            if (instance instanceof ClassDumpInstance) {
                ClassDump javaClass = ((ClassDumpInstance)instance).classDump;
                fieldValues = javaClass.getStaticFieldValues();
            } else if (instance instanceof InstanceDump) {
                fieldValues = instance.getFieldValues();
            } else {
                if (instance == null) {
                    System.err.println("HeapWalker Warning - null instance for " + instanceId);
                    continue;
                }
                throw new IllegalArgumentException("Illegal type " + instance.getClass());
            }
            long size = 0L;
            Iterator valuesIt = fieldValues.iterator();
            while (valuesIt.hasNext() && size != -1L) {
                FieldValue val = (FieldValue)valuesIt.next();
                if (!(val instanceof ObjectFieldValue)) continue;
                refInstance = ((ObjectFieldValue)val).getInstance();
                size = this.checkInstance(instanceId, refInstance);
                retainedSize += size;
            }
            changed |= this.processInstance(instance, size, retainedSize);
        }
        return changed;
    }

    private boolean processInstance(Instance instance, long size, long retainedSize) throws IOException {
        if (size != -1L) {
            LongMap.Entry gcRootPointerEntry;
            long gcRootPointer;
            LongMap.Entry entry = this.heap.idToOffsetMap.get(instance.getInstanceId());
            entry.setRetainedSize((int)((long)instance.getSize() + retainedSize));
            entry.setTreeObj();
            if (entry.hasOnlyOneReference() && (gcRootPointer = entry.getNearestGCRootPointer()) != 0L && (gcRootPointerEntry = this.heap.idToOffsetMap.get(gcRootPointer)).getRetainedSize() == 0) {
                gcRootPointerEntry.setRetainedSize(-1);
                this.writeLong(gcRootPointer);
            }
            return true;
        }
        return false;
    }

    private void createBuffers() {
        this.readBuffer = new LongBuffer(8192);
    }

    private void deleteBuffers() {
        this.readBuffer.delete();
        this.writeBuffer.delete();
    }

    private long readLong() throws IOException {
        return this.readBuffer.readLong();
    }

    private void switchBuffers() {
        LongBuffer b = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = b;
        this.readBuffer.startReading();
        this.writeBuffer.reset();
    }

    private void writeLong(long instanceId) throws IOException {
        if (instanceId != 0L) {
            this.writeBuffer.writeLong(instanceId);
        }
    }

    private long checkInstance(long instanceId, Instance refInstance) throws IOException {
        long retainedSize = 0L;
        if (refInstance != null) {
            LongMap.Entry refEntry = this.heap.idToOffsetMap.get(refInstance.getInstanceId());
            if (!refEntry.hasOnlyOneReference()) {
                return -1L;
            }
            if (!refEntry.isTreeObj()) {
                this.writeLong(instanceId);
                return -1L;
            }
            retainedSize += (long)refEntry.getRetainedSize();
        }
        return retainedSize;
    }
}

