/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEvent;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEventListener;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEventListenerAdapter;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schemas;
import org.netbeans.modules.xml.jaxb.ui.JAXBWizardRootNode;
import org.netbeans.modules.xml.jaxb.util.ProjectHelper;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.Node;

public class JAXBNodeFactory
implements NodeFactory {
    public static final String JAXB_NODE_NAME = "JAXB Bindings";

    public static JAXBNodeFactory webproject() {
        return new JAXBNodeFactory();
    }

    public static JAXBNodeFactory ejbproject() {
        return new JAXBNodeFactory();
    }

    public synchronized NodeList<String> createNodes(Project project) {
        return new JAXBRootNodeList(project);
    }

    private class JAXBRootNodeList
    implements NodeList<String> {
        private Project project;
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private JAXBWizEventListener modelListener = new ModelListener();
        private List<String> rootKeys = null;

        public JAXBRootNodeList(Project prj) {
            this.project = prj;
            this.rootKeys = new ArrayList<String>();
            ProjectHelper.addModelListener(prj, this.modelListener);
            this.updateKeys();
        }

        private synchronized void updateKeys() {
            Schemas scs = ProjectHelper.getXMLBindingSchemas(this.project);
            this.rootKeys.clear();
            if (scs != null && scs.sizeSchema() > 0) {
                this.rootKeys.add(JAXBNodeFactory.JAXB_NODE_NAME);
            }
        }

        private synchronized void updateKeys(Schemas scs) {
            this.rootKeys.clear();
            if (scs != null && scs.sizeSchema() > 0) {
                this.rootKeys.add(JAXBNodeFactory.JAXB_NODE_NAME);
            }
        }

        public List<String> keys() {
            List<String> immutable = Collections.unmodifiableList(this.rootKeys);
            return immutable;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }

        public synchronized Node node(String key) {
            JAXBWizardRootNode ret = null;
            if (JAXBNodeFactory.JAXB_NODE_NAME.equals(key)) {
                ret = new JAXBWizardRootNode(this.project);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ArrayList<ChangeListener> list = new ArrayList<ChangeListener>();
            JAXBRootNodeList jAXBRootNodeList = this;
            synchronized (jAXBRootNodeList) {
                list.addAll(this.listeners);
            }
            for (ChangeListener elem : list) {
                elem.stateChanged(new ChangeEvent(this));
            }
        }

        private final class ModelListener
        extends JAXBWizEventListenerAdapter {
            private ModelListener() {
            }

            @Override
            public void bindingAdded(JAXBWizEvent event) {
                if (event.getSource() instanceof Schemas) {
                    JAXBRootNodeList.this.updateKeys((Schemas)event.getSource());
                    JAXBRootNodeList.this.fireChange();
                }
            }

            @Override
            public void bindingDeleted(JAXBWizEvent event) {
                if (event.getSource() instanceof Schemas) {
                    JAXBRootNodeList.this.updateKeys((Schemas)event.getSource());
                    JAXBRootNodeList.this.fireChange();
                }
            }

            @Override
            public void configFileEdited(JAXBWizEvent event) {
                if (event.getSource() instanceof Schemas) {
                    JAXBRootNodeList.this.updateKeys((Schemas)event.getSource());
                    JAXBRootNodeList.this.fireChange();
                }
            }
        }
    }
}

