/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.groovy.support.debug.Context;
import org.netbeans.modules.groovy.support.debug.GroovyBreakpointAnnotationListener;
import org.netbeans.modules.groovy.support.debug.GroovyLineBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.filesystems.FileObject;

public class GroovyToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebugger debugger;
    private GroovyBreakpointAnnotationListener GroovyBreakpointAnnotationListener;

    public GroovyToggleBreakpointActionProvider() {
        Context.addPropertyChangeListener(this);
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    public GroovyToggleBreakpointActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        Context.addPropertyChangeListener(this);
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        Context.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        FileObject fileObject = Context.getCurrentFile();
        boolean bl = fileObject != null && "text/x-groovy".equals(fileObject.getMIMEType());
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
        if (this.debugger != null && this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void doAction(Object object) {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        int n = Context.getCurrentLineNumber();
        String string = Context.getCurrentURL();
        if (string == null) {
            return;
        }
        GroovyLineBreakpoint groovyLineBreakpoint = this.getGroovyBreakpointAnnotationListener().findBreakpoint(string, n);
        if (groovyLineBreakpoint != null) {
            debuggerManager.removeBreakpoint((Breakpoint)groovyLineBreakpoint);
            return;
        }
        groovyLineBreakpoint = GroovyLineBreakpoint.create(string, n);
        debuggerManager.addBreakpoint((Breakpoint)groovyLineBreakpoint);
    }

    private GroovyBreakpointAnnotationListener getGroovyBreakpointAnnotationListener() {
        if (this.GroovyBreakpointAnnotationListener == null) {
            this.GroovyBreakpointAnnotationListener = (GroovyBreakpointAnnotationListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, GroovyBreakpointAnnotationListener.class));
        }
        return this.GroovyBreakpointAnnotationListener;
    }
}

