/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.modules.project.rake.UserQuestionHandler;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

public final class GeneratedFilesHelper {
    public static final String BUILD_XML_PATH = "build.xml";
    public static final String BUILD_IMPL_XML_PATH = "nbproject/build-impl.xml";
    static final String GENFILES_PROPERTIES_PATH = "nbproject/genfiles.properties";
    private static final String KEY_SUFFIX_DATA_CRC = ".data.CRC32";
    private static final String KEY_SUFFIX_STYLESHEET_CRC = ".stylesheet.CRC32";
    private static final String KEY_SUFFIX_SCRIPT_CRC = ".script.CRC32";
    public static final int FLAG_MISSING = 2;
    public static final int FLAG_MODIFIED = 4;
    public static final int FLAG_OLD_PROJECT_XML = 8;
    public static final int FLAG_OLD_STYLESHEET = 16;
    public static final int FLAG_UNKNOWN = 32;
    private final RakeProjectHelper h;
    private final FileObject dir;
    private static final Map<URL, String> crcCache = new HashMap<URL, String>();
    private static final Map<URL, Long> crcCacheTimestampsXorSizes = new HashMap<URL, Long>();

    public GeneratedFilesHelper(RakeProjectHelper h) {
        this.h = h;
        this.dir = h.getProjectDirectory();
    }

    public GeneratedFilesHelper(FileObject d) {
        if (d == null || !d.isFolder() || d.getFileObject("nbproject/project.xml") == null) {
            throw new IllegalArgumentException("Does not look like an Ant-based project: " + d);
        }
        this.h = null;
        this.dir = d;
    }

    public void generateBuildScriptFromStylesheet(final String path, final URL stylesheet) throws IOException, IllegalStateException {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (stylesheet == null) {
            throw new IllegalArgumentException("Null stylesheet");
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    if (GeneratedFilesHelper.this.h != null && GeneratedFilesHelper.this.h.isProjectXmlModified()) {
                        throw new IllegalStateException("Cannot generate build scripts from a modified project");
                    }
                    GeneratedFilesHelper.this.dir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            byte[] resultData;
                            byte[] stylesheetData;
                            byte[] projectXmlData;
                            FileObject projectXml = GeneratedFilesHelper.this.dir.getFileObject("nbproject/project.xml");
                            final FileObject buildScriptXml = FileUtil.createData((FileObject)GeneratedFilesHelper.this.dir, (String)path);
                            InputStream is = projectXml.getInputStream();
                            try {
                                projectXmlData = GeneratedFilesHelper.load(is);
                            }
                            finally {
                                is.close();
                            }
                            is = stylesheet.openStream();
                            try {
                                stylesheetData = GeneratedFilesHelper.load(is);
                            }
                            finally {
                                is.close();
                            }
                            TransformerFactory tf = TransformerFactory.newInstance();
                            try {
                                StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(stylesheetData), stylesheet.toExternalForm());
                                Transformer t = tf.newTransformer(stylesheetSource);
                                File projectXmlF = FileUtil.toFile((FileObject)projectXml);
                                assert (projectXmlF != null);
                                StreamSource projectXmlSource = new StreamSource(new ByteArrayInputStream(projectXmlData), projectXmlF.toURI().toString());
                                ByteArrayOutputStream result = new ByteArrayOutputStream();
                                t.transform(projectXmlSource, new StreamResult(result));
                                resultData = result.toByteArray();
                            }
                            catch (TransformerException e) {
                                throw (IOException)new IOException(e.toString()).initCause(e);
                            }
                            final EditableProperties p = new EditableProperties(true);
                            FileObject genfiles = GeneratedFilesHelper.this.dir.getFileObject(GeneratedFilesHelper.GENFILES_PROPERTIES_PATH);
                            if (genfiles != null && genfiles.isVirtual()) {
                                genfiles = null;
                            }
                            if (genfiles != null) {
                                is = genfiles.getInputStream();
                                try {
                                    p.load(is);
                                }
                                finally {
                                    is.close();
                                }
                            }
                            p.setProperty(path + GeneratedFilesHelper.KEY_SUFFIX_DATA_CRC, GeneratedFilesHelper.getCrc32(new ByteArrayInputStream(projectXmlData), projectXml));
                            if (genfiles == null) {
                                p.setComment(path + GeneratedFilesHelper.KEY_SUFFIX_DATA_CRC, new String[]{"# " + NbBundle.getMessage(GeneratedFilesHelper.class, (String)"COMMENT_genfiles.properties_1"), "# " + NbBundle.getMessage(GeneratedFilesHelper.class, (String)"COMMENT_genfiles.properties_2")}, false);
                            }
                            p.setProperty(path + GeneratedFilesHelper.KEY_SUFFIX_STYLESHEET_CRC, GeneratedFilesHelper.getCrc32(new ByteArrayInputStream(stylesheetData), stylesheet));
                            p.setProperty(path + GeneratedFilesHelper.KEY_SUFFIX_SCRIPT_CRC, GeneratedFilesHelper.computeCrc32(new ByteArrayInputStream(resultData)));
                            if (genfiles == null) {
                                genfiles = FileUtil.createData((FileObject)GeneratedFilesHelper.this.dir, (String)GeneratedFilesHelper.GENFILES_PROPERTIES_PATH);
                            }
                            final FileObject _genfiles = genfiles;
                            final FileSystem.AtomicAction body = new FileSystem.AtomicAction(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() throws IOException {
                                    FileLock lock1 = buildScriptXml.lock();
                                    try {
                                        FileLock lock2 = _genfiles.lock();
                                        try {
                                            EolFilterOutputStream os1 = new EolFilterOutputStream(buildScriptXml.getOutputStream(lock1));
                                            try {
                                                OutputStream os2 = _genfiles.getOutputStream(lock2);
                                                try {
                                                    ((OutputStream)os1).write(resultData);
                                                    p.store(os2);
                                                }
                                                finally {
                                                    os2.close();
                                                }
                                            }
                                            finally {
                                                ((OutputStream)os1).close();
                                            }
                                        }
                                        finally {
                                            lock2.releaseLock();
                                        }
                                    }
                                    finally {
                                        lock1.releaseLock();
                                    }
                                }
                            };
                            try {
                                body.run();
                            }
                            catch (UserQuestionException uqe) {
                                UserQuestionHandler.handle(uqe, new UserQuestionHandler.Callback(){

                                    @Override
                                    public void accepted() {
                                        try {
                                            body.run();
                                        }
                                        catch (UserQuestionException uqe2) {
                                            UserQuestionHandler.handle(uqe2, new UserQuestionHandler.Callback(){

                                                @Override
                                                public void accepted() {
                                                    try {
                                                        body.run();
                                                    }
                                                    catch (IOException e) {
                                                        ErrorManager.getDefault().notify((Throwable)e);
                                                    }
                                                }

                                                @Override
                                                public void denied() {
                                                }

                                                @Override
                                                public void error(IOException e) {
                                                    ErrorManager.getDefault().notify((Throwable)e);
                                                }
                                            });
                                        }
                                        catch (IOException e) {
                                            ErrorManager.getDefault().notify((Throwable)e);
                                        }
                                    }

                                    @Override
                                    public void denied() {
                                    }

                                    @Override
                                    public void error(IOException e) {
                                        ErrorManager.getDefault().notify((Throwable)e);
                                    }
                                });
                            }
                        }
                    });
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private static byte[] load(InputStream is) throws IOException {
        int read;
        int size = Math.max(1024, is.available());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        byte[] buf = new byte[size];
        while ((read = is.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        return baos.toByteArray();
    }

    public int getBuildScriptState(final String path, final URL stylesheet) throws IllegalStateException {
        try {
            return (Integer)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Integer run() throws IOException {
                    String crc;
                    if (GeneratedFilesHelper.this.h != null && GeneratedFilesHelper.this.h.isProjectXmlModified()) {
                        throw new IllegalStateException("Cannot generate build scripts from a modified project");
                    }
                    FileObject script = GeneratedFilesHelper.this.dir.getFileObject(path);
                    if (script == null || script.isVirtual()) {
                        return 2;
                    }
                    int flags = 0;
                    Properties p = new Properties();
                    FileObject genfiles = GeneratedFilesHelper.this.dir.getFileObject(GeneratedFilesHelper.GENFILES_PROPERTIES_PATH);
                    if (genfiles == null || genfiles.isVirtual()) {
                        return 60;
                    }
                    BufferedInputStream is = new BufferedInputStream(genfiles.getInputStream());
                    try {
                        p.load(is);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                    FileObject projectXml = GeneratedFilesHelper.this.dir.getFileObject("nbproject/project.xml");
                    if (projectXml != null && !projectXml.isVirtual()) {
                        crc = GeneratedFilesHelper.getCrc32(projectXml);
                        if (!crc.equals(p.getProperty(path + GeneratedFilesHelper.KEY_SUFFIX_DATA_CRC))) {
                            flags |= 8;
                        }
                    } else {
                        flags |= 8;
                    }
                    crc = GeneratedFilesHelper.getCrc32(stylesheet);
                    if (!crc.equals(p.getProperty(path + GeneratedFilesHelper.KEY_SUFFIX_STYLESHEET_CRC))) {
                        flags |= 0x10;
                    }
                    if (!(crc = GeneratedFilesHelper.getCrc32(script)).equals(p.getProperty(path + GeneratedFilesHelper.KEY_SUFFIX_SCRIPT_CRC))) {
                        flags |= 4;
                    }
                    return flags;
                }
            });
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify(1, (Throwable)((IOException)e.getException()));
            return 60;
        }
    }

    static String computeCrc32(InputStream is) throws IOException {
        int curr;
        CRC32 crc = new CRC32();
        int last = -1;
        while ((curr = is.read()) != -1) {
            if (curr != 10 && last == 13) {
                crc.update(10);
            }
            if (curr != 13) {
                crc.update(curr);
            }
            last = curr;
        }
        if (last == 13) {
            crc.update(10);
        }
        int val = (int)crc.getValue();
        String hex = Integer.toHexString(val);
        while (hex.length() < 8) {
            hex = "0" + hex;
        }
        return hex;
    }

    private static synchronized String findCachedCrc32(URL u, long footprint) {
        String crc = crcCache.get(u);
        if (crc != null) {
            Long l = crcCacheTimestampsXorSizes.get(u);
            assert (l != null);
            if (l == footprint) {
                return crc;
            }
        }
        return null;
    }

    private static synchronized void cacheCrc32(String crc, URL u, long footprint) {
        crcCache.put(u, crc);
        crcCacheTimestampsXorSizes.put(u, footprint);
    }

    private static String getCrc32(InputStream is, FileObject fo) throws IOException {
        URL u = fo.getURL();
        fo.refresh();
        long footprint = fo.lastModified().getTime() ^ fo.getSize();
        String crc = GeneratedFilesHelper.findCachedCrc32(u, footprint);
        if (crc == null) {
            crc = GeneratedFilesHelper.computeCrc32(is);
            GeneratedFilesHelper.cacheCrc32(crc, u, footprint);
        }
        return crc;
    }

    private static long checkFootprint(URL u) {
        URL nested = FileUtil.getArchiveFile((URL)u);
        if (nested != null) {
            u = nested;
        }
        if (u.getProtocol().equals("file")) {
            File f = new File(URI.create(u.toExternalForm()));
            return f.lastModified() ^ f.length();
        }
        return 0L;
    }

    private static String getCrc32(InputStream is, URL u) throws IOException {
        long footprint = GeneratedFilesHelper.checkFootprint(u);
        String crc = null;
        if (footprint != 0L) {
            crc = GeneratedFilesHelper.findCachedCrc32(u, footprint);
        }
        if (crc == null) {
            crc = GeneratedFilesHelper.computeCrc32(is);
            if (footprint != 0L) {
                GeneratedFilesHelper.cacheCrc32(crc, u, footprint);
            }
        }
        return crc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCrc32(FileObject fo) throws IOException {
        URL u = fo.getURL();
        fo.refresh();
        long footprint = fo.lastModified().getTime() ^ fo.getSize();
        String crc = GeneratedFilesHelper.findCachedCrc32(u, footprint);
        if (crc == null) {
            InputStream is = fo.getInputStream();
            try {
                crc = GeneratedFilesHelper.computeCrc32(new BufferedInputStream(is));
                GeneratedFilesHelper.cacheCrc32(crc, u, footprint);
            }
            finally {
                is.close();
            }
        }
        return crc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCrc32(URL u) throws IOException {
        long footprint = GeneratedFilesHelper.checkFootprint(u);
        String crc = null;
        if (footprint != 0L) {
            crc = GeneratedFilesHelper.findCachedCrc32(u, footprint);
        }
        if (crc == null) {
            InputStream is = u.openStream();
            try {
                crc = GeneratedFilesHelper.computeCrc32(new BufferedInputStream(is));
                if (footprint != 0L) {
                    GeneratedFilesHelper.cacheCrc32(crc, u, footprint);
                }
            }
            finally {
                is.close();
            }
        }
        return crc;
    }

    public boolean refreshBuildScript(final String path, final URL stylesheet, final boolean checkForProjectXmlModified) throws IOException, IllegalStateException {
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    int flags = GeneratedFilesHelper.this.getBuildScriptState(path, stylesheet);
                    if (GeneratedFilesHelper.shouldGenerateBuildScript(flags, checkForProjectXmlModified)) {
                        GeneratedFilesHelper.this.generateBuildScriptFromStylesheet(path, stylesheet);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private static boolean shouldGenerateBuildScript(int flags, boolean checkForProjectXmlModified) {
        if ((flags & 2) != 0) {
            return true;
        }
        if ((flags & 4) != 0) {
            return false;
        }
        if (!checkForProjectXmlModified) {
            return true;
        }
        return (flags & 0x18) != 0;
    }

    private static class EolFilterOutputStream
    extends BufferedOutputStream {
        private boolean isActive = Utilities.isWindows();
        private int last = -1;

        public EolFilterOutputStream(OutputStream os) {
            super(os, 4096);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.isActive) {
                for (int i = off; i < off + len; ++i) {
                    this.write(b[i]);
                }
            } else {
                super.write(b, off, len);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.isActive) {
                if (b == 10 && this.last != 13) {
                    super.write(13);
                }
                this.last = b;
            }
            super.write(b);
        }
    }
}

