/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RemoteProjectSupport {
    private RemoteProjectSupport() {
    }

    public static ExecutionEnvironment getExecutionEnvironment(Project project) {
        MakeConfiguration mk = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (mk != null) {
            return mk.getDevelopmentHost().getExecutionEnvironment();
        }
        return null;
    }

    public static boolean projectExists(Project project) {
        File baseDir = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
        File nbproject = new File(baseDir, "nbproject");
        return nbproject.exists();
    }

    public static File getPrivateStorage(Project project) {
        File baseDir = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
        File privProjectStorage = new File(new File(baseDir, "nbproject"), "private");
        return privProjectStorage;
    }

    public static File[] getProjectSourceDirs(Project project) {
        MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (conf == null) {
            File baseDir = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
            return new File[]{baseDir};
        }
        return RemoteProjectSupport.getProjectSourceDirs(project, conf);
    }

    public static File[] getProjectSourceDirs(Project project, MakeConfiguration conf) {
        File baseDir = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
        if (conf == null) {
            return new File[]{baseDir};
        }
        HashSet<File> sourceFilesAndDirs = new HashSet<File>();
        sourceFilesAndDirs.add(baseDir);
        MakeConfigurationDescriptor mcs = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)project);
        if (mcs == null) {
            return new File[0];
        }
        for (String soorceRoot : mcs.getSourceRoots()) {
            String path = CndPathUtilitities.toAbsolutePath((String)baseDir.getAbsolutePath(), (String)soorceRoot);
            File file = new File(path);
            sourceFilesAndDirs.add(file);
        }
        RemoteProjectSupport.addExtraFiles(mcs, sourceFilesAndDirs);
        for (String subprojectDir : conf.getSubProjectLocations()) {
            subprojectDir = CndPathUtilitities.toAbsolutePath((String)baseDir.getAbsolutePath(), (String)subprojectDir);
            sourceFilesAndDirs.add(new File(subprojectDir));
        }
        for (Project subProject : conf.getSubProjects()) {
            MakeConfigurationDescriptor subMcs = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)subProject);
            for (String soorceRoot : mcs.getSourceRoots()) {
                File file = new File(soorceRoot).getAbsoluteFile();
                sourceFilesAndDirs.add(file);
            }
            RemoteProjectSupport.addExtraFiles(subMcs, sourceFilesAndDirs);
        }
        return sourceFilesAndDirs.toArray(new File[sourceFilesAndDirs.size()]);
    }

    private static void addExtraFiles(MakeConfigurationDescriptor subMcs, Set<File> filesToSync) {
        SharabilityFilter filter = new SharabilityFilter();
        for (Item item : subMcs.getProjectItems()) {
            File normFile = item.getNormalizedFile();
            if (!filter.accept(normFile)) {
                filesToSync.add(normFile);
                continue;
            }
            if (!RemoteProjectSupport.isContained(normFile, filesToSync)) {
                filesToSync.add(normFile);
                continue;
            }
            if (normFile.exists()) continue;
            filesToSync.add(normFile);
        }
    }

    private static boolean isContained(File normFile, Set<File> files) {
        String itemAbsPath = normFile.getAbsolutePath();
        for (File dir : files) {
            String alreadyAddedPath;
            if (!dir.isDirectory() || !itemAbsPath.startsWith(alreadyAddedPath = dir.getAbsolutePath() + File.separatorChar)) continue;
            return true;
        }
        return false;
    }
}

