/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.library;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.persistence.wizard.library.J2SEVolumeCustomizer;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class PersistenceLibraryPanel
extends JPanel {
    public static final String IS_VALID = "PersistenceLibraryPanel_isValid";
    private LibraryImplementation libImpl;
    private Color nbErrorForeground;
    private Color nbWarningForeground;
    static final String ERROR_GIF = "org/netbeans/modules/dialogs/error.gif";
    static final String WARNING_GIF = "org/netbeans/modules/dialogs/warning.gif";
    private JLabel errorMessage;
    private JLabel jLabel1;
    private JTextField libraryNameTextField;
    private JTabbedPane tabbedPane;

    public PersistenceLibraryPanel(LibraryImplementation libraryImplementation) {
        this.initComponents();
        this.libImpl = libraryImplementation;
        J2SEVolumeCustomizer j2SEVolumeCustomizer = new J2SEVolumeCustomizer("classpath");
        j2SEVolumeCustomizer.setObject(libraryImplementation);
        this.tabbedPane.add(j2SEVolumeCustomizer);
        J2SEVolumeCustomizer j2SEVolumeCustomizer2 = new J2SEVolumeCustomizer("src");
        j2SEVolumeCustomizer2.setObject(libraryImplementation);
        this.tabbedPane.add(j2SEVolumeCustomizer2);
        J2SEVolumeCustomizer j2SEVolumeCustomizer3 = new J2SEVolumeCustomizer("javadoc");
        j2SEVolumeCustomizer3.setObject(libraryImplementation);
        this.tabbedPane.add(j2SEVolumeCustomizer3);
        this.tabbedPane.setMnemonicAt(0, NbBundle.getMessage(PersistenceLibraryPanel.class, (String)"MNE_ClasspathTab").charAt(0));
        this.tabbedPane.setMnemonicAt(1, NbBundle.getMessage(PersistenceLibraryPanel.class, (String)"MNE_SourcesTab").charAt(0));
        this.tabbedPane.setMnemonicAt(2, NbBundle.getMessage(PersistenceLibraryPanel.class, (String)"MNE_JavadocTab").charAt(0));
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.nbWarningForeground = UIManager.getColor("nb.warningForeground");
        if (this.nbWarningForeground == null) {
            this.nbWarningForeground = new Color(51, 51, 51);
        }
        LibraryManager libraryManager = LibraryManager.getDefault();
        String string = "PersistenceLibrary";
        int n = 1;
        while (libraryManager.getLibrary(string + n) != null) {
            ++n;
        }
        this.libraryNameTextField.setText(string + n);
        this.libraryNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                PersistenceLibraryPanel.this.checkValidity();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                PersistenceLibraryPanel.this.checkValidity();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                PersistenceLibraryPanel.this.checkValidity();
            }
        });
        libraryImplementation.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PersistenceLibraryPanel.this.checkValidity();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.libraryNameTextField.requestFocus();
        this.libraryNameTextField.selectAll();
    }

    public void apply() {
        this.libImpl.setName(this.libraryNameTextField.getText().trim());
        PersistenceLibrarySupport.getDefault().addLibrary(this.libImpl);
    }

    void checkValidity() {
        String string = this.libraryNameTextField.getText();
        if (string.trim().equals("")) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceLibrarySupport.class, (String)"ERR_EmptyName"), false);
            this.firePropertyChange(IS_VALID, true, false);
        } else if (LibraryManager.getDefault().getLibrary(string) != null) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceLibrarySupport.class, (String)"ERR_LibraryExists"), false);
            this.firePropertyChange(IS_VALID, true, false);
        } else if (!this.containsEntityManager()) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceLibrarySupport.class, (String)"ERR_NoEntityManager"), false);
            this.firePropertyChange(IS_VALID, true, false);
        } else if (!this.containsPersistenceProvider()) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceLibrarySupport.class, (String)"ERR_NoPersistenceProvider"), false);
            this.firePropertyChange(IS_VALID, true, false);
        } else {
            this.setErrorMessage("", true);
            this.firePropertyChange(IS_VALID, false, true);
        }
    }

    private void setErrorMessage(String string, Boolean bl) {
        this.errorMessage.setForeground(this.nbErrorForeground);
        if (string != null && string.trim().length() > 0 && bl != null) {
            if (bl.booleanValue()) {
                this.errorMessage.setIcon(ImageUtilities.loadImageIcon((String)WARNING_GIF, (boolean)false));
                this.errorMessage.setForeground(this.nbWarningForeground);
            } else {
                this.errorMessage.setIcon(ImageUtilities.loadImageIcon((String)ERROR_GIF, (boolean)false));
            }
            this.errorMessage.setToolTipText(string);
        } else {
            this.errorMessage.setIcon(null);
            this.errorMessage.setToolTipText(null);
        }
        this.errorMessage.setText(string);
    }

    private boolean containsEntityManager() {
        return PersistenceLibrarySupport.containsClass(this.libImpl, "javax.persistence.EntityManager");
    }

    private boolean containsPersistenceProvider() {
        return PersistenceLibrarySupport.containsService(this.libImpl, "javax.persistence.spi.PersistenceProvider");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.libraryNameTextField = new JTextField();
        this.tabbedPane = new JTabbedPane();
        this.errorMessage = new JLabel();
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/library/Bundle").getString("MNE_LibraryName").charAt(0));
        this.jLabel1.setLabelFor(this.libraryNameTextField);
        this.jLabel1.setText(NbBundle.getMessage(PersistenceLibraryPanel.class, (String)"LBL_LibraryName"));
        this.libraryNameTextField.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/library/Bundle").getString("LBL_LibraryName"));
        this.libraryNameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/library/Bundle").getString("AD_LibraryName"));
        this.errorMessage.setText(" ");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.tabbedPane, -1, 376, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.libraryNameTextField, -1, 305, Short.MAX_VALUE)).add(1, (Component)this.errorMessage, -1, 376, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.libraryNameTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.tabbedPane, -1, 230, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.errorMessage).addContainerGap()));
    }
}

