/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.JPAParseUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataLoader;
import org.netbeans.modules.j2ee.persistence.unit.PUDataNode;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceToolBarMVElement;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PUDataObject
extends XmlMultiViewDataObject {
    public static final String HELP_ID_DESIGN_PERSISTENCE_UNIT = "persistence_multiview_design_persistenceUnitNode";
    private ModelSynchronizer modelSynchronizer = new ModelSynchronizer(this);
    public static final int UPDATE_DELAY = 200;
    private static final int TYPE_TOOLBAR = 0;
    private org.netbeans.modules.j2ee.persistence.dd.common.Persistence persistence;
    private static final String DESIGN_VIEW_ID = "persistence_multiview_design";
    private static final Logger LOG = Logger.getLogger(PUDataObject.class.getName());
    public static final String NO_UI_PU_CLASSES_CHANGED = "non ui pu classes modified";
    static final String PERSISTENCE_UNIT_ADDED_OR_REMOVED = "persistence_unit_added_or_removed";

    public PUDataObject(FileObject fileObject, PUDataLoader pUDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)pUDataLoader);
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkXMLSupport = new CheckXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)checkXMLSupport);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)validateXMLSupport);
        this.parseDocument();
    }

    protected Node createNodeDelegate() {
        return new PUDataNode(this);
    }

    public void save() {
        EditorCookie editorCookie = (EditorCookie)this.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            try {
                editorCookie.saveDocument();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseDocument() {
        block16: {
            if (this.persistence == null) {
                try {
                    this.persistence = this.getPersistence();
                }
                catch (RuntimeException runtimeException) {
                    LOG.log(Level.INFO, null, runtimeException);
                    return false;
                }
            }
            try {
                String string = this.persistence.getVersion();
                InputStream inputStream = this.getEditorSupport().getInputStream();
                String string2 = "1.0";
                try {
                    string2 = JPAParseUtils.getVersion(inputStream);
                }
                catch (SAXException sAXException) {
                    LOG.log(Level.INFO, null, sAXException);
                }
                finally {
                    inputStream.close();
                }
                inputStream = this.getEditorSupport().getInputStream();
                BaseBean baseBean = null;
                try {
                    baseBean = "2.0".equals(string2) ? org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.Persistence.createGraph(inputStream) : Persistence.createGraph(inputStream);
                }
                catch (RuntimeException runtimeException) {
                    LOG.log(Level.INFO, null, runtimeException);
                    return false;
                }
                if (baseBean == null) break block16;
                try {
                    ((BaseBean)this.persistence).merge(baseBean, 3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOG.log(Level.FINE, "IAE thrown during merge, see #104180.", illegalArgumentException);
                    if (!this.persistence.getVersion().equals(baseBean.getVersion())) {
                        this.persistence = null;
                        PersistenceMetadata.getDefault().refresh(this.getPrimaryFile());
                        return true;
                    }
                    return false;
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, null, iOException);
                return false;
            }
        }
        return true;
    }

    public boolean viewCanBeDisplayed() {
        boolean bl = false;
        NotifyDescriptor.Message message = null;
        if (!this.parseDocument() && this.getSelectedPerspective().preferredID().startsWith(DESIGN_VIEW_ID)) {
            message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PUDataObject.class, (String)"TXT_DocumentUnparsable", (Object)this.getPrimaryFile().getNameExt()), 2);
            bl = true;
        } else if (!ProviderUtil.isValidServerInstanceOrNone(FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile())) && this.getSelectedPerspective().preferredID().startsWith(DESIGN_VIEW_ID)) {
            message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PUDataObject.class, (String)"TXT_ServerMissing"), 2);
            bl = true;
        }
        if (bl) {
            DialogDisplayer.getDefault().notify(message);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PUDataObject.this.goToXmlView();
                }
            });
        }
        return !bl;
    }

    public org.netbeans.modules.j2ee.persistence.dd.common.Persistence getPersistence() {
        if (this.persistence == null) {
            try {
                this.persistence = PersistenceMetadata.getDefault().getRoot(this.getPrimaryFile());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        assert (this.persistence != null);
        return this.persistence;
    }

    public void addPersistenceUnit(PersistenceUnit persistenceUnit) {
        ProviderUtil.makePortableIfPossible(FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile()), persistenceUnit);
        this.getPersistence().addPersistenceUnit(persistenceUnit);
        this.modelUpdated();
        this.firePropertyChange(PERSISTENCE_UNIT_ADDED_OR_REMOVED, false, true);
    }

    public void removePersistenceUnit(PersistenceUnit persistenceUnit) {
        this.getPersistence().removePersistenceUnit(persistenceUnit);
        this.modelUpdated();
        this.firePropertyChange(PERSISTENCE_UNIT_ADDED_OR_REMOVED, false, true);
    }

    public boolean addClass(PersistenceUnit persistenceUnit, String string, boolean bl) {
        String[] stringArray = persistenceUnit.getClass2();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return false;
        }
        persistenceUnit.addClass2(string);
        this.modelUpdated();
        if (!bl) {
            this.updateUIPanels(persistenceUnit, NO_UI_PU_CLASSES_CHANGED);
        }
        return true;
    }

    public void removeClass(PersistenceUnit persistenceUnit, String string, boolean bl) {
        persistenceUnit.removeClass2(string);
        this.modelUpdated();
        if (!bl) {
            this.updateUIPanels(persistenceUnit, NO_UI_PU_CLASSES_CHANGED);
        }
    }

    protected DesignMultiViewDesc[] getMultiViewDesc() {
        return new DesignMultiViewDesc[]{new DesignView(this, 0)};
    }

    public void showElement(Object object) {
        Object object2 = null;
        if (object instanceof PersistenceUnit) {
            this.openView(0);
            object2 = object;
        }
        if (object2 != null) {
            final Object object3 = object2;
            Utils.runInAwtDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    PUDataObject.this.getActiveMultiViewElement0().getSectionView().openPanel(object3);
                }
            });
        }
    }

    protected String getPrefixMark() {
        return null;
    }

    public ToolBarMultiViewElement getActiveMultiViewElement0() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    public void modelUpdated() {
        this.setModified(true);
        this.modelSynchronizer.requestUpdateData();
    }

    private void updateUIPanels(PersistenceUnit persistenceUnit, String string) {
        this.firePropertyChange(NO_UI_PU_CLASSES_CHANGED, null, persistenceUnit);
    }

    public void modelUpdatedFromUI() {
        this.modelSynchronizer.requestUpdateData();
    }

    public void updateDataFromModel(FileLock fileLock) throws IOException {
        this.modelSynchronizer.updateDataFromModel(this.getPersistence(), fileLock, true);
    }

    public boolean isDeleteAllowed() {
        return true;
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return true;
    }

    protected Image getXmlViewIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/persistence/unit/PersistenceIcon.gif");
    }

    private class ModelSynchronizer
    extends XmlMultiViewDataSynchronizer {
        public ModelSynchronizer(XmlMultiViewDataObject xmlMultiViewDataObject) {
            super(xmlMultiViewDataObject, 200);
        }

        protected boolean mayUpdateData(boolean bl) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateDataFromModel(Object object, FileLock fileLock, boolean bl) {
            if (object == null) {
                return;
            }
            try {
                StringWriter stringWriter = new StringWriter();
                ((BaseBean)object).write((Writer)stringWriter);
                ((Writer)stringWriter).close();
                PUDataObject.this.getDataCache().setData(fileLock, ((Object)stringWriter).toString(), bl);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, null, iOException);
            }
            catch (Schema2BeansException schema2BeansException) {
                LOG.log(Level.INFO, null, schema2BeansException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        protected Object getModel() {
            return PUDataObject.this.getPersistence();
        }

        protected void reloadModelFromData() {
            PUDataObject.this.parseDocument();
        }
    }

    private static class DesignView
    extends DesignMultiViewDesc {
        private static final long serialVersionUID = 1L;
        private int type;

        DesignView(PUDataObject pUDataObject, int n) {
            super((XmlMultiViewDataObject)pUDataObject, NbBundle.getMessage(PUDataObject.class, (String)"LBL_Design"));
            this.type = n;
        }

        public MultiViewElement createElement() {
            PUDataObject pUDataObject = (PUDataObject)this.getDataObject();
            return new PersistenceToolBarMVElement(pUDataObject);
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/persistence/unit/PersistenceIcon.gif");
        }

        public String preferredID() {
            return PUDataObject.DESIGN_VIEW_ID + String.valueOf(this.type);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(PUDataObject.HELP_ID_DESIGN_PERSISTENCE_UNIT);
        }
    }
}

