/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import com.sun.java.swing.plaf.windows.WindowsToggleButtonUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class UIUtils {
    private static final float ALTERNATE_ROW_DARKER_FACTOR = 0.96f;
    private static final float BRDER_LINE_DARKER_FACTOR = 0.65f;
    private static Color unfocusedSelBg;
    private static Color unfocusedSelFg;
    public static final Color TABLE_VERTICAL_GRID_COLOR;
    public static final Color TABLE_SELECTION_BACKGROUND_COLOR;
    public static final Color TABLE_SELECTION_FOREGROUND_COLOR;

    private UIUtils() {
    }

    static Color getProfilerResultsBackground() {
        return Color.WHITE;
    }

    public static Color getDarker(Color c) {
        if (c.equals(Color.WHITE)) {
            return new Color(244, 244, 244);
        }
        return UIUtils.getDarker(c, 0.96f);
    }

    public static Color getDarker(Color c, float ratio) {
        return UIUtils.getSafeColor((int)((float)c.getRed() * ratio), (int)((float)c.getGreen() * ratio), (int)((float)c.getBlue() * ratio));
    }

    public static Color getDarkerLine(Color c) {
        return UIUtils.getSafeColor((int)((float)c.getRed() * 0.65f), (int)((float)c.getGreen() * 0.65f), (int)((float)c.getBlue() * 0.65f));
    }

    public static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            if (!Color.WHITE.equals(unfocusedSelBg.brighter())) {
                unfocusedSelBg = unfocusedSelBg.brighter();
            }
        }
        return unfocusedSelBg;
    }

    public static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    public static Color getSafeColor(int red, int green, int blue) {
        red = Math.max(red, 0);
        red = Math.min(red, 255);
        green = Math.max(green, 0);
        green = Math.min(green, 255);
        blue = Math.max(blue, 0);
        blue = Math.min(blue, 255);
        return new Color(red, green, blue);
    }

    public static void runInEventDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void runInEventDispatchThreadAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void fixButtonUI(AbstractButton button) {
        if (button.getUI() instanceof WindowsButtonUI) {
            button.setUI((ButtonUI)new WindowsButtonUI(){

                protected BasicButtonListener createButtonListener(AbstractButton b) {
                    return new BasicButtonListener(b);
                }

                protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
                    int width = b.getWidth();
                    int height = b.getHeight();
                    g.setColor(this.getFocusColor());
                    BasicGraphicsUtils.drawDashedRect(g, this.dashedRectGapX, this.dashedRectGapY, width - this.dashedRectGapWidth, height - this.dashedRectGapHeight);
                }
            });
        } else if (button.getUI() instanceof WindowsToggleButtonUI) {
            button.setUI((ButtonUI)new WindowsToggleButtonUI(){

                protected BasicButtonListener createButtonListener(AbstractButton b) {
                    return new BasicButtonListener(b);
                }

                protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
                    int width = b.getWidth();
                    int height = b.getHeight();
                    g.setColor(this.getFocusColor());
                    BasicGraphicsUtils.drawDashedRect(g, this.dashedRectGapX, this.dashedRectGapY, width - this.dashedRectGapWidth, height - this.dashedRectGapHeight);
                }
            });
        }
    }

    public static boolean isGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("GTK");
    }

    public static boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Nimbus");
    }

    public static boolean isMotifLookAndFeel() {
        return UIManager.getLookAndFeel().getID().equals("Motif");
    }

    static {
        TABLE_VERTICAL_GRID_COLOR = new Color(214, 223, 247);
        TABLE_SELECTION_BACKGROUND_COLOR = new Color(193, 210, 238);
        TABLE_SELECTION_FOREGROUND_COLOR = Color.BLACK;
    }
}

