/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;

final class OnTimerRefreshVisualizerHandler
implements SessionStateListener,
DLightSessionListener {
    private final OnTimerTask task;
    private final long period;
    private final TimeUnit unit;
    private Future<?> scheduledTask;
    private DLightSession.SessionState currentSessionState = null;

    protected OnTimerRefreshVisualizerHandler(OnTimerTask task, long period, TimeUnit unit) {
        this.task = task;
        this.period = period;
        this.unit = unit;
        DLightManager mgr = DLightManager.getDefault();
        DLightSession activeSession = mgr.getActiveSession();
        mgr.addDLightSessionListener((DLightSessionListener)this);
        activeSession.addSessionStateListener((SessionStateListener)this);
        this.currentSessionState = activeSession.getState();
    }

    protected boolean isSessionRunning() {
        return this.currentSessionState == DLightSession.SessionState.RUNNING;
    }

    protected boolean isSessionPaused() {
        return this.currentSessionState == DLightSession.SessionState.PAUSED;
    }

    protected boolean isSessionAnalyzed() {
        return this.currentSessionState == DLightSession.SessionState.ANALYZE;
    }

    synchronized void startTimer() {
        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
            return;
        }
        this.scheduledTask = DLightExecutorService.scheduleAtFixedRate((Runnable)new Runnable(){

            @Override
            public void run() {
                OnTimerRefreshVisualizerHandler.this.task.onTimer();
            }
        }, (long)this.period, (TimeUnit)this.unit, (String)"OnTimerRefreshVisualizerHandler");
    }

    synchronized void stopTimer() {
        if (this.scheduledTask == null || this.scheduledTask.isDone()) {
            return;
        }
        this.scheduledTask.cancel(true);
        this.task.timerStopped();
    }

    public void sessionStateChanged(DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
        this.currentSessionState = newState;
        if (newState == DLightSession.SessionState.PAUSED || newState == DLightSession.SessionState.ANALYZE) {
            this.stopTimer();
            return;
        }
        if (newState == DLightSession.SessionState.STARTING || newState == DLightSession.SessionState.RUNNING) {
            this.startTimer();
            return;
        }
    }

    public void activeSessionChanged(DLightSession oldSession, DLightSession newSession) {
        if (oldSession != null) {
            oldSession.removeSessionStateListener((SessionStateListener)this);
            this.stopTimer();
        }
        if (newSession != null) {
            newSession.addSessionStateListener((SessionStateListener)this);
            this.sessionStateChanged(newSession, DLightSession.SessionState.CONFIGURATION, newSession.getState());
        }
    }

    public void sessionAdded(DLightSession newSession) {
    }

    public void sessionRemoved(DLightSession removedSession) {
        if (removedSession != null) {
            removedSession.removeSessionStateListener((SessionStateListener)this);
            this.stopTimer();
        }
    }
}

