/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.netbeans.modules.dlight.visualizers.TableSorter;

class MultiSortTableCellHeaderRenderer
extends DefaultTableCellRenderer {
    protected SortIcon sortIcon = new SortIcon(8);

    public MultiSortTableCellHeaderRenderer() {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(10);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader tableHeader = table.getTableHeader();
        Color fg = null;
        Color bg = null;
        Border border = null;
        Icon icon = null;
        if (hasFocus) {
            fg = UIManager.getColor("TableHeader.focusCellForeground");
            bg = UIManager.getColor("TableHeader.focusCellBackground");
            border = UIManager.getBorder("TableHeader.focusCellBorder");
        }
        if (fg == null) {
            fg = tableHeader.getForeground();
        }
        if (bg == null) {
            bg = tableHeader.getBackground();
        }
        if (border == null) {
            border = UIManager.getBorder("TableHeader.cellBorder");
        }
        icon = this.getSortIcon(table, table.convertColumnIndexToModel(column));
        this.setFont(tableHeader.getFont());
        this.setText(value != null && value != "" ? value.toString() : " ");
        this.setBorder(border);
        this.setIcon(icon);
        return this;
    }

    protected Icon getSortIcon(JTable table, int column) {
        if (!(table.getModel() instanceof TableSorter)) {
            return null;
        }
        TableSorter tableSorter = (TableSorter)table.getModel();
        List<Integer> columns = tableSorter.getSortingColumns();
        if (columns == null || columns.size() == 0) {
            return null;
        }
        int priority = 0;
        this.sortIcon.setPriority(priority);
        int index = columns.indexOf(column);
        if (index == -1) {
            return null;
        }
        this.sortIcon.setSortOrder(tableSorter.sortingColumnsOrder.get(index));
        return this.sortIcon;
    }

    static final class SortIcon
    implements Icon,
    SwingConstants {
        private static int NONE = 0;
        private int baseSize;
        private int size;
        private int direction = NONE;
        private BasicArrowButton iconRenderer;
        private double[] sizePercentages = new double[]{1.0, 0.85, 0.7, 0.55, 0.4, 0.25, 0.1};

        public SortIcon(int size) {
            this.baseSize = this.size = size;
            this.iconRenderer = new BasicArrowButton(this.direction);
        }

        public void setPriority(int priority) {
            this.size = (int)((double)this.baseSize * this.sizePercentages[priority]);
        }

        public void setSortOrder(boolean ascending) {
            this.direction = ascending ? 5 : 1;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.direction != NONE) {
                this.iconRenderer.paintTriangle(g, x, y, this.size, this.direction, true);
            }
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size / 2;
        }
    }
}

