/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.DependenciesProvider;
import org.netbeans.modules.javacard.project.deps.ResolvedDependencies;
import org.netbeans.modules.javacard.project.deps.ResolvedDependency;
import org.netbeans.modules.javacard.project.deps.ui.DependencyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class DependenciesChildren
extends ChildFactory.Detachable<DependencyDescriptor>
implements ChangeListener {
    private final JCProject project;
    private Cancellable c;
    private final Object LOCK = new Object();
    private final ResolvedDependencies resolvedDependencies;

    DependenciesChildren(JCProject project, ResolvedDependencies resolvedDependencies) {
        this.project = project;
        this.resolvedDependencies = resolvedDependencies;
    }

    DependenciesChildren(JCProject project) {
        this(project, null);
    }

    public static Children createChildren(JCProject project) {
        return Children.create((ChildFactory)new DependenciesChildren(project), (boolean)true);
    }

    public static Children createChildren(JCProject project, ResolvedDependencies rd) {
        return Children.create((ChildFactory)new DependenciesChildren(project, rd), (boolean)true);
    }

    public void update(boolean now) {
        this.refresh(now);
    }

    protected void addNotify() {
        super.addNotify();
        this.project.addDependencyChangeListener(this);
        if (this.resolvedDependencies != null) {
            this.resolvedDependencies.addChangeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        super.removeNotify();
        this.project.removeDependencyChangeListener(this);
        if (this.resolvedDependencies != null) {
            this.resolvedDependencies.removeChangeListener(this);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.c != null) {
                this.c.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolvedDependencies startRetrieval(DependenciesProvider p) {
        if (this.resolvedDependencies != null) {
            return this.resolvedDependencies;
        }
        assert (!EventQueue.isDispatchThread());
        if (p == null) {
            return null;
        }
        R fetcher = new R();
        Cancellable cancellable = p.requestDependencies(fetcher);
        if (!fetcher.done) {
            Object object = this.LOCK;
            synchronized (object) {
                this.c = cancellable;
            }
            while (!fetcher.done && cancellable != null) {
                if (Thread.interrupted()) {
                    return null;
                }
                object = cancellable;
                synchronized (object) {
                    try {
                        cancellable.wait();
                    }
                    catch (InterruptedException ex) {
                        return null;
                    }
                }
            }
        }
        return fetcher.resolvedDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createKeys(List<DependencyDescriptor> toPopulate) {
        DependenciesProvider prov = (DependenciesProvider)this.project.getLookup().lookup(DependenciesProvider.class);
        ResolvedDependencies resolved = this.startRetrieval(prov);
        if (resolved == null) {
            return true;
        }
        if (resolved != null) {
            for (ResolvedDependency resolvedDependency : resolved.all()) {
                toPopulate.add(this.createDescriptor(resolvedDependency));
            }
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.c = null;
        }
        return true;
    }

    protected Node createNodeForKey(DependencyDescriptor key) {
        return new DDNode(this.project, key, key.rd);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh(false);
    }

    private DependencyDescriptor createDescriptor(ResolvedDependency d) {
        String name;
        Image icon;
        String id;
        boolean valid;
        String path;
        block11: {
            block10: {
                File f;
                path = d.getPath(ArtifactKind.ORIGIN);
                valid = d.isValid();
                id = d.getDependency().getID();
                icon = null;
                name = d.getPath(ArtifactKind.ORIGIN);
                File file = f = name == null ? null : new File(name);
                if (f == null || !f.exists()) break block10;
                FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
                switch (d.getKind()) {
                    case CLASSIC_LIB: 
                    case EXTENSION_LIB: 
                    case JAVA_PROJECT: {
                        Project p = FileOwnerQuery.getOwner((FileObject)fo);
                        if (p != null) {
                            ProjectInformation info = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
                            if (info != null) {
                                icon = ImageUtilities.icon2Image((Icon)info.getIcon());
                                name = info.getDisplayName();
                                break;
                            }
                            name = p.getProjectDirectory().getPath();
                            break;
                        }
                        break block11;
                    }
                    case CLASSIC_LIB_JAR: 
                    case EXTENSION_LIB_JAR: 
                    case JAR_WITH_EXP_FILE: 
                    case RAW_JAR: {
                        try {
                            DataObject dob = DataObject.find((FileObject)fo);
                            Node n = dob.getNodeDelegate();
                            name = n.getDisplayName();
                            icon = n.getIcon(1);
                        }
                        catch (DataObjectNotFoundException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                break block11;
            }
            icon = null;
        }
        if (name == null) {
            name = "[unknown]";
        }
        DependencyDescriptor result = new DependencyDescriptor(icon, path, name, id, valid);
        if (this.resolvedDependencies != null) {
            result.rd = d;
        }
        return result;
    }

    private static class R
    implements DependenciesProvider.Receiver {
        private volatile ResolvedDependencies resolvedDependencies;
        volatile boolean done;

        private R() {
        }

        @Override
        public void receive(ResolvedDependencies deps) {
            this.resolvedDependencies = deps;
            this.done = true;
        }

        @Override
        public boolean failed(Throwable failure) {
            return true;
        }
    }

    private static final class DDNode
    extends AbstractNode
    implements Runnable {
        private volatile boolean removing;

        DDNode(JCProject project, DependencyDescriptor desc, ResolvedDependency rd) {
            super(Children.LEAF, rd == null ? Lookups.fixed((Object[])new Object[]{project, desc}) : Lookups.fixed((Object[])new Object[]{project, desc, rd}));
            this.setDisplayName(desc.getName());
            this.setShortDescription(desc.getPath());
        }

        public Image getIcon(int type) {
            boolean valid;
            ResolvedDependency rd = (ResolvedDependency)this.getLookup().lookup(ResolvedDependency.class);
            DependencyDescriptor d = (DependencyDescriptor)this.getLookup().lookup(DependencyDescriptor.class);
            Image result = d.getIcon();
            result = result == null ? super.getIcon(type) : result;
            boolean bl = valid = rd == null ? d.isValid() : rd.isValid();
            if (!valid) {
                Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/javacard/resources/brokenProjectBadge.png");
                result = ImageUtilities.mergeImages((Image)result, (Image)badge, (int)8, (int)8);
            }
            return result;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean ignored) {
            RA ra = new RA();
            ra.putValue("Name", NbBundle.getMessage(DDNode.class, (String)"ACTION_REMOVE_DEPENDENCY"));
            return new Action[]{ra};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                this.removing = true;
                try {
                    DependenciesProvider prov = (DependenciesProvider)((Project)this.getLookup().lookup(Project.class)).getLookup().lookup(DependenciesProvider.class);
                    if (prov == null) break block14;
                    ResolvedDependencies rd = null;
                    R r = new R();
                    Cancellable c = prov.requestDependencies(r);
                    while (!r.done) {
                        Cancellable cancellable = c;
                        synchronized (cancellable) {
                            try {
                                c.wait();
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    rd = r.resolvedDependencies;
                    if (rd != null) {
                        String id = ((DependencyDescriptor)this.getLookup().lookup(DependencyDescriptor.class)).getId();
                        ResolvedDependency toRemove = null;
                        for (ResolvedDependency resolvedDependency : rd.all()) {
                            if (!id.equals(resolvedDependency.getDependency().getID())) continue;
                            toRemove = resolvedDependency;
                            break;
                        }
                        if (toRemove != null) {
                            rd.remove(toRemove);
                            try {
                                rd.save();
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
                finally {
                    this.removing = false;
                }
            }
        }

        private void remove() {
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RA.class, (String)"MSG_REMOVING_DEPENDENCY", (Object)((DependencyDescriptor)this.getLookup().lookup(DependencyDescriptor.class)).getName()));
            GuiUtils.showProgressDialogAndRun((ProgressHandle)handle, (Runnable)this, (boolean)false);
        }

        private class RA
        extends AbstractAction {
            private RA() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                DDNode.this.remove();
            }

            @Override
            public boolean isEnabled() {
                return !DDNode.this.removing;
            }
        }
    }
}

