/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADConnectionPropertyEditor;

public final class FormPropertyEditorManager {
    private static Map<Class, Class>[] editorClassCache;
    private static Map<Class, List<Class>> expliciteEditors;
    private static Logger logger;

    public static synchronized PropertyEditor findEditor(FormProperty property) {
        FormModel form;
        Class type = property.getValueType();
        List<PropertyEditor> list = FormPropertyEditorManager.findEditors(type, form = property.getPropertyContext().getFormModel(), false);
        return list.isEmpty() ? null : list.get(0);
    }

    public static synchronized PropertyEditor[] getAllEditors(FormProperty property) {
        Class type = property.getValueType();
        FormModel form = property.getPropertyContext().getFormModel();
        List<PropertyEditor> list = FormPropertyEditorManager.findEditors(type, form, true);
        return list.toArray(new PropertyEditor[list.size()]);
    }

    public static synchronized void registerEditor(Class propertyType, Class editorClass) {
        List<Class> classList;
        if (expliciteEditors != null) {
            classList = expliciteEditors.get(propertyType);
        } else {
            classList = null;
            expliciteEditors = new HashMap<Class, List<Class>>();
        }
        if (classList == null) {
            classList = new LinkedList<Class>();
            classList.add(editorClass);
            expliciteEditors.put(propertyType, classList);
        } else if (!classList.contains(editorClass)) {
            classList.add(editorClass);
        }
    }

    private static List<Class> getRegisteredEditorClasses(Class propertyType) {
        List classList = expliciteEditors != null ? expliciteEditors.get(propertyType) : null;
        return classList != null ? classList : Collections.EMPTY_LIST;
    }

    private static List<PropertyEditor> findEditors(Class type, FormModel targetForm, boolean all) {
        ArrayList<PropertyEditor> editorList = new ArrayList<PropertyEditor>(5);
        if (FormPropertyEditorManager.isEditorInCache(type, 0)) {
            FormPropertyEditorManager.createEditorFromCache(type, 0, editorList);
        } else {
            PropertyEditor editor;
            PropertyEditor propertyEditor = editor = type != Object.class && !FormPropertyEditorManager.hasWrappingEditor(type) ? PropertyEditorManager.findEditor(type) : null;
            if (editor != null) {
                editorList.add(editor);
            }
            FormPropertyEditorManager.addEditorToCache(type, editor, 0);
        }
        if (!all && !editorList.isEmpty()) {
            return editorList;
        }
        if (FormPropertyEditorManager.isEditorInCache(type, 1)) {
            FormPropertyEditorManager.createEditorFromCache(type, 1, editorList);
        } else {
            String typeName = type.getSimpleName();
            if (!typeName.contains("[")) {
                Class editorClass = null;
                for (String path : FormLoaderSettings.getInstance().getEditorSearchPath()) {
                    String name = path + "." + typeName + "Editor";
                    try {
                        editorClass = FormUtils.loadClass(name, targetForm);
                        if (FormPropertyEditorManager.createEditorInstance(editorClass, editorList)) break;
                        editorClass = null;
                    }
                    catch (Exception e) {
                    }
                    catch (LinkageError e) {
                        // empty catch block
                    }
                }
                FormPropertyEditorManager.addEditorClassToCache(type, editorClass, 1);
            }
        }
        if (!all && !editorList.isEmpty()) {
            return editorList;
        }
        for (Class cls : FormPropertyEditorManager.getRegisteredEditorClasses(type)) {
            FormPropertyEditorManager.createEditorInstance(cls, editorList);
            if (all) continue;
            return editorList;
        }
        if (editorList.isEmpty() && FormPropertyEditorManager.isComponentType(type)) {
            editorList.add(new ComponentChooserEditor(new Class[]{type}));
            if (!all) {
                return editorList;
            }
        }
        editorList.add(new RADConnectionPropertyEditor(type, RADConnectionPropertyEditor.Type.FormConnection));
        editorList.add(new RADConnectionPropertyEditor(type, RADConnectionPropertyEditor.Type.CustomCode));
        return editorList;
    }

    private static boolean isEditorInCache(Class propertyType, int level) {
        return FormPropertyEditorManager.getEditorClassCache(level).containsKey(propertyType);
    }

    private static void createEditorFromCache(Class propertyType, int level, List<PropertyEditor> list) {
        Class editorClass = FormPropertyEditorManager.getEditorClassCache(level).get(propertyType);
        if (editorClass != null) {
            FormPropertyEditorManager.createEditorInstance(editorClass, list);
        }
    }

    private static void addEditorToCache(Class propertyType, PropertyEditor editor, int level) {
        if (editor == null) {
            FormPropertyEditorManager.addEditorClassToCache(propertyType, null, level);
        } else {
            Class<?> editorClass = editor.getClass();
            try {
                Constructor<?> ctor = editorClass.getConstructor(new Class[0]);
                if (ctor != null && (ctor.getModifiers() & 1) == 1) {
                    FormPropertyEditorManager.addEditorClassToCache(propertyType, editorClass, level);
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
    }

    private static void addEditorClassToCache(Class propertyType, Class editorClass, int level) {
        FormPropertyEditorManager.getEditorClassCache(level).put(propertyType, editorClass);
    }

    private static Map<Class, Class> getEditorClassCache(int level) {
        if (editorClassCache == null) {
            editorClassCache = new Map[]{new WeakHashMap(), new WeakHashMap()};
        }
        return editorClassCache[level];
    }

    private static boolean hasWrappingEditor(Class type) {
        return type == String.class || type == Font.class || type == Color.class || type == Icon.class;
    }

    private static boolean isComponentType(Class type) {
        return !type.equals(Object.class) && !type.equals(String.class) && !type.isEnum() && !type.isPrimitive() && !Number.class.isAssignableFrom(type);
    }

    private static boolean createEditorInstance(Class cls, List<PropertyEditor> list) {
        try {
            list.add((PropertyEditor)cls.newInstance());
            return true;
        }
        catch (Exception ex) {
            FormPropertyEditorManager.log(ex, "Error instantiating property editor: " + cls.getName());
        }
        catch (LinkageError ex) {
            FormPropertyEditorManager.log(ex, "Error instantiating property editor: " + cls.getName());
        }
        return false;
    }

    private static void log(Throwable ex, String msg) {
        if (logger == null) {
            logger = Logger.getLogger(FormPropertyEditorManager.class.getName());
        }
        logger.log(Level.INFO, msg, ex);
    }
}

