/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.project;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.project.ForumsAndMailingListsPanel;
import org.netbeans.modules.kenai.ui.project.IssuesInformationPanel;
import org.netbeans.modules.kenai.ui.project.RefreshableContentPanel;
import org.netbeans.modules.kenai.ui.project.SourcesInformationPanel;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public final class kenaiProjectTopComponent
extends TopComponent
implements PropertyChangeListener {
    private final RequestProcessor SingleDataRequestProcessor = new RequestProcessor("KENAI_SINGLE_DATA_REQUEST_PROCESSOR", 1, true);
    private final RequestProcessor SingleImageRequestProcessor = new RequestProcessor("KENAI_SINGLE_IMG_REQUEST_PROCESSOR", 1, true);
    private final ImageIcon loadingIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/wait.gif", (boolean)true);
    private RequestProcessor.Task loadingImageTask = null;
    private RequestProcessor.Task loadingDynamicContentTask = null;
    public static final String linkImageHTML = String.format("<img src=\"%s\" style=\"padding-right: 3px;\">", kenaiProjectTopComponent.class.getResource("/org/netbeans/modules/kenai/ui/resources/insertlink-bottom.png"));
    private static final String ICON_PATH = "org/netbeans/modules/kenai/ui/resources/kenai-small.png";
    private static final String PREFERRED_ID = "kenaiProjectTopComponent";
    private static kenaiProjectTopComponent inst = null;
    private KenaiProject instProj = null;
    private URLListener wwwActionListener;
    private URLListener wikiActionListener;
    private URLListener downloadsActionListener;
    private JButton backToTopLabel;
    private JPanel bottomLinkPanel;
    private JPanel containingPanel;
    private JButton downloadsLabel;
    private JTabbedPane dynamicContentPane;
    private JPanel dynamicContentsPanel;
    private JPanel generalDetailsPanel;
    private JPanel imagePanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane mainScrollPane;
    private JPanel projectDescription;
    private JLabel projectImage;
    private JLabel projectsDetailsHeader;
    private JTextArea projectsDetailsText;
    private JPanel webLinks;
    private JButton wikiLabel;
    private JButton wwwLabel;

    public kenaiProjectTopComponent() {
        this.initComponents();
    }

    public kenaiProjectTopComponent(KenaiProject proj) {
        this.initComponents();
        this.setName(proj.getDisplayName());
        this.setToolTipText(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"HINT_kenaiProjectTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.instProj = proj;
        this.addSpecificContent();
        proj.getKenai().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)proj.getKenai()));
        this.mainScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.mainScrollPane.getHorizontalScrollBar().setUnitIncrement(30);
        this.backToTopLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.backToTopLabel.setBorder(new DottedBorder());
        this.wwwLabel.setBorder(new DottedBorder());
        this.wikiLabel.setBorder(new DottedBorder());
        this.downloadsLabel.setBorder(new DottedBorder());
    }

    public static synchronized kenaiProjectTopComponent getDefault() {
        if (inst == null) {
            inst = new kenaiProjectTopComponent();
        }
        return inst;
    }

    private void initComponents() {
        this.mainScrollPane = new JScrollPane();
        this.containingPanel = new JPanel();
        this.generalDetailsPanel = new JPanel();
        this.projectDescription = new JPanel();
        this.webLinks = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.wwwLabel = new JButton();
        this.wikiLabel = new JButton();
        this.downloadsLabel = new JButton();
        this.jPanel1 = new JPanel();
        this.projectsDetailsHeader = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.projectsDetailsText = new JTextArea();
        this.imagePanel = new JPanel();
        this.projectImage = new JLabel();
        this.dynamicContentsPanel = new JPanel();
        this.dynamicContentPane = new JTabbedPane();
        this.bottomLinkPanel = new JPanel();
        this.backToTopLabel = new JButton();
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.mainScrollPane.setAlignmentY(0.0f);
        this.containingPanel.setBackground(new Color(255, 255, 255));
        this.containingPanel.setMinimumSize(new Dimension(600, 405));
        this.containingPanel.setNextFocusableComponent(this.projectsDetailsHeader);
        this.generalDetailsPanel.setBackground(SystemColor.control);
        this.generalDetailsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.generalDetailsPanel.setMaximumSize(new Dimension(20800, 200));
        this.generalDetailsPanel.setMinimumSize(new Dimension(600, 200));
        this.generalDetailsPanel.setPreferredSize(new Dimension(600, 200));
        this.generalDetailsPanel.setLayout(new BorderLayout());
        this.projectDescription.setBackground(SystemColor.control);
        this.projectDescription.setOpaque(false);
        this.projectDescription.setLayout(new BorderLayout());
        this.webLinks.setOpaque(false);
        this.webLinks.setPreferredSize(new Dimension(10, 70));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.jLabel3.text"));
        this.wwwLabel.setBackground(new Color(229, 229, 229));
        Mnemonics.setLocalizedText((AbstractButton)this.wwwLabel, (String)NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.wwwLabel.text"));
        this.wwwLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.wwwLabel.setBorderPainted(false);
        this.wwwLabel.setContentAreaFilled(false);
        this.wwwLabel.setFocusPainted(false);
        this.wwwLabel.setHorizontalAlignment(2);
        this.wwwLabel.setNextFocusableComponent(this.wikiLabel);
        this.wwwLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                kenaiProjectTopComponent.this.wwwLabelFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                kenaiProjectTopComponent.this.wwwLabelFocusLost(evt);
            }
        });
        this.wikiLabel.setBackground(new Color(229, 229, 229));
        Mnemonics.setLocalizedText((AbstractButton)this.wikiLabel, (String)NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.wikiLabel.text"));
        this.wikiLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.wikiLabel.setBorderPainted(false);
        this.wikiLabel.setContentAreaFilled(false);
        this.wikiLabel.setFocusPainted(false);
        this.wikiLabel.setHorizontalAlignment(2);
        this.wikiLabel.setNextFocusableComponent(this.downloadsLabel);
        this.wikiLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                kenaiProjectTopComponent.this.wikiLabelFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                kenaiProjectTopComponent.this.wikiLabelFocusLost(evt);
            }
        });
        this.downloadsLabel.setBackground(new Color(229, 229, 229));
        Mnemonics.setLocalizedText((AbstractButton)this.downloadsLabel, (String)NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.downloadsLabel.text"));
        this.downloadsLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.downloadsLabel.setBorderPainted(false);
        this.downloadsLabel.setContentAreaFilled(false);
        this.downloadsLabel.setFocusPainted(false);
        this.downloadsLabel.setHorizontalAlignment(2);
        this.downloadsLabel.setNextFocusableComponent(this.dynamicContentPane);
        this.downloadsLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                kenaiProjectTopComponent.this.downloadsLabelFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                kenaiProjectTopComponent.this.downloadsLabelFocusLost(evt);
            }
        });
        GroupLayout webLinksLayout = new GroupLayout((Container)this.webLinks);
        this.webLinks.setLayout((LayoutManager)webLinksLayout);
        webLinksLayout.setHorizontalGroup((GroupLayout.Group)webLinksLayout.createParallelGroup(1).add((GroupLayout.Group)webLinksLayout.createSequentialGroup().add((GroupLayout.Group)webLinksLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)webLinksLayout.createParallelGroup(1).add((Component)this.wikiLabel).add((Component)this.wwwLabel).add((Component)this.downloadsLabel)).addContainerGap(354, Short.MAX_VALUE)));
        webLinksLayout.linkSize(new Component[]{this.jLabel1, this.jLabel2, this.jLabel3}, 1);
        webLinksLayout.setVerticalGroup((GroupLayout.Group)webLinksLayout.createParallelGroup(1).add((GroupLayout.Group)webLinksLayout.createSequentialGroup().add(1, 1, 1).add((GroupLayout.Group)webLinksLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.wwwLabel, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)webLinksLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.wikiLabel, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)webLinksLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.downloadsLabel, -2, 16, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        webLinksLayout.linkSize(new Component[]{this.downloadsLabel, this.jLabel1, this.jLabel2, this.jLabel3, this.wikiLabel, this.wwwLabel}, 2);
        this.wwwLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.wwwLabel.AccessibleContext.accessibleName"));
        this.wwwLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.wwwLabel.AccessibleContext.accessibleDescription"));
        this.wikiLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.wikiLabel.AccessibleContext.accessibleName"));
        this.wikiLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.wikiLabel.AccessibleContext.accessibleDescription"));
        this.downloadsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.downloadsLabel.AccessibleContext.accessibleName"));
        this.downloadsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.downloadsLabel.AccessibleContext.accessibleDescription"));
        this.projectDescription.add((Component)this.webLinks, "Last");
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(25, 126));
        this.projectsDetailsHeader.setBackground(SystemColor.control);
        this.projectsDetailsHeader.setFont(new Font("Dialog", 1, 18));
        this.projectsDetailsHeader.setForeground(new Color(45, 72, 102));
        Mnemonics.setLocalizedText((JLabel)this.projectsDetailsHeader, (String)NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.projectsDetailsHeader.text"));
        this.projectsDetailsHeader.setNextFocusableComponent(this.projectsDetailsText);
        this.projectsDetailsHeader.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                kenaiProjectTopComponent.this.projectsDetailsHeaderFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                kenaiProjectTopComponent.this.projectsDetailsHeaderFocusLost(evt);
            }
        });
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setViewportBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setOpaque(false);
        this.projectsDetailsText.setBackground(SystemColor.control);
        this.projectsDetailsText.setColumns(20);
        this.projectsDetailsText.setEditable(false);
        this.projectsDetailsText.setLineWrap(true);
        this.projectsDetailsText.setRows(3);
        this.projectsDetailsText.setWrapStyleWord(true);
        this.projectsDetailsText.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.projectsDetailsText.setMargin(new Insets(0, 0, 0, 10));
        this.projectsDetailsText.setNextFocusableComponent(this.wwwLabel);
        this.projectsDetailsText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                kenaiProjectTopComponent.this.projectsDetailsTextFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                kenaiProjectTopComponent.this.projectsDetailsTextFocusLost(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.projectsDetailsText);
        this.projectsDetailsText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.projectsDetailsText.AccessibleContext.accessibleName"));
        this.projectsDetailsText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.projectsDetailsText.AccessibleContext.accessibleDescription"));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.projectsDetailsHeader).add((Component)this.jScrollPane1, -1, 520, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.projectsDetailsHeader).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 85, Short.MAX_VALUE)));
        this.projectsDetailsHeader.getAccessibleContext().setAccessibleName(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.projectsDetailsHeader.AccessibleContext.accessibleName"));
        this.projectsDetailsHeader.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.projectsDetailsHeader.AccessibleContext.accessibleDescription"));
        this.projectDescription.add((Component)this.jPanel1, "Center");
        this.generalDetailsPanel.add((Component)this.projectDescription, "Center");
        this.imagePanel.setBackground(SystemColor.control);
        this.imagePanel.setOpaque(false);
        this.imagePanel.setPreferredSize(new Dimension(200, 200));
        this.projectImage.setBackground(new Color(255, 255, 255));
        this.projectImage.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.projectImage, (String)NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.projectImage.text"));
        this.projectImage.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.projectImage.setHorizontalTextPosition(0);
        this.projectImage.setIconTextGap(0);
        this.projectImage.setOpaque(true);
        GroupLayout imagePanelLayout = new GroupLayout((Container)this.imagePanel);
        this.imagePanel.setLayout((LayoutManager)imagePanelLayout);
        imagePanelLayout.setHorizontalGroup((GroupLayout.Group)imagePanelLayout.createParallelGroup(1).add((GroupLayout.Group)imagePanelLayout.createSequentialGroup().addContainerGap().add((Component)this.projectImage, -1, 176, Short.MAX_VALUE).addContainerGap()));
        imagePanelLayout.setVerticalGroup((GroupLayout.Group)imagePanelLayout.createParallelGroup(1).add((GroupLayout.Group)imagePanelLayout.createSequentialGroup().addContainerGap().add((Component)this.projectImage, -1, 172, Short.MAX_VALUE).addContainerGap()));
        this.generalDetailsPanel.add((Component)this.imagePanel, "West");
        this.dynamicContentsPanel.setOpaque(false);
        this.dynamicContentsPanel.setRequestFocusEnabled(false);
        this.dynamicContentsPanel.setLayout(new BorderLayout());
        this.dynamicContentPane.setNextFocusableComponent(this.backToTopLabel);
        this.dynamicContentsPanel.add((Component)this.dynamicContentPane, "Center");
        this.dynamicContentPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.dynamicContentPane.AccessibleContext.accessibleName"));
        this.dynamicContentPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.dynamicContentPane.AccessibleContext.accessibleDescription"));
        GroupLayout containingPanelLayout = new GroupLayout((Container)this.containingPanel);
        this.containingPanel.setLayout((LayoutManager)containingPanelLayout);
        containingPanelLayout.setHorizontalGroup((GroupLayout.Group)containingPanelLayout.createParallelGroup(1).add((GroupLayout.Group)containingPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)containingPanelLayout.createParallelGroup(1).add((Component)this.dynamicContentsPanel, -1, 736, Short.MAX_VALUE).add((Component)this.generalDetailsPanel, -1, 736, Short.MAX_VALUE)).addContainerGap()));
        containingPanelLayout.setVerticalGroup((GroupLayout.Group)containingPanelLayout.createParallelGroup(1).add((GroupLayout.Group)containingPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.generalDetailsPanel, -2, -1, -2).addPreferredGap(1).add((Component)this.dynamicContentsPanel, -1, 325, Short.MAX_VALUE).add(46, 46, 46)));
        this.mainScrollPane.setViewportView(this.containingPanel);
        this.containingPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.containingPanel.AccessibleContext.accessibleName"));
        this.containingPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.containingPanel.AccessibleContext.accessibleDescription"));
        this.add(this.mainScrollPane, "Center");
        this.bottomLinkPanel.setBackground(SystemColor.control);
        this.bottomLinkPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bottomLinkPanel.setPreferredSize(new Dimension(81, 22));
        this.bottomLinkPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.backToTopLabel, (String)NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.backToTopLabel.text"));
        this.backToTopLabel.setBorderPainted(false);
        this.backToTopLabel.setContentAreaFilled(false);
        this.backToTopLabel.setHorizontalAlignment(4);
        this.backToTopLabel.setMargin(new Insets(0, 10, 0, 10));
        this.backToTopLabel.setNextFocusableComponent(this.projectsDetailsHeader);
        this.backToTopLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                kenaiProjectTopComponent.this.backToTopLabelActionPerformed(evt);
            }
        });
        this.backToTopLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                kenaiProjectTopComponent.this.backToTopLabelFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                kenaiProjectTopComponent.this.backToTopLabelFocusLost(evt);
            }
        });
        this.bottomLinkPanel.add((Component)this.backToTopLabel, "East");
        this.add(this.bottomLinkPanel, "South");
    }

    private void projectsDetailsTextFocusGained(FocusEvent evt) {
        this.projectsDetailsText.getCaret().setVisible(false);
        this.projectsDetailsText.setBorder(new DottedBorder());
    }

    private void wwwLabelFocusGained(FocusEvent evt) {
        this.wwwLabel.setBorderPainted(true);
    }

    private void wwwLabelFocusLost(FocusEvent evt) {
        this.wwwLabel.setBorderPainted(false);
    }

    private void wikiLabelFocusGained(FocusEvent evt) {
        this.wikiLabel.setBorderPainted(true);
    }

    private void wikiLabelFocusLost(FocusEvent evt) {
        this.wikiLabel.setBorderPainted(false);
    }

    private void downloadsLabelFocusGained(FocusEvent evt) {
        this.downloadsLabel.setBorderPainted(true);
    }

    private void downloadsLabelFocusLost(FocusEvent evt) {
        this.downloadsLabel.setBorderPainted(false);
    }

    private void backToTopLabelFocusGained(FocusEvent evt) {
        this.backToTopLabel.setBorderPainted(true);
    }

    private void backToTopLabelFocusLost(FocusEvent evt) {
        this.backToTopLabel.setBorderPainted(false);
    }

    private void backToTopLabelActionPerformed(ActionEvent evt) {
        this.mainScrollPane.getVerticalScrollBar().setValue(0);
    }

    private void projectsDetailsTextFocusLost(FocusEvent evt) {
        this.projectsDetailsText.setBorder(null);
    }

    private void projectsDetailsHeaderFocusGained(FocusEvent evt) {
        this.projectsDetailsHeader.setBorder(new DottedBorder());
    }

    private void projectsDetailsHeaderFocusLost(FocusEvent evt) {
        this.projectsDetailsHeader.setBorder(null);
    }

    public static synchronized kenaiProjectTopComponent getInstance(KenaiProject forProject) {
        if (inst == null) {
            inst = new kenaiProjectTopComponent(forProject);
        }
        inst.reinitialize(forProject, true);
        inst.setName(forProject.getDisplayName());
        return inst;
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    Object readProperties(Properties p) {
        return null;
    }

    void writeProperties(Properties p) {
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void reinitialize(final KenaiProject proj, boolean hardReinit) {
        this.instProj = proj;
        final String KENAI_URL = this.instProj.getKenai().getUrl().toString();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                kenaiProjectTopComponent.this.projectImage.setIcon(kenaiProjectTopComponent.this.loadingIcon);
                kenaiProjectTopComponent.this.projectsDetailsHeader.setText(proj.getDisplayName());
                try {
                    kenaiProjectTopComponent.this.projectsDetailsText.setText(proj.getDescription().replaceAll("\r?\n", " ").replaceAll("\r", " "));
                    kenaiProjectTopComponent.this.projectsDetailsText.setCaretPosition(0);
                }
                catch (KenaiException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        if (this.loadingImageTask != null && !this.loadingImageTask.isFinished()) {
            this.loadingImageTask.cancel();
        }
        this.loadingImageTask = this.SingleImageRequestProcessor.post(new Runnable(){

            @Override
            public void run() {
                try {
                    final Icon projectIcon = proj.getProjectIcon();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            kenaiProjectTopComponent.this.projectImage.setIcon(projectIcon);
                        }
                    });
                }
                catch (KenaiException ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            kenaiProjectTopComponent.this.projectImage.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/default.jpg", (boolean)true));
                        }
                    });
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                kenaiProjectTopComponent.this.wwwLabel.setText(String.format("<html><a href=\"blank\">%s</a></html>", KENAI_URL + proj.getWebLocation().getPath()));
                kenaiProjectTopComponent.this.wwwLabel.setIcon(ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/kenai/ui/resources/insertlink.png", (boolean)false));
                kenaiProjectTopComponent.this.wwwLabel.setToolTipText(KENAI_URL + proj.getWebLocation().getPath());
                kenaiProjectTopComponent.this.wwwLabel.setCursor(new Cursor(12));
                kenaiProjectTopComponent.this.wwwLabel.removeActionListener(kenaiProjectTopComponent.this.wwwActionListener);
                kenaiProjectTopComponent.this.wwwActionListener = new URLListener(proj.getWebLocation());
                kenaiProjectTopComponent.this.wwwLabel.addActionListener(kenaiProjectTopComponent.this.wwwActionListener);
            }
        });
        KenaiFeature[] _wiki = null;
        KenaiFeature[] _down = null;
        try {
            _wiki = proj.getFeatures(KenaiService.Type.WIKI);
            _down = proj.getFeatures(KenaiService.Type.DOWNLOADS);
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (_down != null && _down.length > 0) {
            final KenaiFeature down = _down[0];
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    kenaiProjectTopComponent.this.downloadsLabel.setText(String.format("<html><a href=\"blank\">%s</a></html>", KENAI_URL + down.getWebLocation().getPath()));
                    kenaiProjectTopComponent.this.downloadsLabel.setIcon(ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/kenai/ui/resources/insertlink.png", (boolean)false));
                    kenaiProjectTopComponent.this.downloadsLabel.setToolTipText(KENAI_URL + down.getWebLocation().getPath());
                    kenaiProjectTopComponent.this.downloadsLabel.setCursor(new Cursor(12));
                    kenaiProjectTopComponent.this.downloadsLabel.removeActionListener(kenaiProjectTopComponent.this.downloadsActionListener);
                    kenaiProjectTopComponent.this.downloadsActionListener = new URLListener(down.getWebLocation());
                    kenaiProjectTopComponent.this.downloadsLabel.addActionListener(kenaiProjectTopComponent.this.downloadsActionListener);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    kenaiProjectTopComponent.this.downloadsLabel.setText(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.downloadsLabel.text"));
                    kenaiProjectTopComponent.this.downloadsLabel.setIcon(null);
                    kenaiProjectTopComponent.this.downloadsLabel.setToolTipText("");
                    kenaiProjectTopComponent.this.downloadsLabel.setCursor(Cursor.getDefaultCursor());
                    kenaiProjectTopComponent.this.downloadsLabel.removeActionListener(kenaiProjectTopComponent.this.downloadsActionListener);
                }
            });
        }
        if (_wiki != null && _wiki.length > 0) {
            final KenaiFeature wiki = _wiki[0];
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    kenaiProjectTopComponent.this.wikiLabel.setText(String.format("<html><a href=\"blank\">%s</a></html>", KENAI_URL + wiki.getWebLocation().getPath()));
                    kenaiProjectTopComponent.this.wikiLabel.setIcon(ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/kenai/ui/resources/insertlink.png", (boolean)false));
                    kenaiProjectTopComponent.this.wikiLabel.setToolTipText(KENAI_URL + wiki.getWebLocation().getPath());
                    kenaiProjectTopComponent.this.wikiLabel.setCursor(new Cursor(12));
                    kenaiProjectTopComponent.this.wikiLabel.removeActionListener(kenaiProjectTopComponent.this.wikiActionListener);
                    kenaiProjectTopComponent.this.wikiActionListener = new URLListener(wiki.getWebLocation());
                    kenaiProjectTopComponent.this.wikiLabel.addActionListener(kenaiProjectTopComponent.this.wikiActionListener);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    kenaiProjectTopComponent.this.wikiLabel.setText(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"kenaiProjectTopComponent.wikiLabel.text"));
                    kenaiProjectTopComponent.this.wikiLabel.setIcon(null);
                    kenaiProjectTopComponent.this.wikiLabel.setToolTipText("");
                    kenaiProjectTopComponent.this.wikiLabel.setCursor(Cursor.getDefaultCursor());
                    kenaiProjectTopComponent.this.wikiLabel.removeActionListener(kenaiProjectTopComponent.this.wikiActionListener);
                }
            });
        }
        if (hardReinit) {
            if (this.loadingDynamicContentTask != null && !this.loadingDynamicContentTask.isFinished()) {
                this.loadingDynamicContentTask.cancel();
                int tabCount = this.dynamicContentPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    if (!(this.dynamicContentPane.getComponentAt(i) instanceof RefreshableContentPanel)) continue;
                    ((RefreshableContentPanel)((Object)this.dynamicContentPane.getComponentAt(i))).clearContent();
                }
            }
            this.loadingDynamicContentTask = this.SingleDataRequestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    int i;
                    int tabCount = kenaiProjectTopComponent.this.dynamicContentPane.getTabCount();
                    for (i = 0; i < tabCount; ++i) {
                        if (!(kenaiProjectTopComponent.this.dynamicContentPane.getComponentAt(i) instanceof RefreshableContentPanel)) continue;
                        ((RefreshableContentPanel)((Object)kenaiProjectTopComponent.this.dynamicContentPane.getComponentAt(i))).clearContent();
                    }
                    for (i = 0; i < tabCount; ++i) {
                        if (!(kenaiProjectTopComponent.this.dynamicContentPane.getComponentAt(i) instanceof RefreshableContentPanel)) continue;
                        if (Thread.interrupted()) break;
                        ((RefreshableContentPanel)((Object)kenaiProjectTopComponent.this.dynamicContentPane.getComponentAt(i))).resetContent(kenaiProjectTopComponent.this.instProj);
                    }
                }
            });
        }
    }

    private void addSpecificContent() {
        this.dynamicContentPane.add(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"MSG_COMMUNICATE"), new ForumsAndMailingListsPanel());
        this.dynamicContentPane.add(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"MSG_TEST"), new IssuesInformationPanel(this.instProj));
        this.dynamicContentPane.add(NbBundle.getMessage(kenaiProjectTopComponent.class, (String)"MSG_DEVELOP"), new SourcesInformationPanel(this.mainScrollPane.getVerticalScrollBar()));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("login")) {
            this.reinitialize(this.instProj, true);
        } else if ("url".equals(evt.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    kenaiProjectTopComponent.this.close();
                }
            });
        }
    }

    private class URLListener
    implements ActionListener {
        private URL url = null;

        public URLListener(URL u) {
            this.url = u;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.url);
        }
    }

    private class DottedBorder
    implements Border {
        private DottedBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int py;
            int px;
            g.setColor(ColorManager.getDefault().getDisabledColor());
            int w = width - 1;
            int h = height - 1;
            for (px = 0; px < w - 1; px += 2) {
                g.drawLine(x + px, y, x + px, y);
            }
            for (py = 0; py < h; py += 2) {
                g.drawLine(x + w, y + py, x + w, y + py);
            }
            for (px = 0; px < w; px += 2) {
                g.drawLine(x + w - px, y + h, x + w - px, y + h);
            }
            for (py = 0; py < h; py += 2) {
                g.drawLine(x, y + h - py, x, y + h - py);
            }
        }

        @Override
        public Insets getBorderInsets(Component arg0) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

