/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.api.NbModuleOwnerSupport;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class KenaiPopupMenu
extends AbstractAction
implements ContextAwareAction {
    private static Map<Project, String> repoForProjCache = new WeakHashMap<Project, String>();
    private static KenaiPopupMenu inst = null;

    private KenaiPopupMenu() {
        this.putValue("Name", NbBundle.getMessage(KenaiPopupMenu.class, (String)"KENAI_POPUP"));
    }

    public static synchronized KenaiPopupMenu getDefault() {
        if (inst == null) {
            inst = new KenaiPopupMenu();
        }
        return inst;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new KenaiPopupMenuPresenter(actionContext);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    private KenaiProject getActualKenaiProject(Project p, String kenaiProjectName) throws KenaiException {
        KenaiProject defaultKenaiProject = KenaiProject.forRepository((String)repoForProjCache.get(p));
        Kenai kenai = defaultKenaiProject != null ? defaultKenaiProject.getKenai() : Utilities.getPreferredKenai();
        KenaiProject kp = kenai == null ? null : kenai.getProject(kenaiProjectName);
        return kp;
    }

    private String getKenaiProjectName(Project proj) {
        String kpName = null;
        NbModuleOwnerSupport.OwnerInfo ownerInfo = NbModuleOwnerSupport.getInstance().getOwnerInfo(proj);
        if (ownerInfo != null) {
            try {
                KenaiProject kp = this.getActualKenaiProject(proj, ownerInfo.getOwner());
                if (kp != null) {
                    kpName = kp.getName();
                }
            }
            catch (KenaiException ex) {
                String err = ex.getLocalizedMessage();
                if (err == null) {
                    err = ex.getCause().getLocalizedMessage();
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_CONNECTION", (Object)err)));
            }
        }
        if (kpName == null) {
            String projRepo = repoForProjCache.get(proj);
            kpName = KenaiProject.getNameForRepository((String)projRepo);
        }
        return kpName;
    }

    class LazyOpenKenaiProjectAction
    extends JMenuItem {
        public LazyOpenKenaiProjectAction(final Project proj) {
            super(NbBundle.getMessage(KenaiPopupMenu.class, (String)"OPEN_CORRESPONDING_KENAI_PROJ"));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KenaiTopComponent.findInstance().open();
                            KenaiTopComponent.findInstance().requestActive();
                        }
                    });
                    RequestProcessor.getDefault().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block7: {
                                ProgressHandle handle = null;
                                try {
                                    handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiPopupMenu.class, (String)"CTL_OpenKenaiProjectAction"));
                                    handle.start();
                                    KenaiProject kp = KenaiPopupMenu.this.getActualKenaiProject(proj, KenaiPopupMenu.this.getKenaiProjectName(proj));
                                    if (kp != null) {
                                        final ProjectHandleImpl pHandle = new ProjectHandleImpl(kp);
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                DashboardImpl.getInstance().addProject(pHandle, false, true);
                                            }
                                        });
                                    }
                                }
                                catch (KenaiException e) {
                                    String err = e.getLocalizedMessage();
                                    if (err == null) {
                                        err = e.getCause().getLocalizedMessage();
                                    }
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_CONNECTION", (Object)err)));
                                }
                                finally {
                                    if (handle == null) break block7;
                                    handle.finish();
                                    return;
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    class LazyNewIssuesAction
    extends JMenuItem {
        public LazyNewIssuesAction(final Project proj) {
            super(NbBundle.getMessage(KenaiPopupMenu.class, (String)"NEW_ISSUE"));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent e) {
                    new RequestProcessor("__ISSUETRACKER", 1).post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiPopupMenu.class, (String)"CONTACTING_ISSUE_TRACKER"));
                            handle.start();
                            try {
                                KenaiProject kp = KenaiPopupMenu.this.getActualKenaiProject(proj, KenaiPopupMenu.this.getKenaiProjectName(proj));
                                if (kp != null) {
                                    if (kp.getFeatures(KenaiService.Type.ISSUES).length > 0) {
                                        final ProjectHandleImpl pHandle = new ProjectHandleImpl(kp);
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                DashboardImpl.getInstance().addProject(pHandle, false, true);
                                            }
                                        });
                                        QueryAccessor.getDefault().getCreateIssueAction(pHandle).actionPerformed(e);
                                        return;
                                    }
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_ISSUETRACKER")));
                                    return;
                                }
                            }
                            catch (KenaiException e2) {
                                String err = e2.getLocalizedMessage();
                                if (err == null) {
                                    err = e2.getCause().getLocalizedMessage();
                                }
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_CONNECTION", (Object)err)));
                            }
                            finally {
                                handle.finish();
                            }
                        }
                    });
                }
            });
        }
    }

    class LazyFindIssuesAction
    extends JMenuItem {
        public LazyFindIssuesAction(final Project proj) {
            super(NbBundle.getMessage(KenaiPopupMenu.class, (String)"FIND_ISSUE"));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent e) {
                    new RequestProcessor("__ISSUETRACKER", 1).post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiPopupMenu.class, (String)"CONTACTING_ISSUE_TRACKER"));
                            handle.start();
                            try {
                                KenaiProject kp = KenaiPopupMenu.this.getActualKenaiProject(proj, KenaiPopupMenu.this.getKenaiProjectName(proj));
                                if (kp != null) {
                                    if (kp.getFeatures(KenaiService.Type.ISSUES).length > 0) {
                                        final ProjectHandleImpl pHandle = new ProjectHandleImpl(kp);
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                DashboardImpl.getInstance().addProject(pHandle, false, true);
                                            }
                                        });
                                        QueryAccessor.getDefault().getFindIssueAction(pHandle).actionPerformed(e);
                                        return;
                                    }
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_ISSUETRACKER")));
                                    return;
                                }
                            }
                            catch (KenaiException e2) {
                                String err = e2.getLocalizedMessage();
                                if (err == null) {
                                    err = e2.getCause().getLocalizedMessage();
                                }
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_CONNECTION", (Object)err)));
                            }
                            finally {
                                handle.finish();
                            }
                        }
                    });
                }
            });
        }
    }

    private final class KenaiPopupMenuPresenter
    extends AbstractAction
    implements Presenter.Popup {
        private final Project proj;

        private KenaiPopupMenuPresenter(Lookup actionContext) {
            this.proj = (Project)actionContext.lookup(Project.class);
        }

        public JMenuItem getPopupPresenter() {
            JMenu kenaiPopup = new JMenu();
            final Node[] nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
            kenaiPopup.setVisible(false);
            if (this.proj == null || !this.isKenaiProject(this.proj) || nodes.length > 1) {
                if (repoForProjCache.get(this.proj) == null && nodes.length == 1) {
                    final JMenu dummy = new JMenu(NbBundle.getMessage(KenaiPopupMenu.class, (String)"LBL_CHECKING"));
                    dummy.setVisible(true);
                    dummy.setEnabled(false);
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            String s = (String)KenaiPopupMenuPresenter.this.proj.getProjectDirectory().getAttribute("ProvidedExtensions.RemoteLocation");
                            if (s == null || KenaiProject.getNameForRepository((String)s) == null) {
                                repoForProjCache.put(KenaiPopupMenuPresenter.this.proj, "");
                                dummy.setVisible(false);
                            } else {
                                repoForProjCache.put(KenaiPopupMenuPresenter.this.proj, s);
                                final JMenu tmp = KenaiPopupMenuPresenter.this.constructKenaiMenu(nodes);
                                final Component[] c = tmp.getMenuComponents();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        tmp.revalidate();
                                        dummy.setText(NbBundle.getMessage(KenaiPopupMenu.class, (String)"KENAI_POPUP"));
                                        dummy.setEnabled(true);
                                        for (int i = 0; i < c.length; ++i) {
                                            Component item = c[i];
                                            dummy.add(item);
                                        }
                                        dummy.getParent().validate();
                                    }
                                });
                            }
                        }
                    });
                    return dummy;
                }
            } else {
                kenaiPopup = this.constructKenaiMenu(nodes);
            }
            return kenaiPopup;
        }

        private JMenu constructKenaiMenu(Node[] nodes) {
            JMenu kenaiPopup = new JMenu(NbBundle.getMessage(KenaiPopupMenu.class, (String)"KENAI_POPUP"));
            kenaiPopup.setVisible(true);
            kenaiPopup.add(new LazyOpenKenaiProjectAction(this.proj));
            kenaiPopup.addSeparator();
            String projRepo = (String)repoForProjCache.get(this.proj);
            String kpName = KenaiProject.getNameForRepository((String)projRepo);
            if (kpName != null) {
                kenaiPopup.add(new LazyFindIssuesAction(this.proj));
                kenaiPopup.add(new LazyNewIssuesAction(this.proj));
                kenaiPopup.addSeparator();
                VersioningSystem owner = VersioningSupport.getOwner((File)FileUtil.toFile((FileObject)this.proj.getProjectDirectory()));
                if (owner == null) {
                    Logger.getLogger(KenaiPopupMenu.class.getName()).log(Level.INFO, "VersioningSupport.getOwner(" + this.proj.getProjectDirectory() + ") returned null");
                }
                JMenu versioning = new JMenu(NbBundle.getMessage(KenaiPopupMenu.class, (String)"MSG_VERSIONING"));
                JComponent[] items = this.createVersioningSystemItems(owner, nodes);
                for (int i = 0; i < items.length; ++i) {
                    JComponent item = items[i];
                    if (item == null) continue;
                    versioning.add(item);
                }
                kenaiPopup.add(versioning);
            } else {
                kenaiPopup.setVisible(false);
            }
            return kenaiPopup;
        }

        private JComponent[] createVersioningSystemItems(VersioningSystem owner, Node[] nodes) {
            if (owner == null) {
                return new JComponent[0];
            }
            VCSAnnotator an = owner.getVCSAnnotator();
            if (an == null) {
                return new JComponent[0];
            }
            VCSContext ctx = VCSContext.forNodes((Node[])nodes);
            Action[] actions = an.getActions(ctx, VCSAnnotator.ActionDestination.PopupMenu);
            JComponent[] items = new JComponent[actions.length];
            int i = 0;
            for (Action action : actions) {
                if (action != null) {
                    JMenuItem item = this.createmenuItem(action);
                    items[i++] = item;
                    continue;
                }
                items[i++] = this.createJSeparator();
            }
            return items;
        }

        public JSeparator createJSeparator() {
            JMenu menu = new JMenu();
            menu.addSeparator();
            return (JSeparator)menu.getPopupMenu().getComponent(0);
        }

        private JMenuItem createmenuItem(Action action) {
            JMenuItem item;
            if (action instanceof SystemAction) {
                final SystemAction sa = (SystemAction)action;
                item = new JMenuItem(new AbstractAction(sa.getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        sa.actionPerformed(e);
                    }
                });
            } else {
                item = new JMenuItem(action);
            }
            Mnemonics.setLocalizedText((AbstractButton)item, (String)((String)action.getValue("Name")));
            return item;
        }

        boolean isKenaiProject(Project proj) {
            assert (proj != null);
            String projRepo = (String)repoForProjCache.get(proj);
            if (projRepo == null) {
                return false;
            }
            if (!projRepo.equals("")) {
                return KenaiProject.getNameForRepository((String)projRepo) != null;
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

