/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.collab.chat.ContactListCellRenderer;
import org.netbeans.modules.kenai.collab.chat.ContactListItem;
import org.netbeans.modules.kenai.collab.chat.FakeRoster;
import org.netbeans.modules.kenai.collab.chat.FakeRosterEntry;
import org.netbeans.modules.kenai.collab.chat.FakeRosterGroup;
import org.netbeans.modules.kenai.collab.chat.FilterItem;
import org.netbeans.modules.kenai.collab.chat.FilterRenderer;
import org.netbeans.modules.kenai.collab.chat.GroupListItem;
import org.netbeans.modules.kenai.collab.chat.UserListItem;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.openide.util.NbBundle;

public class ContactList
extends JPanel {
    private DefaultComboBoxModel filterModel = new DefaultComboBoxModel();
    private DefaultListModel listModel = new DefaultListModel();
    private FakeRoster roster = null;
    private FilterItem oldFilter = new FilterItem();
    private JList contactJList;
    private JScrollPane contactListScrollPane;
    private JComboBox filterCombo;
    private JTextField searchField;
    private JLabel searchLabel;
    private JPanel searchPanel;

    public ContactList() {
        this.initComponents();
        this.filterCombo.setModel(this.filterModel);
        this.filterCombo.setRenderer(new FilterRenderer());
        this.contactJList.setModel(this.listModel);
        this.contactJList.setCellRenderer(new ContactListCellRenderer());
        this.searchPanel.setVisible(false);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ContactList.this.updateContacts();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ContactList.this.updateContacts();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ContactList.this.updateContacts();
            }
        });
    }

    public void updateFilter() {
        this.roster = new FakeRoster();
        this.filterModel.removeAllElements();
        this.filterModel.addElement(new FilterItem());
        for (FakeRosterGroup group : this.roster.getGroups()) {
            this.filterModel.addElement(new FilterItem(group.getName(), group.getKenaiProject()));
        }
        this.filterCombo.setSelectedIndex(0);
    }

    public void updateContacts() {
        if (this.roster == null) {
            return;
        }
        if (this.filterCombo.getSelectedIndex() != 0) {
            this.oldFilter = (FilterItem)this.filterCombo.getSelectedItem();
            if (this.filterModel.getSize() > 0) {
                this.filterCombo.setSelectedIndex(0);
            }
        }
        Object selected = this.contactJList.getSelectedValue();
        this.listModel.clear();
        for (FakeRosterGroup group : this.roster.getGroups()) {
            if (!group.getName().toLowerCase().contains(this.searchField.getText().toLowerCase())) continue;
            this.listModel.addElement(new GroupListItem(group));
        }
        for (FakeRosterEntry entry : this.roster.getEntries()) {
            UserListItem i = new UserListItem(entry);
            if (this.listModel.contains(i) || !entry.getUser().toLowerCase().contains(this.searchField.getText().toLowerCase())) continue;
            this.listModel.addElement(i);
        }
        if (selected != null) {
            this.contactJList.setSelectedValue(selected, true);
        }
        if (this.contactJList.getSelectedIndex() < 0 && this.listModel.size() > 0) {
            this.contactJList.setSelectedIndex(0);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.contactJList.requestFocus();
    }

    private void initComponents() {
        this.filterCombo = new JComboBox();
        this.contactListScrollPane = new JScrollPane();
        this.contactJList = new JList();
        this.searchPanel = new JPanel();
        this.searchField = new JTextField();
        this.searchLabel = new JLabel();
        this.setBackground(SystemColor.control);
        this.setFocusCycleRoot(true);
        this.filterCombo.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.filterCombo.setNextFocusableComponent(this.contactJList);
        this.filterCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ContactList.this.filterComboItemStateChanged(evt);
            }
        });
        this.filterCombo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ContactList.this.filterComboKeyPressed(evt);
            }
        });
        this.contactJList.setBackground(ColorManager.getDefault().getDefaultBackground());
        this.contactJList.setNextFocusableComponent(this.searchField);
        this.contactJList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ContactList.this.contactJListMouseClicked(evt);
            }
        });
        this.contactJList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ContactList.this.contactJListFocusLost(evt);
            }
        });
        this.contactJList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ContactList.this.contactJListKeyPressed(evt);
            }
        });
        this.contactListScrollPane.setViewportView(this.contactJList);
        this.searchPanel.setBorder(BorderFactory.createEmptyBorder(1, 3, 5, 3));
        this.searchPanel.setOpaque(false);
        this.searchField.setNextFocusableComponent(this.filterCombo);
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ContactList.this.searchFieldFocusLost(evt);
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ContactList.this.searchFieldKeyPressed(evt);
            }
        });
        this.searchLabel.setText(NbBundle.getMessage(ContactList.class, (String)"ContactList.searchLabel.text", (Object[])new Object[0]));
        GroupLayout searchPanelLayout = new GroupLayout((Container)this.searchPanel);
        this.searchPanel.setLayout((LayoutManager)searchPanelLayout);
        searchPanelLayout.setHorizontalGroup((GroupLayout.Group)searchPanelLayout.createParallelGroup(1).add((GroupLayout.Group)searchPanelLayout.createSequentialGroup().add((Component)this.searchLabel).addPreferredGap(0).add((Component)this.searchField, -1, 186, Short.MAX_VALUE)));
        searchPanelLayout.setVerticalGroup((GroupLayout.Group)searchPanelLayout.createParallelGroup(1).add((GroupLayout.Group)searchPanelLayout.createParallelGroup(3).add((Component)this.searchLabel).add((Component)this.searchField, -2, -1, -2)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.filterCombo, 0, 249, Short.MAX_VALUE).add((Component)this.searchPanel, -1, -1, Short.MAX_VALUE).add((Component)this.contactListScrollPane, -1, 249, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.filterCombo, -2, -1, -2).add(2, 2, 2).add((Component)this.contactListScrollPane, -1, 239, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.searchPanel, -2, -1, -2)));
    }

    private void filterComboItemStateChanged(ItemEvent evt) {
        this.listModel.clear();
        if (this.filterCombo.getSelectedIndex() <= 0) {
            for (FakeRosterGroup group : this.roster.getGroups()) {
                this.listModel.addElement(new GroupListItem(group));
            }
            for (FakeRosterEntry entry : this.roster.getEntries()) {
                UserListItem i = new UserListItem(entry);
                if (this.listModel.contains(i)) continue;
                this.listModel.addElement(i);
            }
        } else {
            String group = ((FilterItem)this.filterCombo.getSelectedItem()).getName();
            Kenai k = ((FilterItem)this.filterCombo.getSelectedItem()).getKenaiProject().getKenai();
            FakeRosterGroup g = this.roster.getGroup(k, group);
            this.listModel.addElement(new GroupListItem(g));
            for (FakeRosterEntry entry : g.getEntries()) {
                this.listModel.addElement(new UserListItem(entry));
            }
        }
        this.contactJList.setSelectedIndex(0);
    }

    private void contactJListKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            ((ContactListItem)this.contactJList.getSelectedValue()).openChat();
        } else if (evt.getKeyCode() == 27) {
            this.contactJList.requestFocus();
            this.searchPanel.setVisible(false);
            this.searchField.setText("");
        } else if (!evt.isActionKey() && ("" + evt.getKeyChar()).trim().length() != 0 && evt.getKeyChar() != '\uffff') {
            this.searchPanel.setVisible(true);
            this.searchField.requestFocus();
            this.searchField.setText("" + evt.getKeyChar());
        }
    }

    private void contactJListMouseClicked(MouseEvent evt) {
        ContactListItem cl;
        if (evt.getClickCount() == 2 && !evt.isPopupTrigger() && (cl = (ContactListItem)this.contactJList.getSelectedValue()) != null) {
            cl.openChat();
        }
    }

    private void searchFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.contactJList.requestFocus();
            ContactListItem cl = (ContactListItem)this.contactJList.getSelectedValue();
            if (cl != null) {
                cl.openChat();
            }
            this.searchPanel.setVisible(false);
            this.searchField.setText("");
        } else if (evt.getKeyCode() == 40) {
            int next = this.contactJList.getSelectedIndex();
            if (next + 1 != this.contactJList.getModel().getSize()) {
                ++next;
            }
            this.contactJList.setSelectedIndex(next);
        } else if (evt.getKeyCode() == 38) {
            int prev = this.contactJList.getSelectedIndex();
            if (prev != 0) {
                --prev;
            }
            this.contactJList.setSelectedIndex(prev);
        } else if (evt.getKeyCode() == 27) {
            this.contactJList.requestFocus();
            this.searchPanel.setVisible(false);
            this.searchField.setText("");
        }
    }

    private void searchFieldFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.contactJList) {
            this.searchPanel.setVisible(false);
            this.searchField.setText("");
        }
    }

    private void contactJListFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.searchField) {
            this.searchPanel.setVisible(false);
            this.searchField.setText("");
        }
    }

    private void filterComboKeyPressed(KeyEvent evt) {
        if (!evt.isActionKey() && ("" + evt.getKeyChar()).trim().length() != 0 && evt.getKeyChar() != '\uffff') {
            this.searchPanel.setVisible(true);
            this.searchField.requestFocus();
            this.searchField.setText("" + evt.getKeyChar());
        }
    }
}

