/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.makeproject.ConfirmExtensions;
import org.netbeans.modules.cnd.makeproject.MakeActionProvider;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProjectConfigurationProvider;
import org.netbeans.modules.cnd.makeproject.MakeProjectEncodingQueryImpl;
import org.netbeans.modules.cnd.makeproject.MakeProjectFileProviderFactory;
import org.netbeans.modules.cnd.makeproject.MakeProjectOperations;
import org.netbeans.modules.cnd.makeproject.MakeProjectType;
import org.netbeans.modules.cnd.makeproject.MakeSharabilityQuery;
import org.netbeans.modules.cnd.makeproject.MakeSources;
import org.netbeans.modules.cnd.makeproject.MakeTemplateListener;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifactProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.spi.toolchain.ToolchainProject;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.OperationListener;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openidex.search.SearchInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class MakeProject
implements Project,
AntProjectListener,
Runnable {
    private static final boolean UNIT_TEST_MODE = CndUtils.isUnitTestMode();
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private static final String HEADER_EXTENSIONS = "header-extensions";
    private static final String C_EXTENSIONS = "c-extensions";
    private static final String CPP_EXTENSIONS = "cpp-extensions";
    private static final String MAKE_PROJECT_TYPE = "make-project-type";
    private static MakeTemplateListener templateListener = null;
    private final MakeProjectType kind;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private ConfigurationDescriptorProvider projectDescriptorProvider;
    private int projectType = -1;
    private Set<String> headerExtensions = MakeProject.createExtensionSet();
    private Set<String> cExtensions = MakeProject.createExtensionSet();
    private Set<String> cppExtensions = MakeProject.createExtensionSet();
    private String sourceEncoding = null;
    private boolean isOpenHookDone = false;
    private AtomicBoolean isDeleted = new AtomicBoolean(false);
    private final MakeSources sources;
    private final MutableCP sourcepath;
    private final PropertyChangeListener indexerListener = new IndexerOptionsListener();
    private static final String PROJECT_NAME_WITH_HIDDEN_PATHS = System.getProperty("cnd.project.name.hidden.paths");
    private static final int PROJECT_NAME_NUM_SHOWN_FOLDERS = Integer.getInteger("cnd.project.name.folders.num", 1);
    private List<Runnable> openedTasks;

    public MakeProject(AntProjectHelper helper) throws IOException {
        LOGGER.log(Level.FINE, "Start of creation MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), helper.getProjectDirectory().getName()});
        this.kind = new MakeProjectType();
        this.helper = helper;
        this.eval = this.createEvaluator();
        AuxiliaryConfiguration aux = helper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(helper, aux, this.eval);
        this.projectDescriptorProvider = new ConfigurationDescriptorProvider(helper.getProjectDirectory());
        LOGGER.log(Level.FINE, "Create ConfigurationDescriptorProvider@{0} for MakeProject@{1} {2}", new Object[]{System.identityHashCode(this.projectDescriptorProvider), System.identityHashCode(this), helper.getProjectDirectory().getName()});
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        this.sources = new MakeSources(this, helper);
        this.sourcepath = new MutableCP(this.sources);
        this.lookup = this.createLookup(aux);
        helper.addAntProjectListener((AntProjectListener)this);
        Element data = helper.getPrimaryConfigurationData(true);
        NodeList nl = data.getElementsByTagName(MAKE_PROJECT_TYPE);
        if (nl.getLength() == 1) {
            nl = nl.item(0).getChildNodes();
            String typeTxt = nl.item(0).getNodeValue();
            this.projectType = new Integer(typeTxt);
        }
        this.readProjectExtension(data, HEADER_EXTENSIONS, this.headerExtensions);
        this.readProjectExtension(data, C_EXTENSIONS, this.cExtensions);
        this.readProjectExtension(data, CPP_EXTENSIONS, this.cppExtensions);
        this.sourceEncoding = this.getSourceEncodingFromProjectXml();
        if (templateListener == null) {
            templateListener = new MakeTemplateListener();
            DataLoaderPool.getDefault().addOperationListener((OperationListener)templateListener);
        }
        LOGGER.log(Level.FINE, "End of creation MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), helper.getProjectDirectory().getName()});
    }

    private void readProjectExtension(Element data, String key, Set<String> set) {
        NodeList nl = data.getElementsByTagName(key);
        if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1) {
            String extensions = nl.item(0).getNodeValue();
            set.addAll(Arrays.asList(extensions.split(",")));
        }
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String toString() {
        return "MakeProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        return this.helper.getStandardPropertyEvaluator();
    }

    PropertyEvaluator evaluator() {
        return this.eval;
    }

    ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createLookup(AuxiliaryConfiguration aux) {
        MakeSubprojectProvider spp = new MakeSubprojectProvider();
        Lookup lkp = Lookups.fixed((Object[])new Object[]{new Info(), aux, this.helper.createCacheDirectoryProvider(), spp, new MakeActionProvider(this), new MakeLogicalViewProvider(this), new MakeCustomizerProvider(this, this.projectDescriptorProvider), new MakeArtifactProviderImpl(), new ProjectXmlSavedHookImpl(), UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new ProjectOpenedHookImpl()), new MakeSharabilityQuery(this.projectDescriptorProvider, FileUtil.toFile((FileObject)this.getProjectDirectory())), this.sources, new AntProjectHelperProvider(), this.projectDescriptorProvider, new MakeProjectConfigurationProvider(this, this.projectDescriptorProvider), new NativeProjectProvider(this, this.projectDescriptorProvider), new RecommendedTemplatesImpl(this.projectDescriptorProvider), new MakeProjectOperations(this), new FolderSearchInfo(this.projectDescriptorProvider), this.kind, new MakeProjectEncodingQueryImpl(this), new RemoteProjectImpl(), new ToolchainProjectImpl(), new CPPImpl(this.sources)});
        return LookupProviderSupport.createCompositeLookup((Lookup)lkp, (String)this.kind.getLookupMergerPath());
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        if (ev.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public boolean addAdditionalHeaderExtensions(Collection<String> needAdd) {
        Set<String> headerExtension = MakeProject.getHeaderSuffixes();
        Set<String> sourceExtension = MakeProject.getSourceSuffixes();
        Set<String> usedExtension = MakeProject.createExtensionSet();
        for (String extension : needAdd) {
            if (extension.length() <= 0 || headerExtension.contains(extension) || sourceExtension.contains(extension)) continue;
            usedExtension.add(extension);
        }
        if (usedExtension.size() > 0) {
            this.addMIMETypeExtensions(usedExtension, "text/x-h");
            this.headerExtensions.addAll(usedExtension);
            this.saveAdditionalExtensions();
            return true;
        }
        return false;
    }

    private void addMIMETypeExtensions(Collection<String> extensions, String mime) {
        MIMEExtensions exts = MIMEExtensions.get((String)mime);
        for (String ext : extensions) {
            exts.addExtension(ext);
        }
        CndFileVisibilityQuery.getDefault().stateChanged(null);
    }

    private Set<String> getUnknownExtensions(Set<String> inLoader, Set<String> inProject) {
        Set<String> unknown = MakeProject.createExtensionSet();
        for (String extension : inProject) {
            if (extension.length() <= 0 || inLoader.contains(extension)) continue;
            unknown.add(extension);
        }
        return unknown;
    }

    private void checkNeededExtensions() {
        if (UNIT_TEST_MODE) {
            return;
        }
        Set<String> unknownC = this.getUnknownExtensions(MakeProject.getCSuffixes(), this.cExtensions);
        Set<String> unknownCpp = this.getUnknownExtensions(MakeProject.getCppSuffixes(), this.cppExtensions);
        Set<String> unknownH = this.getUnknownExtensions(MakeProject.getHeaderSuffixes(), this.headerExtensions);
        if (!unknownC.isEmpty() && unknownCpp.isEmpty() && unknownH.isEmpty()) {
            if (unknownC.size() > 0 && this.addNewExtensionDialog(unknownC, "C")) {
                this.addMIMETypeExtensions(unknownC, "text/x-c");
            }
        } else if (unknownC.isEmpty() && !unknownCpp.isEmpty() && unknownH.isEmpty()) {
            if (this.addNewExtensionDialog(unknownCpp, "CPP")) {
                this.addMIMETypeExtensions(unknownCpp, "text/x-c++");
            }
        } else if (unknownC.isEmpty() && unknownCpp.isEmpty() && !unknownH.isEmpty()) {
            if (this.addNewExtensionDialog(unknownH, "H")) {
                this.addMIMETypeExtensions(unknownH, "text/x-h");
            }
        } else if (!(unknownC.isEmpty() && unknownCpp.isEmpty() && unknownH.isEmpty())) {
            ConfirmExtensions panel = new ConfirmExtensions(unknownC, unknownCpp, unknownH);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, MakeProject.getString("ConfirmExtensions.dialog.title"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                if (panel.isC()) {
                    this.addMIMETypeExtensions(unknownC, "text/x-c");
                }
                if (panel.isCpp()) {
                    this.addMIMETypeExtensions(unknownCpp, "text/x-c++");
                }
                if (panel.isHeader()) {
                    this.addMIMETypeExtensions(unknownH, "text/x-h");
                }
            }
        }
    }

    public void updateExtensions(Set<String> cSet, Set<String> cppSet, Set<String> hSet) {
        this.cExtensions.clear();
        this.cExtensions.addAll(cSet);
        this.cppExtensions.clear();
        this.cppExtensions.addAll(cppSet);
        this.headerExtensions.clear();
        this.headerExtensions.addAll(hSet);
        this.saveAdditionalExtensions();
    }

    private synchronized void registerClassPath(boolean register) {
        if (this.isOpenHookDone) {
            if (register) {
                GlobalPathRegistry.getDefault().register("org.netbeans.modules.cnd.makeproject/SOURCES", this.sourcepath.getClassPath());
            } else {
                try {
                    GlobalPathRegistry.getDefault().unregister("org.netbeans.modules.cnd.makeproject/SOURCES", this.sourcepath.getClassPath());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void saveAdditionalExtensions() {
        Element data = this.helper.getPrimaryConfigurationData(true);
        this.saveAdditionalHeaderExtensions(data, C_EXTENSIONS, this.cExtensions);
        this.saveAdditionalHeaderExtensions(data, CPP_EXTENSIONS, this.cppExtensions);
        this.saveAdditionalHeaderExtensions(data, HEADER_EXTENSIONS, this.headerExtensions);
        this.helper.putPrimaryConfigurationData(data, true);
    }

    private void saveAdditionalHeaderExtensions(Element data, String key, Set<String> set) {
        Element element;
        NodeList nodeList = data.getElementsByTagName(key);
        if (nodeList.getLength() == 1) {
            element = (Element)nodeList.item(0);
            NodeList deadKids = element.getChildNodes();
            while (deadKids.getLength() > 0) {
                element.removeChild(deadKids.item(0));
            }
        } else {
            element = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/make-project/1", key);
            data.appendChild(element);
        }
        StringBuilder buf = new StringBuilder();
        for (String e : set) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(e);
        }
        element.appendChild(data.getOwnerDocument().createTextNode(buf.toString()));
    }

    private boolean addNewExtensionDialog(Set<String> usedExtension, String type) {
        if (UNIT_TEST_MODE) {
            return true;
        }
        String message = MakeProject.getString("ADD_EXTENSION_QUESTION" + type + (usedExtension.size() == 1 ? "" : "S"));
        StringBuilder extensions = new StringBuilder();
        for (String ext : usedExtension) {
            if (extensions.length() > 0) {
                extensions.append(',');
            }
            extensions.append(ext);
        }
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(message, extensions.toString()), MakeProject.getString("ADD_EXTENSION_DIALOG_TITLE" + type + (usedExtension.size() == 1 ? "" : "S")), 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION;
    }

    public static Set<String> createExtensionSet() {
        if (CndFileUtils.isSystemCaseSensitive()) {
            return new TreeSet<String>();
        }
        return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }

    private static Set<String> getSourceSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c++").getValues());
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c").getValues());
        return suffixes;
    }

    private static Set<String> getCSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c").getValues());
        return suffixes;
    }

    private static Set<String> getCppSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c++").getValues());
        return suffixes;
    }

    private static Set<String> getHeaderSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-h").getValues());
        return suffixes;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeProject.class, (String)s);
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                Element data = MakeProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/make-project/1", "name");
                if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                    return ((Text)nl.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Element nameEl;
                Element data = MakeProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/make-project/1", "name");
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/make-project/1", "name");
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                MakeProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    public String getSourceEncodingFromProjectXml() {
        int i;
        Element data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = data.getElementsByTagName("sourceEncoding");
        if (nodeList != null && nodeList.getLength() > 0 && (i = 0) < nodeList.getLength()) {
            Node node = nodeList.item(i);
            return node.getTextContent();
        }
        return null;
    }

    public String getSourceEncoding() {
        if (this.sourceEncoding == null && !this.projectDescriptorProvider.gotDescriptor()) {
            return FileEncodingQuery.getDefaultEncoding().name();
        }
        if (this.sourceEncoding == null) {
            this.sourceEncoding = FileEncodingQuery.getDefaultEncoding().name();
        }
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public MakeConfiguration getActiveConfiguration() {
        MakeConfigurationDescriptor projectDescriptor;
        if (this.projectDescriptorProvider.gotDescriptor() && (projectDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor()) != null) {
            return projectDescriptor.getActiveConfiguration();
        }
        return null;
    }

    public void addOpenedTask(Runnable task) {
        if (this.openedTasks == null) {
            this.openedTasks = new ArrayList<Runnable>();
        }
        this.openedTasks.add(task);
    }

    @Override
    public void run() {
        this.onProjectOpened();
    }

    private synchronized void onProjectOpened() {
        if (!this.isOpenHookDone) {
            this.checkNeededExtensions();
            if (this.openedTasks != null) {
                for (Runnable runnable : this.openedTasks) {
                    runnable.run();
                }
                this.openedTasks.clear();
                this.openedTasks = null;
            }
            this.isOpenHookDone = true;
            if (MakeOptions.getInstance().isFullFileIndexer()) {
                this.registerClassPath(true);
            }
            MakeOptions.getInstance().addPropertyChangeListener(this.indexerListener);
        }
    }

    void setDeleted() {
        LOGGER.log(Level.FINE, "set deleted MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), this.helper.getProjectDirectory().getName()});
        this.isDeleted.set(true);
    }

    private synchronized void onProjectClosed() {
        LOGGER.log(Level.FINE, "on project close MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), this.helper.getProjectDirectory().getName()});
        this.save();
        if (this.projectDescriptorProvider.getConfigurationDescriptor() != null) {
            this.projectDescriptorProvider.getConfigurationDescriptor().closed();
        }
        MakeOptions.getInstance().removePropertyChangeListener(this.indexerListener);
        if (this.isOpenHookDone) {
            this.registerClassPath(false);
            this.isOpenHookDone = false;
        }
        MakeProjectFileProviderFactory.removeSearchBase(this);
    }

    public synchronized void save() {
        if (!this.isDeleted.get() && this.projectDescriptorProvider.getConfigurationDescriptor() != null) {
            this.projectDescriptorProvider.getConfigurationDescriptor().save();
        }
    }

    public synchronized void saveAndMarkDeleted() {
        if (this.isDeleted.compareAndSet(false, true) && this.projectDescriptorProvider.getConfigurationDescriptor() != null) {
            this.projectDescriptorProvider.getConfigurationDescriptor().save();
        }
    }

    public DevelopmentHostConfiguration getDevelopmentHostConfiguration() {
        MakeConfiguration conf = this.getActiveConfiguration();
        if (conf != null) {
            return conf.getDevelopmentHost();
        }
        return null;
    }

    public ExecutionEnvironment getDevelopmentHostExecutionEnvironment() {
        DevelopmentHostConfiguration dc = this.getDevelopmentHostConfiguration();
        return dc == null ? null : dc.getExecutionEnvironment();
    }

    private final class IndexerOptionsListener
    implements PropertyChangeListener {
        private IndexerOptionsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("fullFileIndexer".equals(evt.getPropertyName())) {
                MakeProject.this.registerClassPath(Boolean.TRUE.equals(evt.getNewValue()));
            }
        }
    }

    private static final class CPPImpl
    implements ClassPathProvider {
        private final MakeSources sources;

        public CPPImpl(MakeSources sources) {
            this.sources = sources;
        }

        public ClassPath findClassPath(FileObject file, String type) {
            if ("org.netbeans.modules.cnd.makeproject/SOURCES".equals(type)) {
                for (SourceGroup sg : this.sources.getSourceGroups("generic")) {
                    if (!sg.getRootFolder().equals(file)) continue;
                    try {
                        return ClassPathSupport.createClassPath(Arrays.asList(new PathResourceImpl(ClassPathSupport.createResource((URL)file.getURL()))));
                    }
                    catch (FileStateInvalidException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return null;
        }
    }

    private static final class PathResourceImpl
    implements FilteringPathResourceImplementation,
    PropertyChangeListener {
        private final PathResourceImplementation delegate;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public PathResourceImpl(PathResourceImplementation delegate) {
            this.delegate = delegate;
            this.delegate.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public boolean includes(URL root, String resource) {
            return !CndFileVisibilityQuery.getDefault().isIgnored(resource);
        }

        public URL[] getRoots() {
            return this.delegate.getRoots();
        }

        public ClassPathImplementation getContent() {
            return this.delegate.getContent();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.pcs.firePropertyChange(new PropertyChangeEvent(this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
        }
    }

    private static final class MutableCP
    implements ClassPathImplementation,
    ChangeListener {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final MakeSources sources;
        private List<PathResourceImplementation> resources = null;
        private long eventId = 0L;
        private ClassPath[] classpath = null;

        public MutableCP(MakeSources sources) {
            this.sources = sources;
            this.sources.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.sources));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            SourceGroup[] groups;
            long currentEventId;
            MutableCP mutableCP = this;
            synchronized (mutableCP) {
                if (this.resources != null) {
                    return this.resources;
                }
                currentEventId = this.eventId;
            }
            LinkedList<PathResourceImplementation> list = new LinkedList<PathResourceImplementation>();
            for (SourceGroup g : groups = this.sources.getSourceGroups("generic")) {
                try {
                    list.add((PathResourceImplementation)new PathResourceImpl(ClassPathSupport.createResource((URL)g.getRootFolder().getURL())));
                }
                catch (FileStateInvalidException ex) {
                    Logger.getLogger(MakeProject.class.getName()).log(Level.WARNING, null, ex);
                }
            }
            MutableCP mutableCP2 = this;
            synchronized (mutableCP2) {
                if (currentEventId == this.eventId) {
                    this.resources = list;
                }
            }
            return list;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            MutableCP mutableCP = this;
            synchronized (mutableCP) {
                this.resources = null;
                ++this.eventId;
            }
            this.pcs.firePropertyChange("resources", null, null);
        }

        public synchronized ClassPath[] getClassPath() {
            if (this.classpath == null) {
                this.classpath = new ClassPath[]{ClassPathFactory.createClassPath((ClassPathImplementation)this)};
            }
            return this.classpath;
        }
    }

    private class ToolchainProjectImpl
    implements ToolchainProject {
        private ToolchainProjectImpl() {
        }

        public CompilerSet getCompilerSet() {
            MakeConfiguration conf = MakeProject.this.getActiveConfiguration();
            if (conf != null) {
                return conf.getCompilerSet().getCompilerSet();
            }
            return null;
        }
    }

    private class RemoteProjectImpl
    implements RemoteProject {
        private RemoteProjectImpl() {
        }

        public ExecutionEnvironment getDevelopmentHost() {
            DevelopmentHostConfiguration devHost = MakeProject.this.getDevelopmentHostConfiguration();
            return devHost == null ? null : devHost.getExecutionEnvironment();
        }
    }

    private static class FolderSearchInfo
    implements SearchInfo {
        private ConfigurationDescriptorProvider projectDescriptorProvider;

        FolderSearchInfo(ConfigurationDescriptorProvider projectDescriptorProvider) {
            this.projectDescriptorProvider = projectDescriptorProvider;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator<DataObject> objectsToSearch() {
            MakeConfigurationDescriptor projectDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor();
            Folder rootFolder = projectDescriptor.getLogicalFolders();
            return rootFolder.getAllItemsAsDataObjectSet(false, "text/").iterator();
        }
    }

    private final class MakeArtifactProviderImpl
    implements MakeArtifactProvider {
        private MakeArtifactProviderImpl() {
        }

        @Override
        public MakeArtifact[] getBuildArtifacts() {
            ArrayList<MakeArtifact> artifacts = new ArrayList<MakeArtifact>();
            MakeConfigurationDescriptor projectDescriptor = MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor();
            Configuration[] confs = projectDescriptor.getConfs().toArray();
            for (int i = 0; i < confs.length; ++i) {
                MakeConfiguration makeConfiguration = (MakeConfiguration)confs[i];
                artifacts.add(new MakeArtifact(projectDescriptor, makeConfiguration));
            }
            return artifacts.toArray(new MakeArtifact[artifacts.size()]);
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            MakeProject.this.onProjectOpened();
        }

        protected void projectClosed() {
            MakeProject.this.onProjectClosed();
        }
    }

    private static final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        private ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
        }
    }

    private final class Info
    implements InfoInterface {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        @Override
        public void firePropertyChange(String prop) {
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            String name = PropertyUtils.getUsablePropertyName((String)MakeProject.this.getName());
            return name;
        }

        public String getDisplayName() {
            FileObject fo;
            String name = MakeProject.this.getName();
            if (PROJECT_NAME_WITH_HIDDEN_PATHS != null && (fo = MakeProject.this.getProjectDirectory()) != null && fo.isValid()) {
                String[] split;
                String prjDirDispName = FileUtil.getFileDisplayName((FileObject)fo);
                for (String skipPath : split = PROJECT_NAME_WITH_HIDDEN_PATHS.split(":")) {
                    if (!prjDirDispName.startsWith(skipPath)) continue;
                    prjDirDispName = prjDirDispName.substring(skipPath.length());
                    break;
                }
                if (prjDirDispName.startsWith("/") || prjDirDispName.startsWith("\\")) {
                    prjDirDispName = prjDirDispName.substring(1);
                }
                int sep = 0;
                for (int i = 0; i < PROJECT_NAME_NUM_SHOWN_FOLDERS; ++i) {
                    int nextSep = prjDirDispName.indexOf(92, sep);
                    int n = nextSep = nextSep == -1 ? prjDirDispName.indexOf(47, sep) : nextSep;
                    if (nextSep <= 0) {
                        sep = prjDirDispName.length();
                        break;
                    }
                    sep = nextSep + 1;
                }
                if (sep > 0) {
                    prjDirDispName = prjDirDispName.substring(0, sep);
                }
                if (prjDirDispName.length() > 0) {
                    if (prjDirDispName.endsWith("/") || prjDirDispName.endsWith("\\")) {
                        prjDirDispName = prjDirDispName.substring(0, prjDirDispName.length() - 1);
                    }
                    name = NbBundle.getMessage(this.getClass(), (String)"PRJ_DISPLAY_NAME_WITH_FOLDER", (Object)name, (Object)prjDirDispName);
                }
            }
            return name;
        }

        public Icon getIcon() {
            Icon icon = null;
            icon = MakeConfigurationDescriptor.MAKEFILE_ICON;
            return icon;
        }

        public Project getProject() {
            return MakeProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    static interface InfoInterface
    extends ProjectInformation {
        public void firePropertyChange(String var1);
    }

    private class MakeSubprojectProvider
    implements SubprojectProvider {
        private MakeSubprojectProvider() {
        }

        public void addChangeListener(ChangeListener listener) {
        }

        public Set<Project> getSubprojects() {
            HashSet<Project> subProjects = new HashSet<Project>();
            Set<Object> subProjectLocations = new HashSet();
            Element data = MakeProject.this.helper.getPrimaryConfigurationData(true);
            if (!MakeProject.this.projectDescriptorProvider.gotDescriptor() && data.getElementsByTagName("make-dep-projects").getLength() > 0) {
                NodeList nl4 = data.getElementsByTagName("make-dep-project");
                if (nl4.getLength() > 0) {
                    for (int i = 0; i < nl4.getLength(); ++i) {
                        Node node = nl4.item(i);
                        NodeList nl2 = node.getChildNodes();
                        for (int j = 0; j < nl2.getLength(); ++j) {
                            String typeTxt = nl2.item(j).getNodeValue();
                            subProjectLocations.add(typeTxt);
                        }
                    }
                }
            } else {
                MakeConfigurationDescriptor projectDescriptor = MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor();
                if (projectDescriptor == null) {
                    return subProjects;
                }
                subProjectLocations = projectDescriptor.getSubprojectLocations();
            }
            String baseDir = FileUtil.toFile((FileObject)MakeProject.this.getProjectDirectory()).getPath();
            for (String string : subProjectLocations) {
                String location = CndPathUtilitities.toAbsolutePath((String)baseDir, (String)string);
                try {
                    FileObject fo = FileUtil.toFileObject((File)new File(location).getCanonicalFile());
                    Project project = ProjectManager.getDefault().findProject(fo);
                    if (project == null) continue;
                    subProjects.add(project);
                }
                catch (Exception e) {
                    System.err.println("Cannot find subproject in '" + location + "' " + e);
                }
            }
            return subProjects;
        }

        public void removeChangeListener(ChangeListener listener) {
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] RECOMMENDED_TYPES = new String[]{"c-types", "cpp-types", "shell-types", "makefile-types", "simple-files", "fortran-types", "asm-types", "qt-types", "cncpp-test-types"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/cFiles/main.c", "Templates/cFiles/file.c", "Templates/cFiles/file.h", "Templates/cppFiles/class.cc", "Templates/cppFiles/main.cc", "Templates/cppFiles/file.cc", "Templates/cppFiles/file.h", "Templates/fortranFiles/fortranFreeFormatFile.f90", "Templates/MakeTemplates/ComplexMakefile", "Templates/MakeTemplates/SimpleMakefile/ExecutableMakefile", "Templates/MakeTemplates/SimpleMakefile/SharedLibMakefile", "Templates/MakeTemplates/SimpleMakefile/StaticLibMakefile"};
        private static final String[] PRIVILEGED_NAMES_QT = new String[]{"Templates/qtFiles/main.cc", "Templates/qtFiles/form.ui", "Templates/qtFiles/resource.qrc", "Templates/qtFiles/translation.ts", "Templates/cFiles/main.c", "Templates/cFiles/file.c", "Templates/cFiles/file.h", "Templates/cppFiles/class.cc", "Templates/cppFiles/main.cc", "Templates/cppFiles/file.cc", "Templates/cppFiles/file.h", "Templates/fortranFiles/fortranFreeFormatFile.f90", "Templates/MakeTemplates/ComplexMakefile", "Templates/MakeTemplates/SimpleMakefile/ExecutableMakefile", "Templates/MakeTemplates/SimpleMakefile/SharedLibMakefile", "Templates/MakeTemplates/SimpleMakefile/StaticLibMakefile"};
        private final ConfigurationDescriptorProvider configurationProvider;

        public RecommendedTemplatesImpl(ConfigurationDescriptorProvider configurationProvider) {
            this.configurationProvider = configurationProvider;
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            MakeConfiguration conf;
            MakeConfigurationDescriptor configurationDescriptor = this.configurationProvider.getConfigurationDescriptor(false);
            if (configurationDescriptor != null && (conf = configurationDescriptor.getActiveConfiguration()) != null && conf.isQmakeConfiguration()) {
                return PRIVILEGED_NAMES_QT;
            }
            return PRIVILEGED_NAMES;
        }
    }

    private final class AntProjectHelperProvider {
        private AntProjectHelperProvider() {
        }

        AntProjectHelper getAntProjectHelper() {
            return MakeProject.this.helper;
        }
    }
}

