/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.compiler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Arrays;
import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyHash;
import org.jruby.nb.RubyInstanceConfig;
import org.jruby.nb.RubyMatchData;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyRange;
import org.jruby.nb.RubyRegexp;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.executable.AbstractScript;
import org.jruby.nb.ast.util.ArgsUtil;
import org.jruby.nb.compiler.ASTInspector;
import org.jruby.nb.compiler.ArrayCallback;
import org.jruby.nb.compiler.BranchCallback;
import org.jruby.nb.compiler.CacheCompiler;
import org.jruby.nb.compiler.CompilerCallback;
import org.jruby.nb.compiler.InvocationCompiler;
import org.jruby.nb.compiler.MethodCompiler;
import org.jruby.nb.compiler.NotCompilableException;
import org.jruby.nb.compiler.ScriptCompiler;
import org.jruby.nb.compiler.VariableCompiler;
import org.jruby.nb.compiler.impl.BoxedVariableCompiler;
import org.jruby.nb.compiler.impl.HeapBasedVariableCompiler;
import org.jruby.nb.compiler.impl.InheritedCacheCompiler;
import org.jruby.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.compiler.impl.StackBasedVariableCompiler;
import org.jruby.nb.compiler.impl.StandardInvocationCompiler;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.GlobalVariables;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.BlockBody;
import org.jruby.nb.runtime.CompiledBlockCallback;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.builtin.InstanceVariables;
import org.jruby.nb.util.CodegenUtils;
import org.jruby.nb.util.JRubyClassLoader;
import org.jruby.nb.util.JavaNameMangler;
import org.jruby.util.ByteList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public class StandardASMCompiler
implements ScriptCompiler,
Opcodes {
    private static final String THREADCONTEXT = CodegenUtils.p(ThreadContext.class);
    private static final String RUBY = CodegenUtils.p(Ruby.class);
    private static final String IRUBYOBJECT = CodegenUtils.p(IRubyObject.class);
    public static final String[] METHOD_SIGNATURES = new String[]{CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class)};
    private static final String CLOSURE_SIGNATURE = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
    public static final int THIS = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int SELF_INDEX = 2;
    public static final int ARGS_INDEX = 3;
    public static final int CLOSURE_OFFSET = 0;
    public static final int DYNAMIC_SCOPE_OFFSET = 1;
    public static final int RUNTIME_OFFSET = 2;
    public static final int VARS_ARRAY_OFFSET = 3;
    public static final int NIL_OFFSET = 4;
    public static final int EXCEPTION_OFFSET = 5;
    public static final int PREVIOUS_EXCEPTION_OFFSET = 6;
    public static final int FIRST_TEMP_OFFSET = 7;
    private String classname;
    private String sourcename;
    private ClassWriter classWriter;
    private SkinnyMethodAdapter initMethod;
    private SkinnyMethodAdapter clinitMethod;
    int methodIndex = -1;
    int innerIndex = -1;
    int fieldIndex = 0;
    int rescueNumber = 1;
    int ensureNumber = 1;
    StaticScope topLevelScope;
    CacheCompiler cacheCompiler;
    static boolean USE_INHERITED_CACHE_FIELDS = true;
    private int constants = 0;

    public StandardASMCompiler(String classname, String sourcename) {
        this.classname = classname;
        this.sourcename = sourcename;
    }

    public byte[] getClassByteArray() {
        return this.classWriter.toByteArray();
    }

    public Class<?> loadClass(JRubyClassLoader classLoader) throws ClassNotFoundException {
        classLoader.defineClass(CodegenUtils.c(this.classname), this.classWriter.toByteArray());
        return classLoader.loadClass(CodegenUtils.c(this.classname));
    }

    public void dumpClass(PrintStream out) {
        TraceClassVisitor tcv = new TraceClassVisitor(new PrintWriter(out));
        new ClassReader(this.classWriter.toByteArray()).accept((ClassVisitor)tcv, 0);
        tcv.print(new PrintWriter(out));
    }

    public void writeClass(File destination) throws IOException {
        this.writeClass(this.classname, destination, this.classWriter);
    }

    private void writeClass(String classname, File destination, ClassWriter writer) throws IOException {
        String fullname = classname + ".class";
        String filename = null;
        String path = null;
        byte[] bytecode = writer.toByteArray();
        CheckClassAdapter.verify((ClassReader)new ClassReader(bytecode), (boolean)false, (PrintWriter)new PrintWriter(System.err));
        if (fullname.lastIndexOf("/") == -1) {
            filename = fullname;
            path = "";
        } else {
            filename = fullname.substring(fullname.lastIndexOf("/") + 1);
            path = fullname.substring(0, fullname.lastIndexOf("/"));
        }
        File pathfile = new File(destination, path);
        pathfile.mkdirs();
        FileOutputStream out = new FileOutputStream(new File(pathfile, filename));
        out.write(bytecode);
        out.close();
    }

    public String getClassname() {
        return this.classname;
    }

    public String getSourcename() {
        return this.sourcename;
    }

    public ClassVisitor getClassVisitor() {
        return this.classWriter;
    }

    @Override
    public void startScript(StaticScope scope) {
        String sourceNoPath;
        String[] pathElements;
        this.classWriter = new ClassWriter(3);
        this.classWriter.visit(RubyInstanceConfig.JAVA_VERSION, 33, this.classname, null, CodegenUtils.p(AbstractScript.class), null);
        this.topLevelScope = scope;
        this.beginInit();
        this.beginClassInit();
        this.cacheCompiler = new InheritedCacheCompiler(this);
        if (this.sourcename.indexOf("/") >= 0) {
            pathElements = this.sourcename.split("/");
            sourceNoPath = pathElements[pathElements.length - 1];
        } else if (this.sourcename.indexOf("\\") >= 0) {
            pathElements = this.sourcename.split("\\\\");
            sourceNoPath = pathElements[pathElements.length - 1];
        } else {
            sourceNoPath = this.sourcename;
        }
        StringBuffer smap = new StringBuffer();
        smap.append("SMAP\n").append(sourceNoPath).append("\n").append("Ruby\n").append("*S Ruby\n").append("*F\n").append("+ 1 ").append(sourceNoPath).append("\n").append(this.sourcename).append("\n").append("*L\n").append("1#1,999999:1,1\n").append("*E\n");
        this.classWriter.visitSource(sourceNoPath, smap.toString());
    }

    @Override
    public void endScript(boolean generateLoad, boolean generateMain) {
        SkinnyMethodAdapter method;
        String methodName = "__file__";
        if (generateLoad || generateMain) {
            method = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "load", METHOD_SIGNATURES[4], null, null));
            method.start();
            Label tryBegin = new Label();
            Label tryFinally = new Label();
            method.label(tryBegin);
            method.aload(1);
            StandardASMCompiler.buildStaticScopeNames(method, this.topLevelScope);
            method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "preLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String[].class));
            method.aload(0);
            method.aload(1);
            method.aload(2);
            method.aload(3);
            method.aload(4);
            method.invokevirtual(this.classname, methodName, METHOD_SIGNATURES[4]);
            method.aload(1);
            method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            method.areturn();
            method.label(tryFinally);
            method.aload(1);
            method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            method.athrow();
            method.trycatch(tryBegin, tryFinally, tryFinally, null);
            method.end();
        }
        if (generateMain) {
            method = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(9, "main", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String[].class)), null, null));
            method.start();
            method.newobj(this.classname);
            method.dup();
            method.invokespecial(this.classname, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
            method.newobj(CodegenUtils.p(RubyInstanceConfig.class));
            method.dup();
            method.invokespecial(CodegenUtils.p(RubyInstanceConfig.class), "<init>", "()V");
            method.dup();
            method.aload(0);
            method.invokevirtual(CodegenUtils.p(RubyInstanceConfig.class), "setArgv", CodegenUtils.sig(Void.TYPE, String[].class));
            method.invokestatic(CodegenUtils.p(Ruby.class), "newInstance", CodegenUtils.sig(Ruby.class, RubyInstanceConfig.class));
            method.dup();
            method.invokevirtual(RUBY, "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
            method.swap();
            method.invokevirtual(RUBY, "getTopSelf", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            method.invokevirtual(this.classname, "load", METHOD_SIGNATURES[4]);
            method.voidreturn();
            method.end();
        }
        method = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(4106, "setPosition", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, Integer.TYPE)), null, null));
        method.start();
        method.aload(0);
        method.ldc(this.sourcename);
        method.iload(1);
        method.invokevirtual(CodegenUtils.p(ThreadContext.class), "setFileAndLine", CodegenUtils.sig(Void.TYPE, String.class, Integer.TYPE));
        method.voidreturn();
        method.end();
        this.endInit();
        this.endClassInit();
    }

    public static void buildStaticScopeNames(SkinnyMethodAdapter method, StaticScope scope) {
        String signature = null;
        switch (scope.getNumberOfVariables()) {
            case 0: {
                method.pushInt(0);
                method.anewarray(CodegenUtils.p(String.class));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                signature = CodegenUtils.sig(String[].class, CodegenUtils.params(String.class, scope.getNumberOfVariables()));
                for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                    method.ldc(scope.getVariables()[i]);
                }
                method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructStringArray", signature);
                break;
            }
            default: {
                method.pushInt(scope.getNumberOfVariables());
                method.anewarray(CodegenUtils.p(String.class));
                for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                    method.dup();
                    method.pushInt(i);
                    method.ldc(scope.getVariables()[i]);
                    method.arraystore();
                }
            }
        }
    }

    private void beginInit() {
        ClassVisitor cv = this.getClassVisitor();
        this.initMethod = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
        this.initMethod.start();
        this.initMethod.aload(0);
        if (USE_INHERITED_CACHE_FIELDS) {
            this.initMethod.invokespecial(CodegenUtils.p(AbstractScript.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        } else {
            this.initMethod.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        }
        cv.visitField(18, "$class", CodegenUtils.ci(Class.class), null, null);
        this.initMethod.aload(0);
        this.initMethod.ldc(CodegenUtils.c(this.classname));
        this.initMethod.invokestatic(CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(Class.class, CodegenUtils.params(String.class)));
        this.initMethod.putfield(this.classname, "$class", CodegenUtils.ci(Class.class));
    }

    private void endInit() {
        this.initMethod.voidreturn();
        this.initMethod.end();
    }

    private void beginClassInit() {
        ClassVisitor cv = this.getClassVisitor();
        this.clinitMethod = new SkinnyMethodAdapter(cv.visitMethod(9, "<clinit>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
        this.clinitMethod.start();
    }

    private void endClassInit() {
        this.clinitMethod.voidreturn();
        this.clinitMethod.end();
    }

    public SkinnyMethodAdapter getInitMethod() {
        return this.initMethod;
    }

    public SkinnyMethodAdapter getClassInitMethod() {
        return this.clinitMethod;
    }

    public CacheCompiler getCacheCompiler() {
        return this.cacheCompiler;
    }

    @Override
    public MethodCompiler startMethod(String friendlyName, CompilerCallback args, StaticScope scope, ASTInspector inspector) {
        ASMMethodCompiler methodCompiler = new ASMMethodCompiler(friendlyName, inspector, scope);
        methodCompiler.beginMethod(args, scope);
        methodCompiler.method.nop();
        return methodCompiler;
    }

    public String getNewConstant(String type, String name_prefix) {
        return this.getNewConstant(type, name_prefix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewConstant(String type, String name_prefix, Object init) {
        String realName;
        ClassVisitor cv = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            realName = "_" + this.constants++;
        }
        cv.visitField(2, realName, type, null, null).visitEnd();
        if (init != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(init);
            this.initMethod.putfield(this.classname, realName, type);
        }
        return realName;
    }

    public String getNewField(String type, String name, Object init) {
        ClassVisitor cv = this.getClassVisitor();
        cv.visitField(2, name, type, null, null).visitEnd();
        if (init != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(init);
            this.initMethod.putfield(this.classname, name, type);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewStaticConstant(String type, String name_prefix) {
        String realName;
        ClassVisitor cv = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            realName = "__" + this.constants++;
        }
        cv.visitField(26, realName, type, null, null).visitEnd();
        return realName;
    }

    public class ASMMethodCompiler
    extends AbstractMethodCompiler {
        private boolean specificArity;

        public ASMMethodCompiler(String friendlyName, ASTInspector inspector, StaticScope scope) {
            super(scope, inspector, friendlyName);
        }

        @Override
        protected String getSignature() {
            if (this.scope.getRestArg() >= 0 || this.scope.getOptionalArgs() > 0 || this.scope.getRequiredArgs() > 3) {
                this.specificArity = false;
                return METHOD_SIGNATURES[4];
            }
            this.specificArity = true;
            return METHOD_SIGNATURES[this.scope.getRequiredArgs()];
        }

        @Override
        protected void createVariableCompiler() {
            this.variableCompiler = this.inspector == null ? new HeapBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()) : (this.inspector.hasClosure() || this.inspector.hasScopeAwareMethods() ? (RubyInstanceConfig.BOXED_COMPILE_ENABLED && !this.inspector.hasScopeAwareMethods() ? new BoxedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()) : new HeapBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex())) : new StackBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()));
        }

        public void beginChainedMethod() {
            this.method.start();
            this.method.aload(1);
            this.method.dup();
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.getRuntimeIndex());
            this.method.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.method.astore(this.getNilIndex());
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.getDynamicScopeIndex());
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            this.method.astore(this.getVarsArrayIndex());
            this.method.label(this.scopeStart);
        }

        @Override
        public void beginMethod(CompilerCallback args, StaticScope scope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.getRuntimeIndex());
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.method.astore(this.getNilIndex());
            this.variableCompiler.beginMethod(args, scope);
            this.method.label(this.scopeStart);
        }

        public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.getRuntimeIndex());
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.method.astore(this.getNilIndex());
            this.variableCompiler.beginClass(bodyPrep, scope);
            this.method.label(this.scopeStart);
        }

        @Override
        public void endMethod() {
            this.method.areturn();
            this.method.label(this.scopeEnd);
            this.variableCompiler.declareLocals(this.scope, this.scopeStart, this.scopeEnd);
            this.method.end();
            if (this.specificArity) {
                this.method = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(1, this.methodName, METHOD_SIGNATURES[4], null, null));
                this.method.start();
                this.method.aload(1);
                this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                this.method.aload(3);
                this.method.pushInt(this.scope.getRequiredArgs());
                this.method.pushInt(this.scope.getRequiredArgs());
                this.method.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
                this.method.pop();
                this.loadThis();
                this.loadThreadContext();
                this.loadSelf();
                for (int i = 0; i < this.scope.getRequiredArgs(); ++i) {
                    this.method.aload(3);
                    this.method.ldc(i);
                    this.method.arrayload();
                }
                this.method.aload(4);
                this.method.invokevirtual(StandardASMCompiler.this.classname, this.methodName, this.getSignature());
                this.method.areturn();
                this.method.end();
            }
        }

        @Override
        public void performReturn() {
            if (this.withinProtection) {
                this.loadThreadContext();
                this.invokeUtilityMethod("returnJump", CodegenUtils.sig(JumpException.ReturnJump.class, IRubyObject.class, ThreadContext.class));
                this.method.athrow();
            } else {
                this.method.areturn();
            }
        }

        @Override
        public void issueBreakEvent(CompilerCallback value) {
            if (this.currentLoopLabels != null) {
                value.call(this);
                this.issueLoopBreak();
            } else if (this.withinProtection) {
                this.loadThreadContext();
                value.call(this);
                this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
            } else {
                this.loadRuntime();
                value.call(this);
                this.invokeUtilityMethod("breakLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
            }
        }

        @Override
        public void issueNextEvent(CompilerCallback value) {
            if (this.currentLoopLabels != null) {
                value.call(this);
                this.issueLoopNext();
            } else if (this.withinProtection) {
                value.call(this);
                this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            } else {
                this.loadRuntime();
                value.call(this);
                this.invokeUtilityMethod("nextLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
            }
        }

        @Override
        public void issueRedoEvent() {
            if (this.currentLoopLabels != null) {
                this.issueLoopRedo();
            } else if (this.withinProtection) {
                this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            } else {
                this.loadRuntime();
                this.invokeUtilityMethod("redoLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class));
            }
        }
    }

    public class ASMClosureCompiler
    extends AbstractMethodCompiler {
        public ASMClosureCompiler(String closureMethodName, ASTInspector inspector, StaticScope scope) {
            super(scope, inspector, closureMethodName);
        }

        @Override
        protected String getSignature() {
            return CLOSURE_SIGNATURE;
        }

        @Override
        protected void createVariableCompiler() {
            this.variableCompiler = this.inspector == null ? new HeapBasedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex()) : (this.inspector.hasClosure() || this.inspector.hasScopeAwareMethods() ? (RubyInstanceConfig.BOXED_COMPILE_ENABLED && !this.inspector.hasScopeAwareMethods() ? new BoxedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex()) : new HeapBasedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex())) : new StackBasedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex()));
        }

        @Override
        public void beginMethod(CompilerCallback args, StaticScope scope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.getRuntimeIndex());
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.method.astore(this.getNilIndex());
            this.variableCompiler.beginClosure(args, scope);
            this.redoJump = new Label();
            this.method.label(this.scopeStart);
        }

        public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
            throw new NotCompilableException("ERROR: closure compiler should not be used for class bodies");
        }

        @Override
        public void endMethod() {
            this.method.areturn();
            this.method.label(this.scopeEnd);
            this.method.pop();
            this.method.go_to(this.scopeStart);
            this.method.trycatch(this.scopeStart, this.scopeEnd, this.scopeEnd, CodegenUtils.p(JumpException.RedoJump.class));
            this.variableCompiler.declareLocals(this.scope, this.scopeStart, this.scopeEnd);
            this.method.end();
        }

        @Override
        public void loadBlock() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameBlock", CodegenUtils.sig(Block.class, new Class[0]));
        }

        @Override
        public void performReturn() {
            this.loadThreadContext();
            this.invokeUtilityMethod("returnJump", CodegenUtils.sig(JumpException.ReturnJump.class, IRubyObject.class, ThreadContext.class));
            this.method.athrow();
        }

        public void processRequiredArgs(Arity arity, int requiredArgs, int optArgs, int restArg) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void assignOptionalArgs(Object object, int expectedArgsCount, int size, ArrayCallback optEval) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void processRestArg(int startIndex, int restArg) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void processBlockArgument(int index) {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadBlock();
            this.method.pushInt(index);
            this.invokeUtilityMethod("processBlockArgument", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Ruby.class, ThreadContext.class, Block.class, Integer.TYPE)));
        }

        @Override
        public void issueBreakEvent(CompilerCallback value) {
            if (this.currentLoopLabels != null) {
                value.call(this);
                this.issueLoopBreak();
            } else {
                this.loadThreadContext();
                value.call(this);
                this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
            }
        }

        @Override
        public void issueNextEvent(CompilerCallback value) {
            if (this.currentLoopLabels != null) {
                value.call(this);
                this.issueLoopNext();
            } else {
                value.call(this);
                this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            }
        }

        @Override
        public void issueRedoEvent() {
            if (this.currentLoopLabels != null) {
                this.issueLoopRedo();
            } else if (this.withinProtection) {
                this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            } else {
                this.method.go_to(this.scopeStart);
            }
        }
    }

    public abstract class AbstractMethodCompiler
    implements MethodCompiler {
        protected SkinnyMethodAdapter method;
        protected VariableCompiler variableCompiler;
        protected InvocationCompiler invocationCompiler;
        protected int argParamCount;
        protected Label[] currentLoopLabels;
        protected Label scopeStart = new Label();
        protected Label scopeEnd = new Label();
        protected Label redoJump;
        protected boolean withinProtection = false;
        private int lastLine = -1;
        private int lastPositionLine = -1;
        protected StaticScope scope;
        protected ASTInspector inspector;
        protected String methodName;

        public AbstractMethodCompiler(StaticScope scope, ASTInspector inspector, String methodName) {
            this.scope = scope;
            this.inspector = inspector;
            this.methodName = methodName;
            this.argParamCount = scope.getRestArg() >= 0 || scope.getOptionalArgs() > 0 || scope.getRequiredArgs() > 3 ? 1 : scope.getRequiredArgs();
            this.method = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(1, methodName, this.getSignature(), null, null));
            this.createVariableCompiler();
            this.invocationCompiler = new StandardInvocationCompiler(this, this.method);
        }

        protected abstract String getSignature();

        protected abstract void createVariableCompiler();

        public abstract void beginMethod(CompilerCallback var1, StaticScope var2);

        @Override
        public abstract void endMethod();

        @Override
        public MethodCompiler chainToMethod(String methodName, ASTInspector inspector) {
            MethodCompiler compiler = this.outline(methodName, inspector);
            this.endMethod();
            return compiler;
        }

        public MethodCompiler outline(String methodName, ASTInspector inspector) {
            this.method.aload(0);
            for (int i = 1; i <= this.getClosureIndex(); ++i) {
                this.method.aload(i);
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, methodName, this.getSignature());
            ASMMethodContinuationCompiler methodCompiler = new ASMMethodContinuationCompiler(methodName, inspector, this.scope);
            methodCompiler.beginChainedMethod();
            return methodCompiler;
        }

        public StandardASMCompiler getScriptCompiler() {
            return StandardASMCompiler.this;
        }

        @Override
        public void lineNumber(ISourcePosition position) {
            int thisLine = position.getStartLine();
            if (thisLine == this.lastLine) {
                return;
            }
            this.lastLine = thisLine;
            Label line = new Label();
            this.method.label(line);
            this.method.visitLineNumber(thisLine + 1, line);
        }

        public void loadThreadContext() {
            this.method.aload(1);
        }

        @Override
        public void loadSelf() {
            this.method.aload(2);
        }

        protected int getClosureIndex() {
            return 3 + this.argParamCount + 0;
        }

        protected int getRuntimeIndex() {
            return 3 + this.argParamCount + 2;
        }

        protected int getNilIndex() {
            return 3 + this.argParamCount + 4;
        }

        protected int getPreviousExceptionIndex() {
            return 3 + this.argParamCount + 6;
        }

        protected int getDynamicScopeIndex() {
            return 3 + this.argParamCount + 1;
        }

        protected int getVarsArrayIndex() {
            return 3 + this.argParamCount + 3;
        }

        protected int getFirstTempIndex() {
            return 3 + this.argParamCount + 7;
        }

        protected int getExceptionIndex() {
            return 3 + this.argParamCount + 5;
        }

        public void loadThis() {
            this.method.aload(0);
        }

        public void loadRuntime() {
            this.method.aload(this.getRuntimeIndex());
        }

        public void loadBlock() {
            this.method.aload(this.getClosureIndex());
        }

        @Override
        public void loadNil() {
            this.method.aload(this.getNilIndex());
        }

        @Override
        public void loadNull() {
            this.method.aconst_null();
        }

        @Override
        public void loadSymbol(String symbol) {
            this.loadRuntime();
            this.method.ldc(symbol);
            this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
        }

        @Override
        public void loadObject() {
            this.loadRuntime();
            this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
        }

        public void invokeUtilityMethod(String methodName, String signature) {
            this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), methodName, signature);
        }

        public void invokeThreadContext(String methodName, String signature) {
            this.method.invokevirtual(THREADCONTEXT, methodName, signature);
        }

        public void invokeIRuby(String methodName, String signature) {
            this.method.invokevirtual(RUBY, methodName, signature);
        }

        public void invokeIRubyObject(String methodName, String signature) {
            this.method.invokeinterface(IRUBYOBJECT, methodName, signature);
        }

        @Override
        public void consumeCurrentValue() {
            this.method.pop();
        }

        @Override
        public void duplicateCurrentValue() {
            this.method.dup();
        }

        @Override
        public void swapValues() {
            this.method.swap();
        }

        @Override
        public void retrieveSelf() {
            this.loadSelf();
        }

        @Override
        public void retrieveSelfClass() {
            this.loadSelf();
            this.metaclass();
        }

        @Override
        public VariableCompiler getVariableCompiler() {
            return this.variableCompiler;
        }

        @Override
        public InvocationCompiler getInvocationCompiler() {
            return this.invocationCompiler;
        }

        @Override
        public void assignConstantInCurrent(String name) {
            this.loadThreadContext();
            this.method.ldc(name);
            this.method.dup2_x1();
            this.method.pop2();
            this.invokeThreadContext("setConstantInCurrent", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        @Override
        public void assignConstantInModule(String name) {
            this.method.ldc(name);
            this.loadThreadContext();
            this.invokeUtilityMethod("setConstantInModule", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, String.class, ThreadContext.class));
        }

        @Override
        public void assignConstantInObject(String name) {
            this.loadRuntime();
            this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
            this.method.swap();
            this.assignConstantInModule(name);
        }

        @Override
        public void retrieveConstant(String name) {
            this.loadThreadContext();
            this.method.ldc(name);
            this.invokeThreadContext("getConstant", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        @Override
        public void retrieveConstantFromModule(String name) {
            this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastGetConstantFrom", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        @Override
        public void retrieveClassVariable(String name) {
            this.loadThreadContext();
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(name);
            this.invokeUtilityMethod("fastFetchClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class)));
        }

        @Override
        public void assignClassVariable(String name) {
            this.loadThreadContext();
            this.method.swap();
            this.loadRuntime();
            this.method.swap();
            this.loadSelf();
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.invokeUtilityMethod("fastSetClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        @Override
        public void assignClassVariable(String name, CompilerCallback value) {
            this.loadThreadContext();
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(name);
            value.call(this);
            this.invokeUtilityMethod("fastSetClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        @Override
        public void declareClassVariable(String name) {
            this.loadThreadContext();
            this.method.swap();
            this.loadRuntime();
            this.method.swap();
            this.loadSelf();
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.invokeUtilityMethod("fastDeclareClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        @Override
        public void declareClassVariable(String name, CompilerCallback value) {
            this.loadThreadContext();
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(name);
            value.call(this);
            this.invokeUtilityMethod("fastDeclareClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        @Override
        public void createNewFloat(double value) {
            this.loadRuntime();
            this.method.ldc(new Double(value));
            this.invokeIRuby("newFloat", CodegenUtils.sig(RubyFloat.class, CodegenUtils.params(Double.TYPE)));
        }

        @Override
        public void createNewFixnum(long value) {
            StandardASMCompiler.this.cacheCompiler.cacheFixnum(this, value);
        }

        @Override
        public void createNewBignum(BigInteger value) {
            this.loadRuntime();
            StandardASMCompiler.this.getCacheCompiler().cacheBigInteger(this, value);
            this.method.invokestatic(CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(RubyBignum.class, CodegenUtils.params(Ruby.class, BigInteger.class)));
        }

        @Override
        public void createNewString(ArrayCallback callback, int count) {
            this.loadRuntime();
            this.invokeIRuby("newString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(new Class[0])));
            for (int i = 0; i < count; ++i) {
                callback.nextValue(this, null, i);
                this.method.invokevirtual(CodegenUtils.p(RubyString.class), "append", CodegenUtils.sig(RubyString.class, CodegenUtils.params(IRubyObject.class)));
            }
        }

        @Override
        public void createNewSymbol(ArrayCallback callback, int count) {
            this.loadRuntime();
            this.createNewString(callback, count);
            this.toJavaString();
            this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
        }

        @Override
        public void createNewString(ByteList value) {
            this.loadRuntime();
            StandardASMCompiler.this.getCacheCompiler().cacheByteList(this, value.toString());
            this.invokeIRuby("newStringShared", CodegenUtils.sig(RubyString.class, CodegenUtils.params(ByteList.class)));
        }

        @Override
        public void createNewSymbol(String name) {
            StandardASMCompiler.this.getCacheCompiler().cacheSymbol(this, name);
        }

        @Override
        public void createNewArray(boolean lightweight) {
            this.loadRuntime();
            this.method.swap();
            if (lightweight) {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
            }
        }

        @Override
        public void createNewArray(Object[] sourceArray, ArrayCallback callback, boolean lightweight) {
            this.loadRuntime();
            this.createObjectArray(sourceArray, callback);
            if (lightweight) {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
            }
        }

        @Override
        public void createEmptyArray() {
            this.loadRuntime();
            this.invokeIRuby("newArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(new Class[0])));
        }

        @Override
        public void createObjectArray(Object[] sourceArray, ArrayCallback callback) {
            this.buildObjectArray(IRUBYOBJECT, sourceArray, callback);
        }

        @Override
        public void createObjectArray(int elementCount) {
            if (elementCount >= 6) {
                throw new NotCompilableException("Don't use createObjectArray(int) for more than 5 elements");
            }
            Object[] params = new Class[elementCount];
            Arrays.fill(params, IRubyObject.class);
            this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, (Class[])params));
        }

        private void buildObjectArray(String type, Object[] sourceArray, ArrayCallback callback) {
            if (sourceArray.length == 0) {
                this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            } else if (sourceArray.length <= 5) {
                for (int i = 0; i < sourceArray.length; ++i) {
                    callback.nextValue(this, sourceArray, i);
                }
                this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class, sourceArray.length)));
            } else {
                this.method.pushInt(sourceArray.length);
                this.method.anewarray(type);
                for (int i = 0; i < sourceArray.length; ++i) {
                    this.method.dup();
                    this.method.pushInt(i);
                    callback.nextValue(this, sourceArray, i);
                    this.method.arraystore();
                }
            }
        }

        @Override
        public void createEmptyHash() {
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
        }

        @Override
        public void createNewHash(Object elements, ArrayCallback callback, int keyCount) {
            this.loadRuntime();
            if (keyCount <= 3) {
                for (int i = 0; i < keyCount; ++i) {
                    callback.nextValue(this, elements, i);
                }
                this.invokeUtilityMethod("constructHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class, IRubyObject.class, keyCount * 2)));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
                for (int i = 0; i < keyCount; ++i) {
                    this.method.dup();
                    callback.nextValue(this, elements, i);
                    this.method.invokevirtual(CodegenUtils.p(RubyHash.class), "fastASet", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class, IRubyObject.class)));
                }
            }
        }

        @Override
        public void createNewRange(boolean isExclusive) {
            this.loadRuntime();
            this.loadThreadContext();
            this.method.dup2_x2();
            this.method.pop2();
            if (isExclusive) {
                this.method.invokestatic(CodegenUtils.p(RubyRange.class), "newExclusiveRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class)));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyRange.class), "newInclusiveRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class)));
            }
        }

        private void isTrue() {
            this.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        }

        @Override
        public void performBooleanBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
            Label afterJmp = new Label();
            Label falseJmp = new Label();
            this.isTrue();
            this.method.ifeq(falseJmp);
            trueBranch.branch(this);
            this.method.go_to(afterJmp);
            this.method.label(falseJmp);
            falseBranch.branch(this);
            this.method.label(afterJmp);
        }

        @Override
        public void performLogicalAnd(BranchCallback longBranch) {
            Label falseJmp = new Label();
            this.method.dup();
            this.isTrue();
            this.method.ifeq(falseJmp);
            this.method.pop();
            longBranch.branch(this);
            this.method.label(falseJmp);
        }

        @Override
        public void performLogicalOr(BranchCallback longBranch) {
            Label falseJmp = new Label();
            this.method.dup();
            this.isTrue();
            this.method.ifne(falseJmp);
            this.method.pop();
            longBranch.branch(this);
            this.method.label(falseJmp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performBooleanLoopSafe(BranchCallback condition, BranchCallback body, boolean checkFirst) {
            String mname = this.getNewRescueName();
            String signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class);
            SkinnyMethodAdapter mv = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, mname, signature, null, null));
            SkinnyMethodAdapter old_method = null;
            SkinnyMethodAdapter var_old_method = null;
            SkinnyMethodAdapter inv_old_method = null;
            boolean oldWithinProtection = this.withinProtection;
            this.withinProtection = true;
            Label[] oldLoopLabels = this.currentLoopLabels;
            this.currentLoopLabels = null;
            int oldArgCount = this.argParamCount;
            this.argParamCount = 0;
            try {
                old_method = this.method;
                var_old_method = this.getVariableCompiler().getMethodAdapter();
                inv_old_method = this.getInvocationCompiler().getMethodAdapter();
                this.method = mv;
                this.getVariableCompiler().setMethodAdapter(mv);
                this.getInvocationCompiler().setMethodAdapter(mv);
                mv.visitCode();
                mv.aload(1);
                mv.dup();
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                mv.dup();
                mv.astore(this.getRuntimeIndex());
                this.loadRuntime();
                this.invokeUtilityMethod("getErrorInfo", CodegenUtils.sig(IRubyObject.class, Ruby.class));
                mv.astore(this.getPreviousExceptionIndex());
                mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                mv.astore(this.getNilIndex());
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
                mv.dup();
                mv.astore(this.getDynamicScopeIndex());
                mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                mv.astore(this.getVarsArrayIndex());
                this.performBooleanLoop(condition, body, checkFirst);
                mv.areturn();
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
            finally {
                this.withinProtection = oldWithinProtection;
                this.method = old_method;
                this.getVariableCompiler().setMethodAdapter(var_old_method);
                this.getInvocationCompiler().setMethodAdapter(inv_old_method);
                this.currentLoopLabels = oldLoopLabels;
                this.argParamCount = oldArgCount;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, mname, signature);
        }

        @Override
        public void performBooleanLoop(BranchCallback condition, BranchCallback body, boolean checkFirst) {
            Label tryBegin = new Label();
            Label tryEnd = new Label();
            Label catchRedo = new Label();
            Label catchNext = new Label();
            Label catchBreak = new Label();
            Label catchRaised = new Label();
            Label endOfBody = new Label();
            Label conditionCheck = new Label();
            Label topOfBody = new Label();
            Label done = new Label();
            Label normalLoopEnd = new Label();
            this.method.trycatch(tryBegin, tryEnd, catchRedo, CodegenUtils.p(JumpException.RedoJump.class));
            this.method.trycatch(tryBegin, tryEnd, catchNext, CodegenUtils.p(JumpException.NextJump.class));
            this.method.trycatch(tryBegin, tryEnd, catchBreak, CodegenUtils.p(JumpException.BreakJump.class));
            if (checkFirst) {
                this.method.trycatch(tryBegin, tryEnd, catchRaised, CodegenUtils.p(RaiseException.class));
            }
            this.method.label(tryBegin);
            Label[] oldLoopLabels = this.currentLoopLabels;
            this.currentLoopLabels = new Label[]{endOfBody, topOfBody, done};
            if (checkFirst) {
                this.method.go_to(conditionCheck);
            }
            this.method.label(topOfBody);
            body.branch(this);
            this.method.label(endOfBody);
            this.method.pop();
            this.method.label(conditionCheck);
            condition.branch(this);
            this.isTrue();
            this.method.ifne(topOfBody);
            this.currentLoopLabels = oldLoopLabels;
            this.method.label(tryEnd);
            this.method.go_to(normalLoopEnd);
            this.method.label(catchRedo);
            this.method.pop();
            this.method.go_to(topOfBody);
            this.method.label(catchNext);
            this.method.pop();
            this.method.go_to(conditionCheck);
            this.method.label(catchBreak);
            this.loadBlock();
            this.loadThreadContext();
            this.invokeUtilityMethod("breakJumpInWhile", CodegenUtils.sig(IRubyObject.class, JumpException.BreakJump.class, Block.class, ThreadContext.class));
            this.method.go_to(done);
            if (checkFirst) {
                this.method.label(catchRaised);
                Label raiseNext = new Label();
                Label raiseRedo = new Label();
                Label raiseRethrow = new Label();
                this.method.dup();
                this.invokeUtilityMethod("getLocalJumpTypeOrRethrow", CodegenUtils.sig(String.class, CodegenUtils.params(RaiseException.class)));
                this.method.dup();
                this.method.ldc("break");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq(raiseNext);
                this.method.pop();
                this.invokeUtilityMethod("unwrapLocalJumpErrorValue", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(RaiseException.class)));
                this.method.go_to(done);
                this.method.label(raiseNext);
                this.method.dup();
                this.method.ldc("next");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq(raiseRedo);
                this.method.pop2();
                this.method.go_to(conditionCheck);
                this.method.label(raiseRedo);
                this.method.dup();
                this.method.ldc("redo");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq(raiseRethrow);
                this.method.pop2();
                this.method.go_to(topOfBody);
                this.method.label(raiseRethrow);
                this.method.pop();
                this.method.athrow();
            }
            this.method.label(normalLoopEnd);
            this.loadNil();
            this.method.label(done);
        }

        @Override
        public void performBooleanLoopLight(BranchCallback condition, BranchCallback body, boolean checkFirst) {
            Label endOfBody = new Label();
            Label conditionCheck = new Label();
            Label topOfBody = new Label();
            Label done = new Label();
            Label[] oldLoopLabels = this.currentLoopLabels;
            this.currentLoopLabels = new Label[]{endOfBody, topOfBody, done};
            if (checkFirst) {
                this.method.go_to(conditionCheck);
            }
            this.method.label(topOfBody);
            body.branch(this);
            this.method.label(endOfBody);
            this.method.pop();
            this.method.label(conditionCheck);
            condition.branch(this);
            this.isTrue();
            this.method.ifne(topOfBody);
            this.currentLoopLabels = oldLoopLabels;
            this.loadNil();
            this.method.label(done);
        }

        @Override
        public void createNewClosure(int line, StaticScope scope, int arity, CompilerCallback body, CompilerCallback args, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
            String closureMethodName = "block_" + ++StandardASMCompiler.this.innerIndex + "$RUBY$" + "__block__";
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, inspector, scope);
            closureCompiler.beginMethod(args, scope);
            body.call(closureCompiler);
            closureCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            StandardASMCompiler.this.cacheCompiler.cacheClosure(this, closureMethodName, arity, scope, hasMultipleArgsHead, argsNodeId, inspector);
            this.invokeUtilityMethod("createBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, BlockBody.class)));
        }

        @Override
        public void runBeginBlock(StaticScope scope, CompilerCallback body) {
            String closureMethodName = "block_" + ++StandardASMCompiler.this.innerIndex + "$RUBY$__begin__";
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, null, scope);
            closureCompiler.beginMethod(null, scope);
            body.call(closureCompiler);
            closureCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            StandardASMCompiler.buildStaticScopeNames(this.method, scope);
            StandardASMCompiler.this.cacheCompiler.cacheClosureOld(this, closureMethodName);
            this.invokeUtilityMethod("runBeginBlock", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String[].class, CompiledBlockCallback.class)));
        }

        @Override
        public void createNewForLoop(int arity, CompilerCallback body, CompilerCallback args, boolean hasMultipleArgsHead, NodeType argsNodeId) {
            String closureMethodName = "block_" + ++StandardASMCompiler.this.innerIndex + "$RUBY$__for__";
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, null, this.scope);
            closureCompiler.beginMethod(args, null);
            body.call(closureCompiler);
            closureCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            this.method.pushInt(arity);
            StandardASMCompiler.this.cacheCompiler.cacheClosureOld(this, closureMethodName);
            this.method.ldc(hasMultipleArgsHead);
            this.method.ldc(BlockBody.asArgumentType(argsNodeId));
            this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
        }

        @Override
        public void createNewEndBlock(CompilerCallback body) {
            String closureMethodName = "block_" + ++StandardASMCompiler.this.innerIndex + "$RUBY$__end__";
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, null, this.scope);
            closureCompiler.beginMethod(null, null);
            body.call(closureCompiler);
            closureCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            this.method.iconst_0();
            StandardASMCompiler.this.cacheCompiler.cacheClosureOld(this, closureMethodName);
            this.method.iconst_0();
            this.method.iconst_0();
            this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
            this.loadRuntime();
            this.invokeUtilityMethod("registerEndBlock", CodegenUtils.sig(Void.TYPE, Block.class, Ruby.class));
            this.loadNil();
        }

        public void getCompiledClass() {
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, "$class", CodegenUtils.ci(Class.class));
        }

        public void println() {
            this.method.dup();
            this.method.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
        }

        @Override
        public void defineAlias(String newName, String oldName) {
            this.loadThreadContext();
            this.method.ldc(newName);
            this.method.ldc(oldName);
            this.invokeUtilityMethod("defineAlias", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, String.class));
        }

        @Override
        public void loadFalse() {
            this.loadRuntime();
            this.invokeIRuby("getFalse", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
        }

        @Override
        public void loadTrue() {
            this.loadRuntime();
            this.invokeIRuby("getTrue", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
        }

        @Override
        public void loadCurrentModule() {
            this.loadThreadContext();
            this.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getStaticScope", CodegenUtils.sig(StaticScope.class, new Class[0]));
            this.method.invokevirtual(CodegenUtils.p(StaticScope.class), "getModule", CodegenUtils.sig(RubyModule.class, new Class[0]));
        }

        @Override
        public void retrieveInstanceVariable(String name) {
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(name);
            this.invokeUtilityMethod("fastGetInstanceVariable", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class, String.class));
        }

        @Override
        public void assignInstanceVariable(String name) {
            this.loadSelf();
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastSetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        @Override
        public void assignInstanceVariable(String name, CompilerCallback value) {
            this.loadSelf();
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
            this.method.ldc(name);
            value.call(this);
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastSetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        @Override
        public void retrieveGlobalVariable(String name) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "get", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        @Override
        public void assignGlobalVariable(String name) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "set", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        @Override
        public void assignGlobalVariable(String name, CompilerCallback value) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
            this.method.ldc(name);
            value.call(this);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "set", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        @Override
        public void negateCurrentValue() {
            this.loadRuntime();
            this.invokeUtilityMethod("negate", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class));
        }

        @Override
        public void splatCurrentValue() {
            this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "splatValue", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        @Override
        public void singlifySplattedValue() {
            this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "aValueSplat", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
        }

        @Override
        public void aryToAry() {
            this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "aryToAry", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
        }

        @Override
        public void ensureRubyArray() {
            this.invokeUtilityMethod("ensureRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        @Override
        public void ensureMultipleAssignableRubyArray(boolean masgnHasHead) {
            this.loadRuntime();
            this.method.pushBoolean(masgnHasHead);
            this.invokeUtilityMethod("ensureMultipleAssignableRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class, Ruby.class, Boolean.TYPE)));
        }

        @Override
        public void forEachInValueArray(int start, int count, Object source, ArrayCallback callback, ArrayCallback nilCallback, CompilerCallback argsCallback) {
            while (start < count) {
                this.method.dup();
                this.loadNil();
                this.method.pushInt(start);
                this.invokeUtilityMethod("arrayEntryOrNil", CodegenUtils.sig(IRubyObject.class, RubyArray.class, IRubyObject.class, Integer.TYPE));
                callback.nextValue(this, source, start);
                this.method.pop();
                ++start;
            }
            if (argsCallback != null) {
                this.method.dup();
                this.loadRuntime();
                this.method.pushInt(start);
                this.invokeUtilityMethod("subarrayOrEmpty", CodegenUtils.sig(RubyArray.class, RubyArray.class, Ruby.class, Integer.TYPE));
                argsCallback.call(this);
                this.method.pop();
            }
        }

        @Override
        public void asString() {
            this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
        }

        @Override
        public void toJavaString() {
            this.method.invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        }

        @Override
        public void nthRef(int match) {
            this.method.pushInt(match);
            this.backref();
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "nth_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class)));
        }

        @Override
        public void match() {
            this.loadThreadContext();
            this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match2", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
        }

        @Override
        public void match2() {
            this.loadThreadContext();
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
        }

        @Override
        public void match3() {
            this.loadThreadContext();
            this.invokeUtilityMethod("match3", CodegenUtils.sig(IRubyObject.class, RubyRegexp.class, IRubyObject.class, ThreadContext.class));
        }

        @Override
        public void createNewRegexp(ByteList value, int options) {
            String regexpField = StandardASMCompiler.this.getNewConstant(CodegenUtils.ci(RubyRegexp.class), "lit_reg_");
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            String regexpString = value.toString();
            this.loadRuntime();
            this.method.ldc(regexpString);
            this.method.pushInt(options);
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, String.class, Integer.TYPE)));
            this.method.aload(0);
            this.method.swap();
            this.method.putfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
            this.method.label(alreadyCreated);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
        }

        @Override
        public void createNewRegexp(CompilerCallback createStringCallback, int options) {
            boolean onceOnly = (options & 0x80) != 0;
            Label alreadyCreated = null;
            String regexpField = null;
            if (onceOnly) {
                regexpField = StandardASMCompiler.this.getNewConstant(CodegenUtils.ci(RubyRegexp.class), "lit_reg_");
                this.method.aload(0);
                this.method.getfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
                alreadyCreated = new Label();
                this.method.ifnonnull(alreadyCreated);
            }
            this.loadRuntime();
            createStringCallback.call(this);
            this.method.invokevirtual(CodegenUtils.p(RubyString.class), "getByteList", CodegenUtils.sig(ByteList.class, new Class[0]));
            this.method.pushInt(options);
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, ByteList.class, Integer.TYPE)));
            if (onceOnly) {
                this.method.aload(0);
                this.method.swap();
                this.method.putfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
                this.method.label(alreadyCreated);
                this.method.aload(0);
                this.method.getfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
            }
        }

        @Override
        public void pollThreadEvents() {
            if (!RubyInstanceConfig.THREADLESS_COMPILE_ENABLED) {
                this.loadThreadContext();
                this.invokeThreadContext("pollThreadEvents", CodegenUtils.sig(Void.TYPE, new Class[0]));
            }
        }

        @Override
        public void nullToNil() {
            Label notNull = new Label();
            this.method.dup();
            this.method.ifnonnull(notNull);
            this.method.pop();
            this.loadNil();
            this.method.label(notNull);
        }

        @Override
        public void isInstanceOf(Class clazz, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.method.instance_of(CodegenUtils.p(clazz));
            Label falseJmp = new Label();
            Label afterJmp = new Label();
            this.method.ifeq(falseJmp);
            trueBranch.branch(this);
            this.method.go_to(afterJmp);
            this.method.label(falseJmp);
            falseBranch.branch(this);
            this.method.label(afterJmp);
        }

        @Override
        public void isCaptured(final int number, final BranchCallback trueBranch, final BranchCallback falseBranch) {
            this.backref();
            this.method.dup();
            this.isInstanceOf(RubyMatchData.class, new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    AbstractMethodCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyMatchData.class));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "use", CodegenUtils.sig(Void.TYPE, new Class[0]));
                    AbstractMethodCompiler.this.method.pushInt(number);
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "group", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE)));
                    AbstractMethodCompiler.this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
                    Label isNil = new Label();
                    Label after = new Label();
                    AbstractMethodCompiler.this.method.ifne(isNil);
                    trueBranch.branch(context);
                    AbstractMethodCompiler.this.method.go_to(after);
                    AbstractMethodCompiler.this.method.label(isNil);
                    falseBranch.branch(context);
                    AbstractMethodCompiler.this.method.label(after);
                }
            }, new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    AbstractMethodCompiler.this.method.pop();
                    falseBranch.branch(context);
                }
            });
        }

        @Override
        public void branchIfModule(CompilerCallback receiverCallback, BranchCallback moduleCallback, BranchCallback notModuleCallback) {
            receiverCallback.call(this);
            this.isInstanceOf(RubyModule.class, moduleCallback, notModuleCallback);
        }

        @Override
        public void backref() {
            this.loadThreadContext();
            this.invokeThreadContext("getCurrentFrame", CodegenUtils.sig(Frame.class, new Class[0]));
            this.method.invokevirtual(CodegenUtils.p(Frame.class), "getBackRef", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        }

        @Override
        public void backrefMethod(String methodName) {
            this.backref();
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), methodName, CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void issueLoopBreak() {
            this.method.go_to(this.currentLoopLabels[2]);
        }

        public void issueLoopNext() {
            this.method.go_to(this.currentLoopLabels[0]);
        }

        public void issueLoopRedo() {
            this.method.go_to(this.currentLoopLabels[1]);
        }

        protected String getNewEnsureName() {
            return "ensure_" + StandardASMCompiler.this.ensureNumber++ + "$RUBY$__ensure__";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void protect(BranchCallback regularCode, BranchCallback protectedCode, Class ret) {
            String mname = this.getNewEnsureName();
            SkinnyMethodAdapter mv = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, Block.class), null, null));
            SkinnyMethodAdapter old_method = null;
            SkinnyMethodAdapter var_old_method = null;
            SkinnyMethodAdapter inv_old_method = null;
            boolean oldWithinProtection = this.withinProtection;
            this.withinProtection = true;
            Label[] oldLoopLabels = this.currentLoopLabels;
            this.currentLoopLabels = null;
            int oldArgCount = this.argParamCount;
            this.argParamCount = 0;
            try {
                old_method = this.method;
                var_old_method = this.getVariableCompiler().getMethodAdapter();
                inv_old_method = this.getInvocationCompiler().getMethodAdapter();
                this.method = mv;
                this.getVariableCompiler().setMethodAdapter(mv);
                this.getInvocationCompiler().setMethodAdapter(mv);
                mv.visitCode();
                mv.aload(1);
                mv.dup();
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                mv.dup();
                mv.astore(this.getRuntimeIndex());
                mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                mv.astore(this.getNilIndex());
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
                mv.dup();
                mv.astore(this.getDynamicScopeIndex());
                mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                mv.astore(this.getVarsArrayIndex());
                Label codeBegin = new Label();
                Label codeEnd = new Label();
                Label ensureBegin = new Label();
                Label ensureEnd = new Label();
                this.method.label(codeBegin);
                regularCode.branch(this);
                this.method.label(codeEnd);
                protectedCode.branch(this);
                mv.areturn();
                this.method.label(ensureBegin);
                this.method.astore(this.getExceptionIndex());
                this.method.label(ensureEnd);
                protectedCode.branch(this);
                this.method.aload(this.getExceptionIndex());
                this.method.athrow();
                this.method.trycatch(codeBegin, codeEnd, ensureBegin, null);
                this.method.trycatch(ensureBegin, ensureEnd, ensureBegin, null);
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
            finally {
                this.method = old_method;
                this.getVariableCompiler().setMethodAdapter(var_old_method);
                this.getInvocationCompiler().setMethodAdapter(inv_old_method);
                this.withinProtection = oldWithinProtection;
                this.currentLoopLabels = oldLoopLabels;
                this.argParamCount = oldArgCount;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, Block.class));
        }

        protected String getNewRescueName() {
            return "rescue_" + StandardASMCompiler.this.rescueNumber++ + "$RUBY$__rescue__";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rescue(BranchCallback regularCode, Class exception, BranchCallback catchCode, Class ret) {
            String mname = this.getNewRescueName();
            SkinnyMethodAdapter mv = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, Block.class), null, null));
            SkinnyMethodAdapter old_method = null;
            SkinnyMethodAdapter var_old_method = null;
            SkinnyMethodAdapter inv_old_method = null;
            Label afterMethodBody = new Label();
            Label catchRetry = new Label();
            Label catchRaised = new Label();
            Label catchJumps = new Label();
            Label exitRescue = new Label();
            boolean oldWithinProtection = this.withinProtection;
            this.withinProtection = true;
            Label[] oldLoopLabels = this.currentLoopLabels;
            this.currentLoopLabels = null;
            int oldArgCount = this.argParamCount;
            this.argParamCount = 0;
            try {
                old_method = this.method;
                var_old_method = this.getVariableCompiler().getMethodAdapter();
                inv_old_method = this.getInvocationCompiler().getMethodAdapter();
                this.method = mv;
                this.getVariableCompiler().setMethodAdapter(mv);
                this.getInvocationCompiler().setMethodAdapter(mv);
                mv.visitCode();
                mv.aload(1);
                mv.dup();
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                mv.dup();
                mv.astore(this.getRuntimeIndex());
                this.loadRuntime();
                this.invokeUtilityMethod("getErrorInfo", CodegenUtils.sig(IRubyObject.class, Ruby.class));
                mv.astore(this.getPreviousExceptionIndex());
                mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                mv.astore(this.getNilIndex());
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
                mv.dup();
                mv.astore(this.getDynamicScopeIndex());
                mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                mv.astore(this.getVarsArrayIndex());
                Label beforeBody = new Label();
                Label afterBody = new Label();
                Label catchBlock = new Label();
                mv.visitTryCatchBlock(beforeBody, afterBody, catchBlock, CodegenUtils.p(exception));
                mv.visitLabel(beforeBody);
                regularCode.branch(this);
                mv.label(afterBody);
                mv.go_to(exitRescue);
                mv.label(catchBlock);
                mv.astore(this.getExceptionIndex());
                catchCode.branch(this);
                mv.label(afterMethodBody);
                mv.go_to(exitRescue);
                mv.trycatch(catchBlock, afterMethodBody, catchRetry, CodegenUtils.p(JumpException.RetryJump.class));
                mv.label(catchRetry);
                mv.pop();
                mv.go_to(beforeBody);
                mv.trycatch(beforeBody, afterMethodBody, catchRaised, CodegenUtils.p(RaiseException.class));
                mv.label(catchRaised);
                mv.athrow();
                mv.trycatch(beforeBody, afterMethodBody, catchJumps, CodegenUtils.p(JumpException.class));
                mv.label(catchJumps);
                this.loadRuntime();
                mv.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                mv.athrow();
                mv.label(exitRescue);
                this.loadRuntime();
                mv.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                mv.areturn();
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
            finally {
                this.withinProtection = oldWithinProtection;
                this.method = old_method;
                this.getVariableCompiler().setMethodAdapter(var_old_method);
                this.getInvocationCompiler().setMethodAdapter(inv_old_method);
                this.currentLoopLabels = oldLoopLabels;
                this.argParamCount = oldArgCount;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, Block.class));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performRescue(BranchCallback regularCode, BranchCallback rubyCatchCode, BranchCallback javaCatchCode) {
            String mname = this.getNewRescueName();
            SkinnyMethodAdapter mv = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, mname, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class), null, null));
            SkinnyMethodAdapter old_method = null;
            SkinnyMethodAdapter var_old_method = null;
            SkinnyMethodAdapter inv_old_method = null;
            Label afterRubyCatchBody = new Label();
            Label afterJavaCatchBody = new Label();
            Label rubyCatchRetry = new Label();
            Label rubyCatchRaised = new Label();
            Label rubyCatchJumps = new Label();
            Label javaCatchRetry = new Label();
            Label javaCatchRaised = new Label();
            Label javaCatchJumps = new Label();
            Label exitRescue = new Label();
            boolean oldWithinProtection = this.withinProtection;
            this.withinProtection = true;
            Label[] oldLoopLabels = this.currentLoopLabels;
            this.currentLoopLabels = null;
            int oldArgCount = this.argParamCount;
            this.argParamCount = 0;
            try {
                old_method = this.method;
                var_old_method = this.getVariableCompiler().getMethodAdapter();
                inv_old_method = this.getInvocationCompiler().getMethodAdapter();
                this.method = mv;
                this.getVariableCompiler().setMethodAdapter(mv);
                this.getInvocationCompiler().setMethodAdapter(mv);
                mv.visitCode();
                mv.aload(1);
                mv.dup();
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                mv.dup();
                mv.astore(this.getRuntimeIndex());
                this.loadRuntime();
                this.invokeUtilityMethod("getErrorInfo", CodegenUtils.sig(IRubyObject.class, Ruby.class));
                mv.astore(this.getPreviousExceptionIndex());
                mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                mv.astore(this.getNilIndex());
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
                mv.dup();
                mv.astore(this.getDynamicScopeIndex());
                mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                mv.astore(this.getVarsArrayIndex());
                Label beforeBody = new Label();
                Label afterBody = new Label();
                Label rubyCatchBlock = new Label();
                Label flowCatchBlock = new Label();
                Label javaCatchBlock = new Label();
                mv.visitTryCatchBlock(beforeBody, afterBody, rubyCatchBlock, CodegenUtils.p(RaiseException.class));
                mv.visitTryCatchBlock(beforeBody, afterBody, flowCatchBlock, CodegenUtils.p(JumpException.FlowControlException.class));
                mv.visitTryCatchBlock(beforeBody, afterBody, javaCatchBlock, CodegenUtils.p(Exception.class));
                mv.visitLabel(beforeBody);
                regularCode.branch(this);
                mv.label(afterBody);
                mv.go_to(exitRescue);
                mv.label(rubyCatchBlock);
                mv.astore(this.getExceptionIndex());
                rubyCatchCode.branch(this);
                mv.label(afterRubyCatchBody);
                mv.go_to(exitRescue);
                mv.trycatch(rubyCatchBlock, afterRubyCatchBody, rubyCatchRetry, CodegenUtils.p(JumpException.RetryJump.class));
                mv.label(rubyCatchRetry);
                mv.pop();
                mv.go_to(beforeBody);
                mv.trycatch(beforeBody, afterRubyCatchBody, rubyCatchRaised, CodegenUtils.p(RaiseException.class));
                mv.label(rubyCatchRaised);
                mv.athrow();
                mv.trycatch(beforeBody, afterRubyCatchBody, rubyCatchJumps, CodegenUtils.p(JumpException.class));
                mv.label(rubyCatchJumps);
                this.loadRuntime();
                mv.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                mv.athrow();
                mv.label(flowCatchBlock);
                this.loadRuntime();
                mv.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                mv.athrow();
                mv.label(javaCatchBlock);
                mv.astore(this.getExceptionIndex());
                javaCatchCode.branch(this);
                mv.label(afterJavaCatchBody);
                mv.go_to(exitRescue);
                mv.trycatch(javaCatchBlock, afterJavaCatchBody, javaCatchRetry, CodegenUtils.p(JumpException.RetryJump.class));
                mv.label(javaCatchRetry);
                mv.pop();
                mv.go_to(beforeBody);
                mv.trycatch(javaCatchBlock, afterJavaCatchBody, javaCatchRaised, CodegenUtils.p(RaiseException.class));
                mv.label(javaCatchRaised);
                mv.athrow();
                mv.trycatch(javaCatchBlock, afterJavaCatchBody, javaCatchJumps, CodegenUtils.p(JumpException.class));
                mv.label(javaCatchJumps);
                this.loadRuntime();
                mv.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                mv.athrow();
                mv.label(exitRescue);
                this.loadRuntime();
                mv.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                mv.areturn();
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
            finally {
                this.withinProtection = oldWithinProtection;
                this.method = old_method;
                this.getVariableCompiler().setMethodAdapter(var_old_method);
                this.getInvocationCompiler().setMethodAdapter(inv_old_method);
                this.currentLoopLabels = oldLoopLabels;
                this.argParamCount = oldArgCount;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, mname, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class));
        }

        @Override
        public void wrapJavaException() {
            this.loadRuntime();
            this.loadException();
            this.wrapJavaObject();
        }

        public void wrapJavaObject() {
            this.method.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToUsableRubyObject", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
        }

        @Override
        public void inDefined() {
            this.method.aload(1);
            this.method.iconst_1();
            this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
        }

        @Override
        public void outDefined() {
            this.method.aload(1);
            this.method.iconst_0();
            this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
        }

        @Override
        public void stringOrNil() {
            this.loadRuntime();
            this.loadNil();
            this.invokeUtilityMethod("stringOrNil", CodegenUtils.sig(IRubyObject.class, String.class, Ruby.class, IRubyObject.class));
        }

        @Override
        public void pushNull() {
            this.method.aconst_null();
        }

        @Override
        public void pushString(String str) {
            this.method.ldc(str);
        }

        @Override
        public void isMethodBound(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.metaclass();
            this.method.ldc(name);
            this.method.iconst_0();
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void hasBlock(BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadBlock();
            this.method.invokevirtual(CodegenUtils.p(Block.class), "isGiven", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void isGlobalDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "isDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void isConstantDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadThreadContext();
            this.method.ldc(name);
            this.invokeThreadContext("getConstantDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void isInstanceVariableDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadSelf();
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
            this.method.ldc(name);
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastHasInstanceVariable", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label trueLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifne(trueLabel);
            falseBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(trueLabel);
            trueBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void isClassVarDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label trueLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifne(trueLabel);
            falseBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(trueLabel);
            trueBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public Object getNewEnding() {
            return new Label();
        }

        @Override
        public void isNil(BranchCallback trueBranch, BranchCallback falseBranch) {
            this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void isNull(BranchCallback trueBranch, BranchCallback falseBranch) {
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifnonnull(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void ifNull(Object gotoToken) {
            this.method.ifnull((Label)gotoToken);
        }

        @Override
        public void ifNotNull(Object gotoToken) {
            this.method.ifnonnull((Label)gotoToken);
        }

        @Override
        public void setEnding(Object endingToken) {
            this.method.label((Label)endingToken);
        }

        @Override
        public void go(Object gotoToken) {
            this.method.go_to((Label)gotoToken);
        }

        @Override
        public void isConstantBranch(final BranchCallback setup, final BranchCallback isConstant, final BranchCallback isMethod, final BranchCallback none, final String name) {
            this.rescue(new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    setup.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.instance_of(CodegenUtils.p(RubyModule.class));
                    Label falseJmp = new Label();
                    Label afterJmp = new Label();
                    Label nextJmp = new Label();
                    Label nextJmpPop = new Label();
                    AbstractMethodCompiler.this.method.ifeq(nextJmp);
                    AbstractMethodCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.ldc(name);
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastGetConstantAt", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.ifnull(nextJmpPop);
                    AbstractMethodCompiler.this.method.pop();
                    AbstractMethodCompiler.this.method.pop();
                    isConstant.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.go_to(afterJmp);
                    AbstractMethodCompiler.this.method.label(nextJmpPop);
                    AbstractMethodCompiler.this.method.pop();
                    AbstractMethodCompiler.this.method.label(nextJmp);
                    AbstractMethodCompiler.this.metaclass();
                    AbstractMethodCompiler.this.method.ldc(name);
                    AbstractMethodCompiler.this.method.iconst_1();
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
                    AbstractMethodCompiler.this.method.ifeq(falseJmp);
                    isMethod.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.go_to(afterJmp);
                    AbstractMethodCompiler.this.method.label(falseJmp);
                    none.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.label(afterJmp);
                }
            }, JumpException.class, none, String.class);
        }

        @Override
        public void metaclass() {
            this.invokeIRubyObject("getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        }

        @Override
        public void aprintln() {
            this.method.aprintln();
        }

        @Override
        public void getVisibilityFor(String name) {
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(String.class)));
            this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "getVisibility", CodegenUtils.sig(Visibility.class, new Class[0]));
        }

        @Override
        public void isPrivate(Object gotoToken, int toConsume) {
            this.method.getstatic(CodegenUtils.p(Visibility.class), "PRIVATE", CodegenUtils.ci(Visibility.class));
            Label temp = new Label();
            this.method.if_acmpne(temp);
            while (toConsume-- > 0) {
                this.method.pop();
            }
            this.method.go_to((Label)gotoToken);
            this.method.label(temp);
        }

        @Override
        public void isNotProtected(Object gotoToken, int toConsume) {
            this.method.getstatic(CodegenUtils.p(Visibility.class), "PROTECTED", CodegenUtils.ci(Visibility.class));
            Label temp = new Label();
            this.method.if_acmpeq(temp);
            while (toConsume-- > 0) {
                this.method.pop();
            }
            this.method.go_to((Label)gotoToken);
            this.method.label(temp);
        }

        @Override
        public void selfIsKindOf(Object gotoToken) {
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "getRealClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
            this.loadSelf();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
            this.method.ifne((Label)gotoToken);
        }

        @Override
        public void notIsModuleAndClassVarDefined(String name, Object gotoToken) {
            this.method.dup();
            this.method.instance_of(CodegenUtils.p(RubyModule.class));
            Label falsePopJmp = new Label();
            Label successJmp = new Label();
            this.method.ifeq(falsePopJmp);
            this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            this.method.ifeq((Label)gotoToken);
            this.method.go_to(successJmp);
            this.method.label(falsePopJmp);
            this.method.pop();
            this.method.go_to((Label)gotoToken);
            this.method.label(successJmp);
        }

        @Override
        public void ifSingleton(Object gotoToken) {
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isSingleton", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
            this.method.ifne((Label)gotoToken);
        }

        @Override
        public void getInstanceVariable(String name) {
            this.method.ldc(name);
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastGetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        @Override
        public void getFrameName() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameName", CodegenUtils.sig(String.class, new Class[0]));
        }

        @Override
        public void getFrameKlazz() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameKlazz", CodegenUtils.sig(RubyModule.class, new Class[0]));
        }

        @Override
        public void superClass() {
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "getSuperClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        }

        @Override
        public void attached() {
            this.method.visitTypeInsn(192, CodegenUtils.p(MetaClass.class));
            this.method.invokevirtual(CodegenUtils.p(MetaClass.class), "getAttached", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        }

        @Override
        public void ifNotSuperMethodBound(Object token) {
            this.method.swap();
            this.method.iconst_0();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
            this.method.ifeq((Label)token);
        }

        @Override
        public void concatArrays() {
            this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "concat", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void concatObjectArrays() {
            this.invokeUtilityMethod("concatObjectArrays", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject[].class)));
        }

        @Override
        public void appendToArray() {
            this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "append", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        @Override
        public void appendToObjectArray() {
            this.invokeUtilityMethod("appendToObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject.class)));
        }

        @Override
        public void convertToJavaArray() {
            this.method.invokestatic(CodegenUtils.p(ArgsUtil.class), "convertToJavaArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class)));
        }

        @Override
        public void aliasGlobal(String newName, String oldName) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
            this.method.ldc(newName);
            this.method.ldc(oldName);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "alias", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class, String.class)));
            this.loadNil();
        }

        @Override
        public void undefMethod(String name) {
            this.loadThreadContext();
            this.invokeThreadContext("getRubyClass", CodegenUtils.sig(RubyModule.class, new Class[0]));
            Label notNull = new Label();
            this.method.dup();
            this.method.ifnonnull(notNull);
            this.method.pop();
            this.loadRuntime();
            this.method.ldc("No class to undef method '" + name + "'.");
            this.invokeIRuby("newTypeError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(String.class)));
            this.method.athrow();
            this.method.label(notNull);
            this.loadThreadContext();
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "undef", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class)));
            this.loadNil();
        }

        @Override
        public void defineClass(final String name, final StaticScope staticScope, final CompilerCallback superCallback, final CompilerCallback pathCallback, CompilerCallback bodyCallback, final CompilerCallback receiverCallback) {
            String methodName = null;
            if (receiverCallback == null) {
                String mangledName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name);
                methodName = "class_" + ++StandardASMCompiler.this.methodIndex + "$RUBY$" + mangledName;
            } else {
                methodName = "sclass_" + ++StandardASMCompiler.this.methodIndex + "$RUBY$__singleton__";
            }
            final ASMMethodCompiler methodCompiler = new ASMMethodCompiler(methodName, null, staticScope);
            CompilerCallback bodyPrep = new CompilerCallback(){

                @Override
                public void call(MethodCompiler context) {
                    if (receiverCallback == null) {
                        if (superCallback != null) {
                            methodCompiler.loadRuntime();
                            superCallback.call(methodCompiler);
                            methodCompiler.invokeUtilityMethod("prepareSuperClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                        } else {
                            methodCompiler.method.aconst_null();
                        }
                        methodCompiler.loadThreadContext();
                        pathCallback.call(methodCompiler);
                        methodCompiler.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                        methodCompiler.method.swap();
                        methodCompiler.method.ldc(name);
                        methodCompiler.method.swap();
                        methodCompiler.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetClassUnder", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(String.class, RubyClass.class)));
                    } else {
                        methodCompiler.loadRuntime();
                        methodCompiler.method.aload(2);
                        int selfTemp = methodCompiler.getVariableCompiler().grabTempLocal();
                        methodCompiler.getVariableCompiler().setTempLocal(selfTemp);
                        methodCompiler.method.aload(2);
                        methodCompiler.invokeUtilityMethod("getSingletonClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                    }
                    methodCompiler.method.dup();
                    methodCompiler.method.astore(2);
                    methodCompiler.loadThreadContext();
                    methodCompiler.method.swap();
                    StandardASMCompiler.buildStaticScopeNames(methodCompiler.method, staticScope);
                    methodCompiler.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, String[].class)));
                }
            };
            Label start = new Label();
            Label end = new Label();
            Label after = new Label();
            Label noException = new Label();
            methodCompiler.method.trycatch(start, end, after, null);
            methodCompiler.beginClass(bodyPrep, staticScope);
            methodCompiler.method.label(start);
            bodyCallback.call(methodCompiler);
            methodCompiler.method.label(end);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            methodCompiler.method.go_to(noException);
            methodCompiler.method.label(after);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            methodCompiler.method.athrow();
            methodCompiler.method.label(noException);
            methodCompiler.endMethod();
            this.method.aload(0);
            this.loadThreadContext();
            if (receiverCallback == null) {
                this.method.aload(2);
            } else {
                receiverCallback.call(this);
            }
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            this.method.invokevirtual(StandardASMCompiler.this.classname, methodName, METHOD_SIGNATURES[0]);
        }

        @Override
        public void defineModule(final String name, final StaticScope staticScope, final CompilerCallback pathCallback, CompilerCallback bodyCallback) {
            String mangledName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name);
            String methodName = "module__" + ++StandardASMCompiler.this.methodIndex + "$RUBY$" + mangledName;
            final ASMMethodCompiler methodCompiler = new ASMMethodCompiler(methodName, null, staticScope);
            CompilerCallback bodyPrep = new CompilerCallback(){

                @Override
                public void call(MethodCompiler context) {
                    methodCompiler.loadThreadContext();
                    pathCallback.call(methodCompiler);
                    methodCompiler.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                    methodCompiler.method.ldc(name);
                    methodCompiler.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetModuleUnder", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(String.class)));
                    methodCompiler.method.dup();
                    methodCompiler.method.astore(2);
                    methodCompiler.loadThreadContext();
                    methodCompiler.method.swap();
                    StandardASMCompiler.buildStaticScopeNames(methodCompiler.method, staticScope);
                    methodCompiler.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, String[].class)));
                }
            };
            Label start = new Label();
            Label end = new Label();
            Label after = new Label();
            Label noException = new Label();
            methodCompiler.method.trycatch(start, end, after, null);
            methodCompiler.beginClass(bodyPrep, staticScope);
            methodCompiler.method.label(start);
            bodyCallback.call(methodCompiler);
            methodCompiler.method.label(end);
            methodCompiler.method.go_to(noException);
            methodCompiler.method.label(after);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            methodCompiler.method.athrow();
            methodCompiler.method.label(noException);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            methodCompiler.endMethod();
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            this.method.invokevirtual(StandardASMCompiler.this.classname, methodName, METHOD_SIGNATURES[4]);
        }

        @Override
        public void unwrapPassedBlock() {
            this.loadBlock();
            this.invokeUtilityMethod("getBlockFromBlockPassBody", CodegenUtils.sig(Block.class, CodegenUtils.params(IRubyObject.class, Block.class)));
        }

        @Override
        public void performBackref(char type) {
            this.loadThreadContext();
            switch (type) {
                case '~': {
                    this.invokeUtilityMethod("backref", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '&': {
                    this.invokeUtilityMethod("backrefLastMatch", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '`': {
                    this.invokeUtilityMethod("backrefMatchPre", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '\'': {
                    this.invokeUtilityMethod("backrefMatchPost", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '+': {
                    this.invokeUtilityMethod("backrefMatchLast", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                default: {
                    throw new NotCompilableException("ERROR: backref with invalid type");
                }
            }
        }

        @Override
        public void callZSuper(CompilerCallback closure) {
            this.loadRuntime();
            this.loadThreadContext();
            if (closure != null) {
                closure.call(this);
            } else {
                this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            }
            this.loadSelf();
            this.invokeUtilityMethod("callZSuper", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, ThreadContext.class, Block.class, IRubyObject.class)));
        }

        @Override
        public void checkIsExceptionHandled() {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadSelf();
            this.invokeUtilityMethod("isExceptionHandled", CodegenUtils.sig(IRubyObject.class, RubyException.class, IRubyObject[].class, Ruby.class, ThreadContext.class, IRubyObject.class));
        }

        @Override
        public void checkIsJavaExceptionHandled() {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadSelf();
            this.invokeUtilityMethod("isJavaExceptionHandled", CodegenUtils.sig(IRubyObject.class, Exception.class, IRubyObject[].class, Ruby.class, ThreadContext.class, IRubyObject.class));
        }

        @Override
        public void rethrowException() {
            this.loadException();
            this.method.athrow();
        }

        @Override
        public void loadClass(String name) {
            this.loadRuntime();
            this.method.ldc(name);
            this.invokeIRuby("getClass", CodegenUtils.sig(RubyClass.class, String.class));
        }

        @Override
        public void unwrapRaiseException() {
            this.method.invokevirtual(CodegenUtils.p(RaiseException.class), "getException", CodegenUtils.sig(RubyException.class, new Class[0]));
        }

        @Override
        public void loadException() {
            this.method.aload(this.getExceptionIndex());
        }

        @Override
        public void setFilePosition(ISourcePosition position) {
            if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
                this.loadThreadContext();
                this.method.ldc(position.getFile());
                this.invokeThreadContext("setFile", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class)));
            }
        }

        @Override
        public void setLinePosition(ISourcePosition position) {
            if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
                if (this.lastPositionLine == position.getStartLine()) {
                    return;
                }
                this.lastPositionLine = position.getStartLine();
                this.loadThreadContext();
                this.method.pushInt(position.getStartLine());
                this.method.invokestatic(StandardASMCompiler.this.classname, "setPosition", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, Integer.TYPE)));
            }
        }

        @Override
        public void checkWhenWithSplat() {
            this.loadThreadContext();
            this.invokeUtilityMethod("isWhenTriggered", CodegenUtils.sig(RubyBoolean.class, IRubyObject.class, IRubyObject.class, ThreadContext.class));
        }

        @Override
        public void issueRetryEvent() {
            this.invokeUtilityMethod("retryJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        }

        @Override
        public void defineNewMethod(String name, int methodArity, StaticScope scope, CompilerCallback body, CompilerCallback args, CompilerCallback receiver, ASTInspector inspector, boolean root) {
            String methodName;
            ++StandardASMCompiler.this.methodIndex;
            if (root && Boolean.getBoolean("jruby.compile.toplevel")) {
                methodName = name;
            } else {
                String mangledName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name);
                methodName = "method__" + StandardASMCompiler.this.methodIndex + "$RUBY$" + mangledName;
            }
            MethodCompiler methodCompiler = StandardASMCompiler.this.startMethod(methodName, args, scope, inspector);
            body.call(methodCompiler);
            methodCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            if (receiver != null) {
                receiver.call(this);
            }
            this.method.aload(0);
            this.method.ldc(name);
            this.method.ldc(methodName);
            StandardASMCompiler.buildStaticScopeNames(this.method, scope);
            this.method.pushInt(methodArity);
            this.method.pushInt(scope.getRequiredArgs());
            this.method.pushInt(scope.getOptionalArgs());
            this.method.pushInt(scope.getRestArg());
            if (inspector.hasFrameAwareMethods() || !inspector.noFrame() && !RubyInstanceConfig.FRAMELESS_COMPILE_ENABLED) {
                if (inspector.hasClosure() || inspector.hasScopeAwareMethods()) {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_AND_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
                } else {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
                }
            } else if (inspector.hasClosure() || inspector.hasScopeAwareMethods()) {
                if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED) {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.SCOPE_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
                } else {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.BACKTRACE_AND_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
                }
            } else if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED || inspector.noFrame()) {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.NO_FRAME_NO_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
            } else {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.BACKTRACE_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
            }
            if (receiver != null) {
                this.invokeUtilityMethod("defs", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
            } else {
                this.invokeUtilityMethod("def", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
            }
        }

        @Override
        public void rethrowIfSystemExit() {
            this.loadRuntime();
            this.method.ldc("SystemExit");
            this.method.invokevirtual(CodegenUtils.p(Ruby.class), "fastGetClass", CodegenUtils.sig(RubyClass.class, String.class));
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
            this.method.iconst_0();
            Label ifEnd = new Label();
            this.method.if_icmpeq(ifEnd);
            this.loadException();
            this.method.athrow();
            this.method.label(ifEnd);
        }

        public class ASMMethodContinuationCompiler
        extends ASMMethodCompiler {
            public ASMMethodContinuationCompiler(String methodName, ASTInspector inspector, StaticScope scope) {
                super(methodName, inspector, scope);
            }

            @Override
            public void endMethod() {
                this.method.areturn();
                Label end = new Label();
                this.method.label(end);
                this.method.end();
            }
        }
    }
}

