/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyException;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.RescueBodyNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.unsafe.UnsafeFactory;

public class RescueNode
extends Node {
    private final Node bodyNode;
    private final RescueBodyNode rescueNode;
    private final Node elseNode;

    public RescueNode(ISourcePosition position, Node bodyNode, RescueBodyNode rescueNode, Node elseNode) {
        super(position, NodeType.RESCUENODE);
        this.bodyNode = bodyNode;
        this.rescueNode = rescueNode;
        this.elseNode = elseNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitRescueNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public RescueBodyNode getRescueNode() {
        return this.rescueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.rescueNode, this.bodyNode, this.elseNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (runtime.getJavaSupport().isActive() && UnsafeFactory.getUnsafe() != null) {
            return this.interpretWithJavaExceptions(runtime, context, self, aBlock);
        }
        return this.interpretWithoutJavaExceptions(runtime, context, self, aBlock);
    }

    private IRubyObject interpretWithoutJavaExceptions(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        while (true) {
            IRubyObject globalExceptionState = runtime.getGlobalVariables().get("$!");
            boolean anotherExceptionRaised = false;
            try {
                IRubyObject iRubyObject = this.executeBody(runtime, context, self, aBlock);
                return iRubyObject;
            }
            catch (RaiseException raiseJump) {
                try {
                    IRubyObject iRubyObject = this.handleException(runtime, context, self, aBlock, raiseJump);
                    return iRubyObject;
                }
                catch (JumpException.RetryJump rj) {
                    continue;
                }
                catch (RaiseException je) {
                    anotherExceptionRaised = true;
                    throw je;
                }
            }
            catch (JumpException.FlowControlException flow) {
                throw flow;
            }
            finally {
                if (anotherExceptionRaised) continue;
                runtime.getGlobalVariables().set("$!", globalExceptionState);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject interpretWithJavaExceptions(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        while (true) {
            IRubyObject globalExceptionState = runtime.getGlobalVariables().get("$!");
            boolean anotherExceptionRaised = false;
            try {
                IRubyObject iRubyObject = this.executeBody(runtime, context, self, aBlock);
                return iRubyObject;
            }
            catch (RaiseException raiseJump) {
                try {
                    IRubyObject iRubyObject = this.handleException(runtime, context, self, aBlock, raiseJump);
                    return iRubyObject;
                }
                catch (JumpException.RetryJump rj) {
                    continue;
                }
                catch (RaiseException je) {
                    anotherExceptionRaised = true;
                    throw je;
                }
            }
            catch (JumpException.FlowControlException flow) {
                throw flow;
            }
            catch (Exception e) {
                try {
                    IRubyObject je = this.handleJavaException(runtime, context, self, aBlock, e);
                    return je;
                }
                catch (JumpException.RetryJump rj) {
                    continue;
                }
                catch (RaiseException je) {
                    anotherExceptionRaised = true;
                    throw je;
                }
            }
            finally {
                if (anotherExceptionRaised) continue;
                runtime.getGlobalVariables().set("$!", globalExceptionState);
                continue;
            }
            break;
        }
    }

    private IRubyObject handleException(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock, RaiseException raiseJump) {
        RubyException raisedException = raiseJump.getException();
        runtime.getGlobalVariables().set("$!", raisedException);
        for (RescueBodyNode cRescueNode = this.rescueNode; cRescueNode != null; cRescueNode = cRescueNode.getOptRescueNode()) {
            IRubyObject[] exceptions = this.getExceptions(cRescueNode, runtime, context, self, aBlock);
            if (!RuntimeHelpers.isExceptionHandled(raisedException, exceptions, runtime, context, self).isTrue()) continue;
            return cRescueNode.interpret(runtime, context, self, aBlock);
        }
        throw raiseJump;
    }

    private IRubyObject handleJavaException(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock, Exception exception) {
        for (RescueBodyNode cRescueNode = this.rescueNode; cRescueNode != null; cRescueNode = cRescueNode.getOptRescueNode()) {
            IRubyObject[] exceptions = this.getExceptions(cRescueNode, runtime, context, self, aBlock);
            if (!RuntimeHelpers.isJavaExceptionHandled(exception, exceptions, runtime, context, self).isTrue()) continue;
            runtime.getGlobalVariables().set("$!", JavaUtil.convertJavaToUsableRubyObject(runtime, exception));
            return cRescueNode.interpret(runtime, context, self, aBlock);
        }
        UnsafeFactory.getUnsafe().throwException(exception);
        throw new RuntimeException("Unsafe.throwException failed");
    }

    private IRubyObject executeBody(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.bodyNode == null) {
            return runtime.getNil();
        }
        IRubyObject result = this.bodyNode.interpret(runtime, context, self, aBlock);
        if (this.elseNode != null) {
            if (this.rescueNode == null) {
                runtime.getWarnings().warn(IRubyWarnings.ID.ELSE_WITHOUT_RESCUE, this.elseNode.getPosition(), "else without rescue is useless", new Object[0]);
            }
            result = this.elseNode.interpret(runtime, context, self, aBlock);
        }
        return result;
    }

    private IRubyObject[] getExceptions(RescueBodyNode cRescueNode, Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        Node exceptionNodes = cRescueNode.getExceptionNodes();
        IRubyObject[] exceptions = exceptionNodes == null ? new IRubyObject[]{runtime.getStandardError()} : ASTInterpreter.setupArgs(runtime, context, exceptionNodes, self, aBlock);
        return exceptions;
    }
}

