/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.ILiteralNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class FixnumNode
extends Node
implements ILiteralNode {
    private long value;
    private RubyFixnum fixnum;

    public FixnumNode(ISourcePosition position, long value) {
        super(position, NodeType.FIXNUMNODE);
        this.value = value;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitFixnumNode(this);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        if (this.fixnum != null) {
            this.fixnum = null;
        }
        this.value = value;
    }

    public RubyFixnum getFixnum(Ruby runtime) {
        if (this.fixnum == null) {
            this.fixnum = RubyFixnum.newFixnum(runtime, this.value);
            return this.fixnum;
        }
        return this.fixnum;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.getFixnum(runtime);
    }
}

