/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyModule(name={"GC"})
public class RubyGC {
    public static RubyModule createGCModule(Ruby runtime) {
        RubyModule result = runtime.defineModule("GC");
        runtime.setGC(result);
        result.defineAnnotatedMethods(RubyGC.class);
        return result;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject start(IRubyObject recv) {
        System.gc();
        return recv.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject garbage_collect(IRubyObject recv) {
        System.gc();
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject enable(IRubyObject recv) {
        recv.getRuntime().getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "GC.enable will not work on JRuby", "GC.enable");
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject disable(IRubyObject recv) {
        recv.getRuntime().getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "GC.disable will not work on JRuby", "GC.disable");
        return recv.getRuntime().getNil();
    }
}

