/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.elements.AstMethodElement;
import org.netbeans.modules.groovy.editor.api.elements.ElementHandleSupport;
import org.netbeans.modules.groovy.editor.api.elements.GroovyElement;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

public abstract class AstElement
extends GroovyElement {
    protected final ASTNode node;
    protected final GroovyParserResult info;
    protected List<AstElement> children;
    protected String name;
    protected Set<Modifier> modifiers;
    protected String in;
    protected String signature;

    public AstElement(GroovyParserResult info, ASTNode node) {
        this.info = info;
        this.node = node;
    }

    public List<AstElement> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public void addChild(AstElement child) {
        if (this.children == null) {
            this.children = new ArrayList<AstElement>();
        }
        this.children.add(child);
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuilder sb = new StringBuilder();
            String clz = this.getIn();
            if (clz != null && clz.length() > 0) {
                sb.append(clz);
                sb.append(".");
            }
            sb.append(this.getName());
            this.signature = sb.toString();
        }
        return this.signature;
    }

    @Override
    public abstract String getName();

    public ASTNode getNode() {
        return this.node;
    }

    @Override
    public String getIn() {
        return this.in;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    @Override
    public Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            int flags = -1;
            if (this.node instanceof FieldNode) {
                flags = ((FieldNode)this.node).getModifiers();
            } else if (this.node instanceof MethodNode) {
                flags = ((MethodNode)this.node).getModifiers();
            }
            if (flags != -1) {
                EnumSet<Modifier> result = EnumSet.noneOf(Modifier.class);
                if ((flags & 1) != 0) {
                    result.add(Modifier.PUBLIC);
                }
                if ((flags & 4) != 0) {
                    result.add(Modifier.PROTECTED);
                }
                if ((flags & 2) != 0) {
                    result.add(Modifier.PRIVATE);
                }
                if ((flags & 8) != 0) {
                    result.add(Modifier.STATIC);
                }
                this.modifiers = result;
            } else {
                this.modifiers = Collections.emptySet();
            }
        }
        return this.modifiers;
    }

    public void setIn(String in) {
        this.in = in;
    }

    @Override
    public boolean signatureEquals(ElementHandle handle) {
        if (handle instanceof AstElement) {
            return this.equals(handle);
        }
        return false;
    }

    @Override
    public FileObject getFileObject() {
        return null;
    }

    public GroovyParserResult getParseResult() {
        return this.info;
    }

    @Override
    public String getMimeType() {
        return "text/x-groovy";
    }

    public static AstElement create(GroovyParserResult info, ASTNode node) {
        if (node instanceof MethodNode) {
            return new AstMethodElement(info, node);
        }
        return null;
    }

    public String toString() {
        return this.getKind() + "<" + this.getName() + ">";
    }

    @Override
    public OffsetRange getOffsetRange(ParserResult result) {
        BaseDocument doc;
        GroovyParserResult parserResult = AstUtilities.getParseResult((Parser.Result)result);
        GroovyElement object = ElementHandleSupport.resolveHandle(parserResult, ElementHandleSupport.createHandle(result, this));
        if (object instanceof AstElement) {
            BaseDocument doc2 = (BaseDocument)result.getSnapshot().getSource().getDocument(false);
            if (doc2 != null) {
                AstElement astElement = (AstElement)object;
                OffsetRange range = AstUtilities.getRange(astElement.getNode(), doc2);
                return LexUtilities.getLexerOffsets(parserResult, range);
            }
            return OffsetRange.NONE;
        }
        if (object != null) {
            Logger logger = Logger.getLogger(AstElement.class.getName());
            logger.log(Level.WARNING, "Foreign element: " + object + " of type " + (object != null ? object.getClass().getName() : "null"));
        } else if (this.getNode() != null && (doc = (BaseDocument)result.getSnapshot().getSource().getDocument(false)) != null) {
            OffsetRange astRange = AstUtilities.getRange(this.getNode(), doc);
            if (astRange != OffsetRange.NONE) {
                GroovyParserResult oldInfo = this.info;
                if (oldInfo == null) {
                    oldInfo = parserResult;
                }
                return LexUtilities.getLexerOffsets(oldInfo, astRange);
            }
            return OffsetRange.NONE;
        }
        return OffsetRange.NONE;
    }
}

