/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.items.form;

import java.io.IOException;
import java.util.Collection;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.api.snippets.SVGSnippetsProvider;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.items.form.SVGComponentDrop;
import org.netbeans.modules.mobility.svgcore.items.form.SVGSnipetsProviderClassic;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.options.SvgcoreSettings;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class SVGFormElement
extends SVGComponentDrop {
    private static final String ID_PATTERN = "%%COMPONENT_ID%%";
    private String myIdPrefix;
    private String mySnippetPath;

    public SVGFormElement(String idPrefix, String snippetPath) {
        assert (idPrefix != null && snippetPath != null) : "id prefix or snippet path == null";
        this.myIdPrefix = idPrefix;
        this.mySnippetPath = snippetPath;
    }

    protected SVGFormElement(String snippetPath) {
        assert (snippetPath != null) : "snippet path == null";
        this.myIdPrefix = "";
        this.mySnippetPath = snippetPath;
    }

    @Override
    protected boolean doTransfer(SVGDataObject svgDataObject) {
        SVGFileModel model = svgDataObject.getModel();
        try {
            String id = model.createUniqueId(this.myIdPrefix, false);
            String snippet = this.getSnippet(id);
            model.mergeImage(snippet, false);
            this.setSelection(id);
            return true;
        }
        catch (Exception ex) {
            SceneManager.error("Error during image merge", ex);
            return false;
        }
    }

    @Override
    protected boolean doTransfer(JTextComponent target) {
        SVGDataObject svgDataObject = SVGDataObject.getActiveDataObject(target);
        final SVGFileModel model = svgDataObject.getModel();
        try {
            String id = model.createUniqueId(this.myIdPrefix, false);
            String snippet = this.getSnippet(id);
            SVGFormElement.insertToTextComponent(snippet, target);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    model.forceUpdateModel();
                }
            });
            return true;
        }
        catch (Exception ex) {
            SceneManager.error("Error during image merge", ex);
            return false;
        }
    }

    protected final String loadSnippetString() throws IOException {
        Class curentSnippetsProviderClass = SVGFormElement.getCurrentSnippetsProviderClass();
        return SVGFormElement.loadSnippetString(curentSnippetsProviderClass, this.mySnippetPath);
    }

    private String getSnippet(String id) throws IOException {
        String text = this.loadSnippetString();
        String withId = text.replace(ID_PATTERN, id);
        return this.replaceCoordinates(withId);
    }

    private static final Class getCurrentSnippetsProviderClass() {
        String providerName = SvgcoreSettings.getDefault().getCurrentSnippet();
        if (providerName == null) {
            return SVGSnipetsProviderClassic.class;
        }
        Collection snippetCollection = Lookup.getDefault().lookupAll(SVGSnippetsProvider.class);
        for (SVGSnippetsProvider provider : snippetCollection) {
            if (!providerName.equals(provider.getDisplayName())) continue;
            return provider.getClass();
        }
        return SVGSnipetsProviderClassic.class;
    }
}

