/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.mobility.svgcore.composer.ActionWrapper;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.openide.filesystems.FileObject;
import org.openide.util.actions.SystemAction;

public final class ActionWrapperFactory {
    private static final String CLASS_EXT = ".class";
    final String m_actionId;
    final int m_toolBarPosition;

    public static ActionWrapperFactory create(FileObject fo) {
        return new ActionWrapperFactory(fo);
    }

    private ActionWrapperFactory(FileObject fo) {
        this.m_actionId = (String)fo.getAttribute("actionId");
        this.m_toolBarPosition = ActionWrapperFactory.getAttribute(fo, "toolBarPosition");
    }

    public ActionWrapper createWrapper(SceneManager smgr) {
        if (this.m_actionId != null) {
            Action action = null;
            if (this.m_actionId.endsWith(CLASS_EXT)) {
                String className = "";
                try {
                    className = this.m_actionId.substring(0, this.m_actionId.length() - CLASS_EXT.length());
                    Class<?> clazz = Class.forName(className);
                    action = SystemAction.get(clazz);
                }
                catch (ClassNotFoundException e) {
                    SceneManager.log(Level.SEVERE, "Class " + className + " not found for actionID " + this.m_actionId, e);
                }
            } else {
                action = smgr.getAction(this.m_actionId);
            }
            if (action != null) {
                return new ActionWrapper(action, this.m_toolBarPosition);
            }
        } else {
            return new ActionWrapper();
        }
        return null;
    }

    private static int getAttribute(FileObject fo, String attrName) {
        Integer pos = (Integer)fo.getAttribute(attrName);
        return pos != null ? pos : -1;
    }
}

