/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.modules.profiler.selector.spi.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.IconResource;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;

public abstract class PackageNode
extends ContainerNode {
    public static final String DEFAULT_NAME = "<default>";
    public static final Comparator COMPARATOR = new Comparator<PackageNode>(){

        @Override
        public int compare(PackageNode o1, PackageNode o2) {
            if (o1.getNodeName().equals(PackageNode.DEFAULT_NAME)) {
                return -1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    protected static final Logger LOGGER = Logger.getLogger(PackageNode.class.getName());

    public PackageNode(String name, ContainerNode parent) {
        super(name, PackageNode.stripName(PackageNode.defaultizeName(name)), (Icon)IconResource.PACKAGE_ICON, parent);
    }

    @Override
    protected final SelectorChildren getChildren() {
        return new PackageChildren();
    }

    protected abstract List<ClassNode> getContainedClasses();

    protected abstract List<PackageNode> getContainedPackages();

    private static String defaultizeName(String name) {
        return name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    private static String stripName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot > -1) {
            return name.substring(lastDot + 1);
        }
        return name;
    }

    private static class PackageChildren
    extends SelectorChildren<PackageNode> {
        private PackageChildren() {
        }

        @Override
        protected List<SelectorNode> prepareChildren(PackageNode parent) {
            ArrayList<SelectorNode> nodes = new ArrayList<SelectorNode>();
            List<PackageNode> subs = this.getSubpackages(parent);
            List<ClassNode> classes = this.getClasses(parent);
            nodes.addAll(subs);
            nodes.addAll(classes);
            return nodes;
        }

        private List<ClassNode> getClasses(PackageNode parent) {
            List<ClassNode> nodes = parent.getContainedClasses();
            Collections.sort(nodes, ClassNode.COMPARATOR);
            return nodes;
        }

        private List<PackageNode> getSubpackages(PackageNode parent) {
            List<PackageNode> nodes = parent.getContainedPackages();
            Collections.sort(nodes, COMPARATOR);
            return nodes;
        }
    }
}

