/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;

public class PropChooser
implements ComponentChooser,
Outputable {
    protected String[] propNames;
    protected Object[][] params;
    protected Class[][] classes;
    protected Object[] results;
    private TestOut output;

    public PropChooser(String[] propNames, Object[][] params, Class[][] classes, Object[] results) {
        this.propNames = propNames;
        this.results = results;
        this.params = params != null ? params : new Object[propNames.length][0];
        if (classes != null) {
            this.classes = classes;
        } else {
            this.classes = new Class[this.params.length][0];
            for (int i = 0; i < this.params.length; ++i) {
                Class[] clsss = new Class[this.params[i].length];
                for (int j = 0; j < this.params[i].length; ++j) {
                    clsss[j] = this.params[i][j].getClass();
                }
                this.classes[i] = clsss;
            }
        }
        this.setOutput(JemmyProperties.getCurrentOutput());
    }

    public PropChooser(String[] propNames, Object[] results) {
        this(propNames, null, null, results);
    }

    public void setOutput(TestOut output) {
        this.output = output;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public boolean checkComponent(Component comp) {
        try {
            String propName = null;
            ClassReference disp = new ClassReference(comp);
            for (int i = 0; i < this.propNames.length; ++i) {
                Object value;
                propName = this.propNames[i];
                if (propName == null) continue;
                if (this.isField(comp, propName, this.classes[i])) {
                    try {
                        value = disp.getField(propName);
                    }
                    catch (IllegalStateException e) {
                        this.output.printStackTrace(e);
                        return false;
                    }
                    catch (NoSuchFieldException e) {
                        this.output.printStackTrace(e);
                        return false;
                    }
                    catch (IllegalAccessException e) {
                        this.output.printStackTrace(e);
                        return false;
                    }
                }
                try {
                    value = disp.invokeMethod(propName, this.params[i], this.classes[i]);
                }
                catch (InvocationTargetException e) {
                    this.output.printStackTrace(e);
                    return false;
                }
                catch (IllegalStateException e) {
                    this.output.printStackTrace(e);
                    return false;
                }
                catch (NoSuchMethodException e) {
                    this.output.printStackTrace(e);
                    return false;
                }
                catch (IllegalAccessException e) {
                    this.output.printStackTrace(e);
                    return false;
                }
                if (this.checkProperty(value, this.results[i])) continue;
                return false;
            }
            return true;
        }
        catch (SecurityException e) {
            this.output.printStackTrace(e);
            return false;
        }
    }

    public String getDescription() {
        String result = "";
        for (int i = 0; i < this.propNames.length; ++i) {
            result = result + " " + this.propNames[i];
        }
        return "Component by properties array\n    :" + result;
    }

    protected boolean checkProperty(Object value, Object etalon) {
        return value.equals(etalon);
    }

    private boolean isField(Component comp, String propName, Class[] params) throws SecurityException {
        try {
            comp.getClass().getField(propName);
            comp.getClass().getMethod(propName, params);
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        return true;
    }
}

