/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.MenuItemUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JMenuItemOperator
extends AbstractButtonOperator
implements Timeoutable,
Outputable {
    private static final long PUSH_MENU_TIMEOUT = 0L;
    private Timeouts timeouts;
    private TestOut output;

    public JMenuItemOperator(JMenuItem item) {
        super(item);
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
    }

    public JMenuItemOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JMenuItem)cont.waitSubComponent(new JMenuItemFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JMenuItemOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JMenuItemOperator(ContainerOperator cont, String text, int index) {
        this((JMenuItem)JMenuItemOperator.waitComponent(cont, (ComponentChooser)new JMenuItemByLabelFinder(text, cont.getComparator()), index));
        this.setTimeouts(cont.getTimeouts());
        this.setOutput(cont.getOutput());
    }

    public JMenuItemOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public JMenuItemOperator(ContainerOperator cont, int index) {
        this((JMenuItem)JMenuItemOperator.waitComponent(cont, (ComponentChooser)new JMenuItemFinder(), index));
        this.copyEnvironment(cont);
    }

    public JMenuItemOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JMenuItem findJMenuItem(Container menu, ComponentChooser chooser, int index) {
        return (JMenuItem)JMenuItemOperator.findComponent(menu, new JMenuItemFinder(chooser), index);
    }

    public static JMenuItem findJMenuItem(Container menu, ComponentChooser chooser) {
        return JMenuItemOperator.findJMenuItem(menu, chooser, 0);
    }

    public static JMenuItem findJMenuItem(Container menu, String text, boolean ce, boolean ccs, int index) {
        return JMenuItemOperator.findJMenuItem(menu, new JMenuItemByLabelFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JMenuItem findJMenuItem(Container menu, String text, boolean ce, boolean ccs) {
        return JMenuItemOperator.findJMenuItem(menu, text, ce, ccs, 0);
    }

    public static JMenuItem waitJMenuItem(Container menu, ComponentChooser chooser, int index) {
        return (JMenuItem)JMenuItemOperator.waitComponent(menu, (ComponentChooser)new JMenuItemFinder(chooser), index);
    }

    public static JMenuItem waitJMenuItem(Container menu, ComponentChooser chooser) {
        return JMenuItemOperator.waitJMenuItem(menu, chooser, 0);
    }

    public static JMenuItem waitJMenuItem(Container menu, String text, boolean ce, boolean ccs, int index) {
        return JMenuItemOperator.waitJMenuItem(menu, new JMenuItemByLabelFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JMenuItem waitJMenuItem(Container menu, String text, boolean ce, boolean ccs) {
        return JMenuItemOperator.waitJMenuItem(menu, text, ce, ccs, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        super.setOutput(out);
        this.output = out;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.remove("Selected");
        return result;
    }

    public void push() {
        this.setVisualizer(new EmptyVisualizer());
        super.push();
    }

    public void pushNoBlock() {
        this.setVisualizer(new EmptyVisualizer());
        super.pushNoBlock();
    }

    public void addMenuDragMouseListener(final MenuDragMouseListener menuDragMouseListener) {
        this.runMapping(new Operator.MapVoidAction("addMenuDragMouseListener"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).addMenuDragMouseListener(menuDragMouseListener);
            }
        });
    }

    public void addMenuKeyListener(final MenuKeyListener menuKeyListener) {
        this.runMapping(new Operator.MapVoidAction("addMenuKeyListener"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).addMenuKeyListener(menuKeyListener);
            }
        });
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.runMapping(new Operator.MapAction("getAccelerator"){

            public Object map() {
                return ((JMenuItem)JMenuItemOperator.this.getSource()).getAccelerator();
            }
        });
    }

    public Component getComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getComponent"){

            public Object map() {
                return ((JMenuItem)JMenuItemOperator.this.getSource()).getComponent();
            }
        });
    }

    public MenuElement[] getSubElements() {
        return (MenuElement[])this.runMapping(new Operator.MapAction("getSubElements"){

            public Object map() {
                return ((JMenuItem)JMenuItemOperator.this.getSource()).getSubElements();
            }
        });
    }

    public boolean isArmed() {
        return this.runMapping(new Operator.MapBooleanAction("isArmed"){

            public boolean map() {
                return ((JMenuItem)JMenuItemOperator.this.getSource()).isArmed();
            }
        });
    }

    public void menuSelectionChanged(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("menuSelectionChanged"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).menuSelectionChanged(b);
            }
        });
    }

    public void processKeyEvent(final KeyEvent keyEvent, final MenuElement[] menuElement, final MenuSelectionManager menuSelectionManager) {
        this.runMapping(new Operator.MapVoidAction("processKeyEvent"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).processKeyEvent(keyEvent, menuElement, menuSelectionManager);
            }
        });
    }

    public void processMenuDragMouseEvent(final MenuDragMouseEvent menuDragMouseEvent) {
        this.runMapping(new Operator.MapVoidAction("processMenuDragMouseEvent"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).processMenuDragMouseEvent(menuDragMouseEvent);
            }
        });
    }

    public void processMenuKeyEvent(final MenuKeyEvent menuKeyEvent) {
        this.runMapping(new Operator.MapVoidAction("processMenuKeyEvent"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).processMenuKeyEvent(menuKeyEvent);
            }
        });
    }

    public void processMouseEvent(final MouseEvent mouseEvent, final MenuElement[] menuElement, final MenuSelectionManager menuSelectionManager) {
        this.runMapping(new Operator.MapVoidAction("processMouseEvent"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).processMouseEvent(mouseEvent, menuElement, menuSelectionManager);
            }
        });
    }

    public void removeMenuDragMouseListener(final MenuDragMouseListener menuDragMouseListener) {
        this.runMapping(new Operator.MapVoidAction("removeMenuDragMouseListener"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).removeMenuDragMouseListener(menuDragMouseListener);
            }
        });
    }

    public void removeMenuKeyListener(final MenuKeyListener menuKeyListener) {
        this.runMapping(new Operator.MapVoidAction("removeMenuKeyListener"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).removeMenuKeyListener(menuKeyListener);
            }
        });
    }

    public void setAccelerator(final KeyStroke keyStroke) {
        this.runMapping(new Operator.MapVoidAction("setAccelerator"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).setAccelerator(keyStroke);
            }
        });
    }

    public void setArmed(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setArmed"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).setArmed(b);
            }
        });
    }

    public void setUI(final MenuItemUI menuItemUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JMenuItem)JMenuItemOperator.this.getSource()).setUI(menuItemUI);
            }
        });
    }

    protected void prepareToClick() {
        this.output.printLine("Push menu item\n    :" + this.toStringSource());
        this.output.printGolden("Push menu item");
        Timeouts times = this.timeouts.cloneThis();
        times.setTimeout("AbstractButtonOperator.PushButtonTimeout", this.timeouts.getTimeout("JMenuItemOperator.PushMenuTimeout"));
        super.setTimeouts(times);
        super.setOutput(this.output.createErrorOutput());
    }

    static JMenuItemOperator[] getMenuItems(Object[] elements, Operator env) {
        int size = 0;
        for (int i = 0; i < elements.length; ++i) {
            if (!(elements[i] instanceof JMenuItem)) continue;
            ++size;
        }
        JMenuItemOperator[] result = new JMenuItemOperator[size];
        int index = 0;
        for (int i = 0; i < elements.length; ++i) {
            if (!(elements[i] instanceof JMenuItem)) continue;
            result[index] = new JMenuItemOperator((JMenuItem)elements[i]);
            result[index].copyEnvironment(env);
            ++index;
        }
        return result;
    }

    static JMenuItemOperator[] getMenuItems(MenuElement parent, Operator env) {
        return JMenuItemOperator.getMenuItems(parent.getSubElements(), env);
    }

    static JMenuItemOperator[] getMenuItems(JMenu parent, Operator env) {
        return JMenuItemOperator.getMenuItems(parent.getMenuComponents(), env);
    }

    static ComponentChooser[] createChoosers(String[] names, Operator.StringComparator comparator) {
        ComponentChooser[] choosers = new ComponentChooser[names.length];
        for (int i = 0; i < choosers.length; ++i) {
            choosers[i] = new JMenuItemByLabelFinder(names[i], comparator);
        }
        return choosers;
    }

    static {
        Timeouts.initDefault("JMenuItemOperator.PushMenuTimeout", 0L);
    }

    public static class JMenuItemFinder
    extends Operator.Finder {
        public JMenuItemFinder(ComponentChooser sf) {
            super(JMenuItem.class, sf);
        }

        public JMenuItemFinder() {
            super(JMenuItem.class);
        }
    }

    public static class JMenuItemByLabelFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public JMenuItemByLabelFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public JMenuItemByLabelFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof JMenuItem && ((JMenuItem)comp).getText() != null) {
                return this.comparator.equals(((JMenuItem)comp).getText(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "JMenuItem with text \"" + this.label + "\"";
        }
    }
}

